/*
 * Decompiled with CFR 0.152.
 */
package sedonac.translate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import sedona.Env;
import sedona.util.TextUtil;
import sedonac.Compiler;
import sedonac.CompilerSupport;
import sedonac.ast.Block;
import sedonac.ast.Expr;
import sedonac.ast.Stmt;
import sedonac.ast.TypeDef;
import sedonac.namespace.Type;

public abstract class AbstractTranslator
extends CompilerSupport {
    public TypeDef type;
    public File outDir;
    public PrintWriter out;
    public int indent;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void translate() throws IOException {
        File file = this.toFile();
        this.log.debug("    Translate [" + file + ']');
        this.out = new PrintWriter(new FileWriter(file));
        try {
            this.header();
            this.doTranslate();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.out.close();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.out.close();
            return;
        }
    }

    public abstract File toFile();

    public abstract void doTranslate();

    public void header() {
        this.w("//").nl();
        this.w("// sedonac translation").nl();
        this.w("// " + Env.timestamp()).nl();
        this.w("//").nl();
        this.nl();
    }

    public void block(Block block) {
        this.indent().w("{").nl();
        ++this.indent;
        this.stmts(block.stmts);
        --this.indent;
        this.indent().w("}").nl();
    }

    public void stmts(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            this.stmt((Stmt)arrayList.get(n));
            ++n;
        }
    }

    public void stmt(Stmt stmt) {
        this.stmt(stmt, true);
    }

    public void stmt(Stmt stmt, boolean bl) {
        switch (stmt.id) {
            case 1: {
                this.exprStmt((Stmt.ExprStmt)stmt, bl);
                break;
            }
            case 2: {
                this.localDef((Stmt.LocalDef)stmt, bl);
                break;
            }
            case 3: {
                this.returnStmt((Stmt.Return)stmt);
                break;
            }
            case 4: {
                this.ifStmt((Stmt.If)stmt);
                break;
            }
            case 5: {
                this.forStmt((Stmt.For)stmt);
                break;
            }
            case 7: {
                this.whileStmt((Stmt.While)stmt);
                break;
            }
            case 9: {
                this.breakStmt((Stmt.Break)stmt);
                break;
            }
            case 10: {
                this.continueStmt((Stmt.Continue)stmt);
                break;
            }
            case 11: {
                this.assertStmt((Stmt.Assert)stmt);
                break;
            }
            default: {
                new IllegalStateException(stmt.toString());
            }
        }
    }

    public void exprStmt(Stmt.ExprStmt exprStmt, boolean bl) {
        if (bl) {
            this.indent();
        }
        this.expr(exprStmt.expr, true);
        if (bl) {
            this.w(";").nl();
        }
    }

    public void localDef(Stmt.LocalDef localDef, boolean bl) {
        if (bl) {
            this.indent();
        }
        this.wtype(localDef.type).w(" ").w(localDef.name);
        if (localDef.init != null) {
            this.w(" = ");
            this.expr(localDef.init, true);
        }
        if (bl) {
            this.w(";").nl();
        }
    }

    public void returnStmt(Stmt.Return return_) {
        this.indent().w("return");
        if (return_.expr != null) {
            this.w(" ");
            this.expr(return_.expr, true);
        }
        this.w(";").nl();
    }

    public void ifStmt(Stmt.If if_) {
        this.indent().w("if (");
        this.expr(if_.cond, true);
        this.w(")").nl();
        this.block(if_.trueBlock);
        if (if_.falseBlock != null) {
            this.indent().w("else").nl();
            this.block(if_.falseBlock);
        }
    }

    public void forStmt(Stmt.For for_) {
        this.indent().w("for (");
        if (for_.init != null) {
            this.stmt(for_.init, false);
        }
        this.w("; ");
        if (for_.cond != null) {
            this.expr(for_.cond, true);
        }
        this.w("; ");
        if (for_.update != null) {
            this.expr(for_.update, true);
        }
        this.w(")").nl();
        this.block(for_.block);
    }

    public void whileStmt(Stmt.While while_) {
        this.indent().w("while (");
        this.expr(while_.cond, true);
        this.w(")").nl();
        this.block(while_.block);
    }

    public void breakStmt(Stmt.Break break_) {
        this.indent().w("break;").nl();
    }

    public void continueStmt(Stmt.Continue continue_) {
        this.indent().w("continue;").nl();
    }

    public void assertStmt(Stmt.Assert assert_) {
        this.indent().w("assert(");
        this.expr(assert_.cond, true);
        this.w(");").nl();
    }

    public Expr expr(Expr expr) {
        return this.expr(expr, false);
    }

    public Expr expr(Expr expr, boolean bl) {
        switch (expr.id) {
            case 1: {
                this.trueLiteral();
                break;
            }
            case 2: {
                this.falseLiteral();
                break;
            }
            case 3: {
                this.intLiteral(((Expr.Literal)expr).asInt());
                break;
            }
            case 5: {
                this.floatLiteral(((Expr.Literal)expr).asFloat());
                break;
            }
            case 8: {
                this.nullLiteral();
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                this.unary((Expr.Unary)expr);
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                this.increment((Expr.Unary)expr);
                break;
            }
            case 27: 
            case 28: {
                this.cond((Expr.Cond)expr, bl);
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.binary((Expr.Binary)expr, bl);
                break;
            }
            case 45: {
                this.assign((Expr.Binary)expr, bl);
                break;
            }
            case 57: {
                this.ternary((Expr.Ternary)expr, bl);
                break;
            }
            case 59: {
                this.param((Expr.Param)expr);
                break;
            }
            case 60: {
                this.local((Expr.Local)expr);
                break;
            }
            case 63: {
                this.field((Expr.Field)expr);
                break;
            }
            case 64: {
                this.index((Expr.Index)expr);
                break;
            }
            case 65: {
                this.call((Expr.Call)expr);
                break;
            }
            case 66: {
                this.cast((Expr.Cast)expr);
                break;
            }
            case 70: {
                this.staticType((Expr.StaticType)expr);
                break;
            }
            default: {
                throw this.err("AbstractTranslator not done: " + expr.id + ' ' + expr.toString(), expr.loc);
            }
        }
        return expr;
    }

    public void trueLiteral() {
        this.w("true");
    }

    public void falseLiteral() {
        this.w("false");
    }

    public void intLiteral(int n) {
        this.w(n);
    }

    public void floatLiteral(float f) {
        this.w(Env.floatFormat((float)f)).w("f");
    }

    public void nullLiteral() {
        this.w("null");
    }

    public void unary(Expr.Unary unary) {
        this.w(unary.op);
        this.w("(");
        this.expr(unary.operand);
        this.w(")");
    }

    public void increment(Expr.Unary unary) {
        if (!unary.isPostfix()) {
            this.w(unary.op);
        }
        this.w("(");
        this.expr(unary.operand);
        this.w(")");
        if (unary.isPostfix()) {
            this.w(unary.op);
        }
    }

    public void cond(Expr.Cond cond, boolean bl) {
        if (!bl) {
            this.w("(");
        }
        int n = 0;
        while (n < cond.operands.size()) {
            if (n > 0) {
                this.w(cond.op);
            }
            this.expr((Expr)cond.operands.get(n));
            ++n;
        }
        if (!bl) {
            this.w(")");
        }
    }

    public void binary(Expr.Binary binary, boolean bl) {
        if (!bl) {
            this.w("(");
        }
        this.expr(binary.lhs);
        this.w(" ").w(binary.op).w(" ");
        this.expr(binary.rhs);
        if (!bl) {
            this.w(")");
        }
    }

    public void assign(Expr.Binary binary, boolean bl) {
        if (!bl) {
            this.w("(");
        }
        this.expr(binary.lhs);
        this.w(" ").w(binary.op).w(" ");
        this.assignNarrow(binary.lhs.type, binary.rhs);
        if (!bl) {
            this.w(")");
        }
    }

    public void assignNarrow(Type type, Expr expr) {
        if (type.isByte()) {
            this.w("(");
            this.expr(expr);
            this.w(" & 0xFF)");
        } else if (type.isShort()) {
            this.w("(");
            this.expr(expr);
            this.w(" & 0xFFFF)");
        } else {
            this.expr(expr);
        }
    }

    public void ternary(Expr.Ternary ternary, boolean bl) {
        if (!bl) {
            this.w("(");
        }
        this.expr(ternary.cond);
        this.w(" ? ");
        this.expr(ternary.trueExpr);
        this.w(" : ");
        this.expr(ternary.falseExpr);
        if (!bl) {
            this.w(")");
        }
    }

    public void param(Expr.Param param) {
        this.w(param.name);
    }

    public void local(Expr.Local local) {
        this.w(local.def.name);
    }

    public void field(Expr.Field field) {
        if (field.target != null) {
            this.expr(field.target);
            this.w(".");
        }
        this.w(field.name);
    }

    public void index(Expr.Index index) {
        this.expr(index.target);
        this.w("[");
        this.expr(index.index);
        this.w("]");
    }

    public void call(Expr.Call call) {
        if (call.target != null) {
            this.expr(call.target);
            this.w(".");
        }
        this.w(call.name);
        this.callArgs(call);
    }

    public void callArgs(Expr.Call call) {
        this.w("(");
        int n = 0;
        while (n < call.args.length) {
            if (n > 0) {
                this.w(", ");
            }
            this.expr(call.args[n]);
            ++n;
        }
        this.w(")");
    }

    public void cast(Expr.Cast cast) {
        this.w("((");
        this.wtype(cast.type);
        this.w(")");
        this.expr(cast.target);
        this.w(")");
    }

    public void staticType(Expr.StaticType staticType) {
        this.wtype(staticType.type);
    }

    public abstract String toType(Type var1);

    public AbstractTranslator w(Object object) {
        this.out.print(object);
        return this;
    }

    public AbstractTranslator w(int n) {
        this.out.print(n);
        return this;
    }

    public AbstractTranslator wtype(Type type) {
        this.out.print(this.toType(type));
        return this;
    }

    public AbstractTranslator indent() {
        this.out.print(TextUtil.getSpaces((int)(this.indent * 2)));
        return this;
    }

    public AbstractTranslator nl() {
        this.out.println();
        return this;
    }

    public AbstractTranslator(Compiler compiler, TypeDef typeDef) {
        super(compiler);
        this.type = typeDef;
        this.outDir = compiler.translation.outDir;
    }
}

