/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import sedona.kit.KitDb;
import sedona.manifest.KitManifest;
import sedona.manifest.ManifestDb;
import sedona.util.FileUtil;
import sedona.util.Log;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XWriter;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.steps.WriteDoc;

public class TableOfContents
extends CompilerStep {
    boolean www;
    File tocFile;
    File dir;
    File outDir;
    XElem xml;
    Section[] sections;
    Chapter[] chapters;
    HashMap chaptersByHref;

    public void run() {
        try {
            this.www = this.compiler.www;
            this.xml = this.compiler.xml;
            this.tocFile = this.compiler.input;
            this.dir = this.tocFile.getParentFile();
            this.outDir = this.compiler.outDir;
            if (this.outDir == null) {
                this.outDir = this.dir;
            }
            if (!this.outDir.exists()) {
                this.outDir.mkdirs();
            }
            new File(this.outDir, "api.html").delete();
            this.log.info("  TableOfContents [" + this.dir + " -> " + this.outDir + ']');
            this.parseXml();
            this.flattenChapters();
            this.processHtml();
            this.writeDocIndex();
            this.writeApiIndex();
            if (this.www) {
                this.copyResources();
            }
            this.quitIfErrors();
        }
        catch (XException xException) {
            throw this.err(xException);
        }
        catch (CompilerException compilerException) {
            throw compilerException;
        }
        catch (Exception exception) {
            throw this.err("Cannot generate docs", new Location(this.tocFile), (Throwable)exception);
        }
    }

    private final void parseXml() {
        XElem[] xElemArray = this.xml.elems("section");
        this.sections = new Section[xElemArray.length];
        int n = 0;
        while (n < xElemArray.length) {
            this.sections[n] = this.toSection(xElemArray[n]);
            ++n;
        }
    }

    private final Section toSection(XElem xElem) {
        XElem[] xElemArray = xElem.elems("chapter");
        Section section = new Section();
        section.name = xElem.get("name");
        section.chapters = new Chapter[xElemArray.length];
        int n = 0;
        while (n < xElemArray.length) {
            section.chapters[n] = this.toChapter(xElemArray[n]);
            ++n;
        }
        return section;
    }

    private final Chapter toChapter(XElem xElem) {
        Chapter chapter = new Chapter();
        chapter.name = xElem.get("name");
        chapter.href = xElem.get("href");
        chapter.blurb = xElem.get("blurb");
        return chapter;
    }

    private final void flattenChapters() {
        Object object;
        ArrayList<Chapter> arrayList = new ArrayList<Chapter>();
        int n = 0;
        while (n < this.sections.length) {
            object = this.sections[n];
            int n2 = 0;
            while (n2 < ((Section)object).chapters.length) {
                arrayList.add(((Section)object).chapters[n2]);
                ++n2;
            }
            ++n;
        }
        this.chapters = arrayList.toArray(new Chapter[arrayList.size()]);
        this.chaptersByHref = new HashMap();
        n = 0;
        while (n < this.chapters.length) {
            object = this.chapters[n];
            if (n > 0) {
                ((Chapter)object).prev = this.chapters[n - 1];
            }
            if (n + 1 < this.chapters.length) {
                ((Chapter)object).next = this.chapters[n + 1];
            }
            this.chaptersByHref.put(((Chapter)object).href, object);
            ++n;
        }
    }

    private final void processHtml() {
        File[] fileArray = this.dir.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            String string = file.getName();
            if (string.endsWith(".html") && !string.equals("index.html")) {
                try {
                    this.processHtml(file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw this.err("Cannot process file", new Location(file), (Throwable)exception);
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processHtml(File file) throws Exception {
        this.log.debug("    " + file);
        Chapter chapter = (Chapter)this.chaptersByHref.get(file.getName());
        if (chapter == null) {
            if (file.getName().equals("api.html")) return;
            this.err("Chapter not mapped in toc.xml", new Location(file));
            return;
        }
        chapter.used = true;
        String[] stringArray = FileUtil.readLines((File)file);
        XWriter xWriter = new XWriter(new File(this.outDir, file.getName()));
        try {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            while (true) {
                block15: {
                    if (n < stringArray.length) break block15;
                    if (!bl2 || !bl3) {
                        this.err("Missing header/footer comments", new Location(file));
                    }
                    break;
                }
                String string = stringArray[n];
                if (string.indexOf("TOC-HEADER-START") >= 0) {
                    this.writeHeader(xWriter, chapter);
                    bl = true;
                } else if (string.indexOf("TOC-HEADER-END") >= 0) {
                    bl = false;
                    bl2 = true;
                } else if (string.indexOf("TOC-FOOTER-START") >= 0) {
                    this.writeFooter(xWriter, chapter);
                    bl = true;
                } else if (string.indexOf("TOC-FOOTER-END") >= 0) {
                    bl = false;
                    bl3 = true;
                } else if (!bl) {
                    xWriter.w((Object)string);
                    xWriter.w((Object)"\n");
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            xWriter.close();
            throw throwable;
        }
        {
            Object var6_12 = null;
        }
        xWriter.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeDocIndex() {
        File file = new File(this.outDir, "index.html");
        XWriter xWriter = null;
        try {
            try {
                xWriter = new XWriter(file);
                this.writeDocIndex(xWriter);
            }
            catch (Exception exception) {
                throw this.err("Cannot write doc index", new Location(file));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                xWriter.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        xWriter.close();
    }

    private final void writeDocIndex(XWriter xWriter) {
        xWriter.w((Object)"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n");
        xWriter.w((Object)"  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
        xWriter.w((Object)"\n");
        xWriter.w((Object)"<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
        xWriter.w((Object)"<!-- Auto-generated by sedonac -->\n");
        xWriter.w((Object)"<head>\n");
        xWriter.w((Object)"  <title>Sedona Index</title>\n");
        xWriter.w((Object)"  <meta http-equiv='Content-type' content='text/html;charset=UTF-8' />\n");
        xWriter.w((Object)"  <link rel='stylesheet' type='text/css' href='style.css'/>\n");
        xWriter.w((Object)"</head>\n");
        xWriter.w((Object)"<body>\n");
        this.header(xWriter);
        xWriter.w((Object)"  <h1>API</h1>\n");
        xWriter.w((Object)"  <ul>\n");
        xWriter.w((Object)"    <li><b><a href='api.html'>API Index</a></b>: API for each kit</li>\n");
        xWriter.w((Object)"  </ul>\n");
        int n = 0;
        while (n < this.sections.length) {
            Section section = this.sections[n];
            xWriter.w((Object)"\n");
            xWriter.w((Object)("  <h1>" + section.name + "</h1>\n"));
            xWriter.w((Object)"  <ul>\n");
            int n2 = 0;
            while (n2 < section.chapters.length) {
                Chapter chapter = section.chapters[n2];
                xWriter.w((Object)("  <li><b><a href='" + chapter.href + "'>" + chapter.name + "</a></b>: " + chapter.blurb + "</li>\n"));
                ++n2;
            }
            xWriter.w((Object)"  </ul>\n");
            ++n;
        }
        this.writeCopyright(xWriter);
        xWriter.w((Object)"</body>\n");
        xWriter.w((Object)"</html>\n");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeApiIndex() {
        File file = new File(this.outDir, "api.html");
        XWriter xWriter = null;
        try {
            try {
                xWriter = new XWriter(file);
                this.writeApiIndex(xWriter);
            }
            catch (Exception exception) {
                throw this.err("Cannot write api index", new Location(file));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                xWriter.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        xWriter.close();
    }

    private final void writeApiIndex(XWriter xWriter) {
        xWriter.w((Object)"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n");
        xWriter.w((Object)"  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
        xWriter.w((Object)"\n");
        xWriter.w((Object)"<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
        xWriter.w((Object)"<!-- Auto-generated by sedonac -->\n");
        xWriter.w((Object)"<head>\n");
        xWriter.w((Object)"  <title>Sedona API Index</title>\n");
        xWriter.w((Object)"  <meta http-equiv='Content-type' content='text/html;charset=UTF-8' />\n");
        xWriter.w((Object)"  <link rel='stylesheet' type='text/css' href='style.css'/>\n");
        xWriter.w((Object)"</head>\n");
        xWriter.w((Object)"<body>\n");
        this.header(xWriter);
        this.nav(xWriter, null, null);
        xWriter.w((Object)"<h1>Kits</h1>\n");
        xWriter.w((Object)"<ul>\n");
        String[] stringArray = KitDb.kits();
        int n = 0;
        while (n < stringArray.length) {
            try {
                KitManifest kitManifest = ManifestDb.loadForLocalKit((String)stringArray[n]);
                if (kitManifest.doc) {
                    xWriter.w((Object)("  <li><b><a href='" + kitManifest.name + "/index.html'>" + kitManifest.name + "</a></b></li>\n"));
                }
            }
            catch (Exception exception) {
                System.out.println("ERROR: " + exception);
            }
            ++n;
        }
        xWriter.w((Object)"</ul>\n");
        this.nav(xWriter, null, null);
        this.writeCopyright(xWriter);
        xWriter.w((Object)"</body>\n");
        xWriter.w((Object)"</html>\n");
    }

    private final void copyResources() {
        this.copyResources(".css");
        this.copyResources(".png");
    }

    private final void copyResources(String string) {
        File[] fileArray = this.dir.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].getName().endsWith(string)) {
                try {
                    FileUtil.copy((File)fileArray[n], (File)new File(this.outDir, fileArray[n].getName()), (Log)this.compiler.log);
                }
                catch (IOException iOException) {
                    throw this.err("Cannot copy file", new Location(fileArray[n]));
                }
            }
            ++n;
        }
    }

    private final void writeHeader(XWriter xWriter, Chapter chapter) {
        xWriter.w((Object)"<!-- TOC-HEADER-START -->\n");
        xWriter.w((Object)"<!-- Auto-generated by sedonac -->\n");
        xWriter.w((Object)"<head>\n");
        xWriter.w((Object)("  <title>" + chapter.name + "</title>\n"));
        xWriter.w((Object)"  <meta http-equiv='Content-type' content='text/html;charset=UTF-8' />\n");
        xWriter.w((Object)"  <link rel='stylesheet' type='text/css' href='style.css'/>\n");
        xWriter.w((Object)"</head>\n");
        xWriter.w((Object)"<body>\n");
        this.header(xWriter);
        this.nav(xWriter, chapter);
        xWriter.w((Object)("<h1 class='title'>" + chapter.name + "</h1>\n"));
        xWriter.w((Object)"<div class='content'>\n");
        xWriter.w((Object)"<!-- TOC-HEADER-END -->\n");
    }

    private final void writeFooter(XWriter xWriter, Chapter chapter) {
        xWriter.w((Object)"<!-- TOC-FOOTER-START -->\n");
        xWriter.w((Object)"<!-- Auto-generated by sedonac -->\n");
        xWriter.w((Object)"</div>\n");
        this.nav(xWriter, chapter);
        this.writeCopyright(xWriter);
        xWriter.w((Object)"</body>\n");
        xWriter.w((Object)"<!-- TOC-FOOTER-END -->\n");
    }

    private final void writeCopyright(XWriter xWriter) {
        WriteDoc.writeCopyright(xWriter);
    }

    private final void header(XWriter xWriter) {
        String string = this.www ? "../index.html" : "index.html";
        xWriter.w((Object)"<p>\n");
        xWriter.w((Object)"  <a href='").w((Object)string).w((Object)"'>\n");
        xWriter.w((Object)"    <img src='logo.png' alt='Sedona'/>\n");
        xWriter.w((Object)"  </a>\n");
        xWriter.w((Object)"</p>\n");
        if (this.www) {
            xWriter.w((Object)"<ul class='tabs'>\n");
            xWriter.w((Object)"  <li><a href='").w((Object)string).w((Object)"'>Home</a></li>\n");
            xWriter.w((Object)"  <li><a class='active' href='index.html'>Documentation</a></li>\n");
            xWriter.w((Object)"  <li><a href='../community.html'>Community</a></li>\n");
            xWriter.w((Object)"  <li><a href='/download/'>Download</a></li>\n");
            xWriter.w((Object)"  <li><a href='http://groups.google.com/group/sedonadev'>Forum</a></li>\n");
            xWriter.w((Object)"</ul>\n");
        }
    }

    private final void nav(XWriter xWriter, Chapter chapter) {
        this.nav(xWriter, chapter.prev == null ? null : chapter.prev.href, chapter.next == null ? null : chapter.next.href);
    }

    private final void nav(XWriter xWriter, String string, String string2) {
        if (this.www) {
            this.wwwNav(xWriter, string, string2);
        } else {
            this.normNav(xWriter, string, string2);
        }
    }

    private final void normNav(XWriter xWriter, String string, String string2) {
        xWriter.w((Object)"<div class='nav'>\n");
        xWriter.w((Object)"  <a href='index.html'>Index</a>\n");
        if (string != null) {
            xWriter.w((Object)(" | <a href='" + string + "'>Prev</a>\n"));
        }
        if (string2 != null) {
            xWriter.w((Object)(" | <a href='" + string2 + "'>Next</a>\n"));
        }
        xWriter.w((Object)"</div>\n");
    }

    private final void wwwNav(XWriter xWriter, String string, String string2) {
        xWriter.w((Object)"<div class='nav'>\n");
        xWriter.w((Object)"  <a href='index.html'>Index</a>\n");
        if (string != null) {
            xWriter.w((Object)(" | <a href='" + string + "'>Prev</a>\n"));
        }
        if (string2 != null) {
            xWriter.w((Object)(" | <a href='" + string2 + "'>Next</a>\n"));
        }
        xWriter.w((Object)"</div>\n");
    }

    public TableOfContents(Compiler compiler) {
        super(compiler);
    }

    static class Section {
        String name;
        Chapter[] chapters;

        Section() {
        }
    }

    static class Chapter {
        String name;
        String href;
        String blurb;
        Chapter prev;
        Chapter next;
        boolean used;

        Chapter() {
        }
    }
}

