/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import sedona.Bool;
import sedona.Facets;
import sedona.Value;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.ast.Expr;
import sedonac.ast.FacetDef;
import sedonac.ast.FacetsNode;
import sedonac.ast.FieldDef;
import sedonac.ast.MethodDef;
import sedonac.ast.TypeDef;
import sedonac.namespace.TypeUtil;

public class ResolveFacets
extends CompilerStep {
    public void run() {
        this.log.debug("  ResolveFacets");
        this.walkAst(2);
        this.quitIfErrors();
    }

    public void enterType(TypeDef typeDef) {
        super.enterType(typeDef);
        this.resolve(typeDef);
    }

    public void enterField(FieldDef fieldDef) {
        super.enterField(fieldDef);
        this.resolve(fieldDef);
        fieldDef.setRtFlags(TypeUtil.rtFlags(fieldDef, fieldDef.facets()));
    }

    public void enterMethod(MethodDef methodDef) {
        super.enterMethod(methodDef);
        this.resolve(methodDef);
        methodDef.setRtFlags(TypeUtil.rtFlags(methodDef, methodDef.facets()));
    }

    void resolve(FacetsNode facetsNode) {
        if (facetsNode.facetDefs.length == 0) {
            facetsNode.setResolvedFacets(Facets.empty);
            return;
        }
        Facets facets = new Facets();
        int n = 0;
        while (n < facetsNode.facetDefs.length) {
            FacetDef facetDef = facetsNode.facetDefs[n];
            if (facets.get(facetDef.name) != null) {
                this.err("Duplicate facet name '" + facetDef.name + '\'', facetDef.loc);
            }
            facets.set(facetDef.name, this.resolve(facetDef));
            ++n;
        }
        facetsNode.setResolvedFacets(facets);
    }

    Value resolve(FacetDef facetDef) {
        Expr.Literal literal = facetDef.val.toLiteral();
        if (literal == null) {
            this.err("Facet value must be a literal", facetDef.loc);
            return Bool.TRUE;
        }
        return literal.toValue();
    }

    public ResolveFacets(Compiler compiler) {
        super(compiler);
    }
}

