/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ast.AstNode;
import sedonac.ast.Block;
import sedonac.ast.Expr;
import sedonac.ast.FieldDef;
import sedonac.ast.MethodDef;
import sedonac.ast.Stmt;
import sedonac.ast.TypeDef;
import sedonac.namespace.ArrayType;
import sedonac.namespace.Method;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;
import sedonac.parser.Token;

public class Normalize
extends CompilerStep {
    public void run() {
        this.walkAst(2);
        this.quitIfErrors();
    }

    public void enterType(TypeDef typeDef) {
        super.enterType(typeDef);
        MethodDef methodDef = (MethodDef)typeDef.slot("_iInit");
        if (methodDef != null) {
            this.processCtor(methodDef);
        }
    }

    private final void processCtor(MethodDef methodDef) {
        this.checkArrayLengthAssignment(methodDef);
    }

    private final void checkArrayLengthAssignment(MethodDef methodDef) {
        int n = 0;
        while (n < methodDef.code.stmts.size()) {
            Stmt stmt = (Stmt)methodDef.code.stmts.get(n);
            if (stmt.id == 1) {
                Expr expr = ((Stmt.ExprStmt)stmt).expr;
                if (expr.id == 45) {
                    Expr.Binary binary = (Expr.Binary)expr;
                    if (binary.lhs.id == 58) {
                        Expr.Name name = (Expr.Name)binary.lhs;
                        if (name.target != null && name.name.equals("length") && name.target.id == 58) {
                            Expr.Name name2 = (Expr.Name)name.target;
                            Slot slot = this.curType.slot(name2.name);
                            if (slot != null && slot instanceof FieldDef) {
                                FieldDef fieldDef = (FieldDef)slot;
                                if (fieldDef.type.isArray()) {
                                    if (fieldDef.isStatic()) {
                                        this.err("Cannot specify length of static field", binary.loc);
                                    } else if (name2.target != null && name2.target.id != 61) {
                                        this.err("Cannot specify length of field not owned by this instance", binary.loc);
                                    } else {
                                        if (binary.rhs.id == 58) {
                                            Expr.Name name3 = (Expr.Name)binary.rhs;
                                            int n2 = 0;
                                            while (n2 < methodDef.params.length) {
                                                if (methodDef.params[n2].name.equals(name3.name)) {
                                                    fieldDef.ctorLengthParam = n2 + 1;
                                                    methodDef.code.stmts.remove(n);
                                                    return;
                                                }
                                                ++n2;
                                            }
                                        }
                                        this.err("Right hand side of array length assignment must be parameter", binary.loc);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++n;
        }
    }

    public void enterField(FieldDef fieldDef) {
        super.enterField(fieldDef);
        if (fieldDef.init != null && !fieldDef.isDefine()) {
            if (fieldDef.init.id == 67) {
                this.initFieldArray(fieldDef);
            } else if (fieldDef.init.id == 9) {
                this.initFieldInstance(fieldDef);
                this.initFieldStr(fieldDef);
            } else if (fieldDef.init.id == 10) {
                this.initFieldBuf(fieldDef);
            } else {
                this.initFieldExpr(fieldDef);
            }
        } else if (fieldDef.isInline() && !fieldDef.type.isArray()) {
            this.initFieldInstance(fieldDef);
        }
    }

    private final void initFieldExpr(FieldDef fieldDef) {
        Location location = fieldDef.init.loc;
        Expr expr = this.toFieldExpr(location, fieldDef);
        Expr expr2 = fieldDef.init;
        Expr.Binary binary = new Expr.Binary(location, new Token(location, 46), expr, expr2);
        MethodDef methodDef = this.makeInitMethod(fieldDef);
        methodDef.code.add(methodDef.initStmtIndex++, binary.toStmt());
    }

    private final void initFieldBuf(FieldDef fieldDef) {
        if (!fieldDef.type.isBuf() || fieldDef.init.id != 10) {
            return;
        }
        if (fieldDef.isStatic()) {
            this.initFieldExpr(fieldDef);
        } else if (fieldDef.isInline()) {
            this.initFieldInstance(fieldDef);
            Location location = fieldDef.init.loc;
            Integer n = fieldDef.ctorArgs[0].toIntLiteral();
            if (n == null) {
                return;
            }
            Method method = (Method)fieldDef.type.slot("copyFromBuf");
            Expr.Call call = new Expr.Call(location, this.toFieldExpr(location, fieldDef), method, new Expr[]{fieldDef.init});
            MethodDef methodDef = this.makeInitMethod(fieldDef);
            methodDef.code.add(methodDef.initStmtIndex++, call.toStmt());
        }
    }

    private final void initFieldStr(FieldDef fieldDef) {
        AstNode astNode;
        if (!fieldDef.type.isBuf() && !fieldDef.type.isStr() || !fieldDef.isInline() || fieldDef.init.id != 9) {
            return;
        }
        Location location = fieldDef.init.loc;
        if (fieldDef.ctorArgs == null || fieldDef.ctorArgs.length == 0) {
            return;
        }
        Method method = (Method)fieldDef.type.slot("copyFromStr");
        Expr.Call call = null;
        if (fieldDef.type.isBuf()) {
            call = new Expr.Call(location, this.toFieldExpr(location, fieldDef), method, new Expr[]{fieldDef.init});
        } else {
            astNode = fieldDef.ctorArgs[0];
            call = new Expr.Call(location, this.toFieldExpr(location, fieldDef), method, new Expr[]{fieldDef.init, astNode});
        }
        astNode = this.makeInitMethod(fieldDef);
        ((MethodDef)astNode).code.add(((MethodDef)astNode).initStmtIndex++, call.toStmt());
    }

    private final void initFieldArray(FieldDef fieldDef) {
        Object object;
        if (!fieldDef.type.isArray() || !fieldDef.type.arrayOf().isRef()) {
            return;
        }
        Location location = fieldDef.init.loc;
        Type type = fieldDef.type.arrayOf();
        ArrayType.Len len = fieldDef.type.arrayLength();
        Method method = (Method)type.slot("_iInit");
        if (method.numParams() > 1) {
            this.err("Cannot create an initialized field array of type '" + type + "' because its constructor takes arguments", fieldDef.loc);
            return;
        }
        Expr.InitArray initArray = (Expr.InitArray)fieldDef.init;
        initArray.field = this.toFieldExpr(location, fieldDef);
        if (len instanceof ArrayType.LiteralLen) {
            object = (ArrayType.LiteralLen)len;
            initArray.length = new Expr.Literal(location, this.ns, 3, (Object)new Integer(((ArrayType.LiteralLen)object).val));
        } else {
            object = (ArrayType.DefineLen)len;
            initArray.length = new Expr.Field(location, null, ((ArrayType.DefineLen)object).field);
        }
        object = new Stmt.Foreach(location);
        ((Stmt.Foreach)object).local = new Stmt.LocalDef(location, type, "_item");
        ((Stmt.Foreach)object).array = this.toFieldExpr(location, fieldDef);
        ((Stmt.Foreach)object).block = new Block(location);
        ((Stmt.Foreach)object).block.add(new Expr.Call(location, (Expr)new Expr.Local(location, ((Stmt.Foreach)object).local), method, new Expr[0]).toStmt());
        MethodDef methodDef = this.makeInitMethod(fieldDef);
        methodDef.code.add(methodDef.initStmtIndex++, initArray.toStmt());
        methodDef.code.add(methodDef.initStmtIndex++, (Stmt)object);
    }

    private final void initFieldInstance(FieldDef fieldDef) {
        Location location = fieldDef.loc;
        Type type = fieldDef.type;
        Method method = (Method)type.slot("_iInit");
        if (method == null) {
            System.out.println("WARNING: missing instance init: " + type);
            return;
        }
        Expr expr = this.toFieldExpr(location, fieldDef);
        Expr[] exprArray = fieldDef.ctorArgs;
        if (exprArray == null) {
            exprArray = new Expr[]{};
        }
        Expr.Call call = new Expr.Call(location, expr, method, exprArray);
        MethodDef methodDef = this.makeInitMethod(fieldDef);
        methodDef.code.add(methodDef.initStmtIndex++, call.toStmt());
    }

    private final MethodDef makeInitMethod(FieldDef fieldDef) {
        return fieldDef.isStatic() ? this.curType.makeStaticInit(this.ns) : this.curType.makeInstanceInit(this.ns);
    }

    private final Expr toFieldExpr(Location location, FieldDef fieldDef) {
        Expr.This this_ = fieldDef.isStatic() ? null : new Expr.This(location);
        return new Expr.Field(location, (Expr)this_, fieldDef);
    }

    public void enterMethod(MethodDef methodDef) {
        super.enterMethod(methodDef);
        this.checkReturn(methodDef);
    }

    private final void checkReturn(MethodDef methodDef) {
        if (methodDef.code == null) {
            return;
        }
        if (methodDef.code.isExit()) {
            return;
        }
        methodDef.code.add(new Stmt.Return(methodDef.loc));
    }

    public Normalize(Compiler compiler) {
        super(compiler);
    }
}

