/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import sedona.Depend;
import sedona.Env;
import sedona.kit.KitDb;
import sedona.kit.KitFile;
import sedona.util.FileUtil;
import sedona.util.Log;
import sedona.util.VendorUtil;
import sedona.xml.XContent;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XParser;
import sedonac.Compiler;
import sedonac.Location;
import sedonac.ir.IrKit;
import sedonac.platform.PlatformDef;
import sedonac.steps.InitImageCompile;
import sedonac.util.VarResolver;

public class InitStagePlatform
extends InitImageCompile {
    public void run() {
        try {
            this.log.info("  InitStagePlatform [" + this.xmlFile.getName() + ']');
            if (this.compiler.outDir == null) {
                throw this.err("Must specify target directory via -outDir", new Location("compiler args"));
            }
            this.makeStageDirs();
            PlatformDef platformDef = this.compiler.platform = this.parsePlatformDef();
            IrKit[] irKitArray = new IrKit[platformDef.nativeKits.length];
            int n = 0;
            while (n < irKitArray.length) {
                Depend depend = platformDef.nativeKits[n];
                KitFile kitFile = KitDb.matchBest((Depend)depend);
                if (kitFile == null) {
                    this.err("Missing kit dependency '" + depend + '\'', new Location(this.xml));
                } else {
                    irKitArray[n] = new IrKit(new Location(this.xml), kitFile);
                }
                ++n;
            }
            this.compiler.kits = irKitArray;
            this.quitIfErrors();
        }
        catch (XException xException) {
            throw this.err(xException);
        }
    }

    private final void makeStageDirs() {
        try {
            FileUtil.delete((File)this.compiler.outDir, (Log)this.log);
        }
        catch (IOException iOException) {
            this.err("Cannot delete stage dir", new Location(this.compiler.outDir));
        }
        File file = null;
        try {
            file = new File(new File(this.compiler.outDir, ".par"), "svm");
            FileUtil.mkdir((File)file, (Log)this.log);
        }
        catch (IOException iOException) {
            this.err("Cannot make stage dir", new Location(file));
        }
    }

    private final PlatformDef parsePlatformDef() {
        PlatformDef platformDef = new PlatformDef();
        platformDef.vendor = this.xml.get("vendor");
        platformDef.idPattern = this.xml.get("id", null);
        this.parseCompile(platformDef, this.xml.elem("compile", true));
        this.parseManifestIncludes(platformDef, this.xml.elems("manifestInclude"));
        this.checkVendor(platformDef);
        return platformDef;
    }

    private final void parseCompile(PlatformDef platformDef, XElem xElem) {
        VarResolver varResolver = new VarResolver();
        platformDef.refSize = xElem.geti("refSize");
        platformDef.blockSize = xElem.geti("blockSize");
        platformDef.endian = xElem.get("endian");
        platformDef.armDouble = xElem.getb("armDouble", platformDef.armDouble);
        platformDef.debug = xElem.getb("debug", platformDef.debug);
        platformDef.test = xElem.getb("test", platformDef.test);
        XElem[] xElemArray = xElem.elems("nativeKit");
        Depend[] dependArray = new Depend[xElemArray.length];
        int n = 0;
        while (n < xElemArray.length) {
            dependArray[n] = xElemArray[n].getDepend("depend");
            ++n;
        }
        platformDef.nativeKits = dependArray;
        xElemArray = xElem.elems("nativeSource");
        String[] stringArray = new String[xElemArray.length];
        try {
            int n2 = 0;
            while (n2 < xElemArray.length) {
                stringArray[n2] = varResolver.resolve(xElemArray[n2].get("path"));
                ++n2;
            }
            platformDef.nativePaths = stringArray;
        }
        catch (Exception exception) {
            throw this.err(exception.getMessage());
        }
        xElemArray = xElem.elems("nativePatch");
        String[] stringArray2 = new String[xElemArray.length];
        int n3 = 0;
        while (n3 < xElemArray.length) {
            stringArray2[n3] = xElemArray[n3].get("qname");
            ++n3;
        }
        platformDef.nativePatches = stringArray2;
        if (!"big".equals(platformDef.endian) && !"little".equals(platformDef.endian)) {
            throw new XException("compile.endian must be 'big' or 'little'", xElem);
        }
        if (platformDef.nativeKits == null || platformDef.nativeKits.length == 0) {
            throw new XException("no compile.nativeKit elements defined", xElem);
        }
        if (xElem.elems("include").length > 0) {
            throw new XException("<include> is no longer supported.", xElem);
        }
    }

    private final void parseManifestIncludes(PlatformDef platformDef, XElem[] xElemArray) {
        ArrayList<XElem> arrayList = new ArrayList<XElem>();
        int n = 0;
        while (n < xElemArray.length) {
            String string = xElemArray[n].get("path", null);
            if (string != null) {
                arrayList.add(this.resolveManifestInclude(string));
            }
            XElem[] xElemArray2 = xElemArray[n].elems();
            int n2 = 0;
            while (n2 < xElemArray2.length) {
                arrayList.add(xElemArray2[n2]);
                xElemArray[n].removeContent((XContent)xElemArray2[n2]);
                ++n2;
            }
            ++n;
        }
        platformDef.manifestIncludes = arrayList.toArray(new XElem[arrayList.size()]);
    }

    private final XElem resolveManifestInclude(String string) {
        Location location = new Location(this.xmlFile);
        File file = null;
        file = !string.startsWith("/") ? new File(this.xmlDir, string) : new File(Env.home, string.substring(1));
        try {
            return XParser.make((File)file).parse();
        }
        catch (Exception exception) {
            throw this.err("Could not include '" + string + '\'', location, (Throwable)exception);
        }
    }

    private final void checkVendor(PlatformDef platformDef) {
        Location location = new Location(this.xmlFile);
        try {
            VendorUtil.checkVendorName((String)platformDef.vendor);
            VendorUtil.checkPlatformPrefix((String)platformDef.vendor, (String)platformDef.idPattern);
        }
        catch (Exception exception) {
            throw this.err(exception.getMessage(), location);
        }
    }

    public InitStagePlatform(Compiler compiler) {
        super(compiler);
    }
}

