/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import sedona.Depend;
import sedona.kit.KitDb;
import sedona.kit.KitFile;
import sedona.util.Version;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ir.IrKit;
import sedonac.scode.SCodeImage;

public class InitImageCompile
extends CompilerStep {
    File xmlFile;
    File xmlDir;
    XElem xml;
    KitFile sysKit;

    public void run() {
        try {
            this.log.debug("  InitImageCompile");
            this.initImage();
            this.initKits();
            this.initResume();
        }
        catch (XException xException) {
            throw this.err(xException);
        }
    }

    private final void initImage() {
        SCodeImage sCodeImage = new SCodeImage();
        if (this.xml.get("name", null) != null) {
            this.compiler.warn("'name' attribute is deprecated and will be ignored.", new Location(this.xml));
        }
        sCodeImage.endian = this.toEndian(this.xml);
        sCodeImage.blockSize = this.xml.geti("blockSize");
        sCodeImage.refSize = this.xml.geti("refSize");
        sCodeImage.main = this.xml.get("main", "sys::Sys.main");
        sCodeImage.debug = this.xml.getb("debug", false);
        sCodeImage.test = this.xml.getb("test", false);
        sCodeImage.armDouble = this.xml.getb("armDouble", false);
        this.compiler.image = sCodeImage;
    }

    private final int toEndian(XElem xElem) {
        String string = xElem.get("endian");
        if (string.equals("big")) {
            return 66;
        }
        if (string.equals("little")) {
            return 76;
        }
        throw new XException("Endian attribute must be 'big' or 'little'", xElem);
    }

    protected void initKits() {
        XElem[] xElemArray = this.xml.elems("depend");
        if (xElemArray.length == 0) {
            throw this.err("Must specify at least one <depend> element", new Location(this.xml));
        }
        boolean bl = false;
        if (this.compiler.image != null) {
            bl = this.compiler.image.test;
        }
        boolean bl2 = bl;
        IrKit[] irKitArray = new IrKit[xElemArray.length];
        int n = 0;
        while (n < irKitArray.length) {
            XElem xElem = xElemArray[n];
            Location location = new Location(xElem);
            Depend depend = xElem.getDepend("on");
            KitFile kitFile = KitDb.matchBest((Depend)depend);
            if (kitFile == null) {
                this.err("Missing kit dependency '" + depend + '\'', location);
            } else {
                String string;
                this.log.debug("    " + kitFile.toString());
                IrKit irKit = irKitArray[n] = new IrKit(location, kitFile);
                if (irKit.name.equals("sys")) {
                    this.sysKit = kitFile;
                }
                irKit.test = (string = xElem.get("test", null)) != null ? string.equals("true") : bl2;
            }
            ++n;
        }
        this.compiler.kits = irKitArray;
        this.quitIfErrors();
    }

    private final void initResume() {
        boolean bl;
        String string = this.xml.get("unhibernate", null);
        String string2 = this.xml.get("resume", null);
        boolean bl2 = false;
        if (string != null) {
            bl2 = true;
        }
        boolean bl3 = bl2;
        boolean bl4 = false;
        if (string2 != null) {
            bl4 = bl = true;
        }
        if (bl3 && bl) {
            throw new XException("Cannot specify both 'unhibernate' and 'resume' attributes", this.xml);
        }
        if (bl) {
            this.compiler.image.resume = string2;
        } else if (bl3) {
            this.warn("'unhibernate' attribute is deprecated. Use 'resume' instead.", new Location(this.xml));
            this.compiler.image.resume = string;
        } else {
            this.compiler.image.resume = this.sysKit.version.compareTo((Object)new Version("1.0.47")) < 0 ? "sys::Sys.unhibernate" : "sys::Sys.resume";
        }
    }

    public InitImageCompile(Compiler compiler) {
        super(compiler);
        this.xmlFile = compiler.input;
        this.xmlDir = this.xmlFile.getParentFile();
        this.xml = compiler.xml;
    }
}

