/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import sedona.Env;
import sedona.util.TextUtil;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ir.IrKit;
import sedonac.ir.IrMethod;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.namespace.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GenNativeTable
extends CompilerStep {
    NativeKit[] nativeKits;
    HashMap patches;

    public void run() {
        File file = new File(this.compiler.outDir, "nativetable.c");
        this.log.info("  GenNativeTable [" + file + ']');
        try {
            Printer printer = new Printer(new PrintWriter(new FileWriter(file)));
            this.generate(printer);
            printer.close();
        }
        catch (Exception exception) {
            throw this.err("Cannot write stub file", new Location(file), (Throwable)exception);
        }
    }

    private final void generate(Printer printer) {
        NativeKit nativeKit;
        this.findNativeMethods();
        this.orderKits();
        this.orderMethods();
        printer.w("//").nl();
        printer.w("// Generated by sedonac ").w(Env.version).nl();
        printer.w("// ").w(Env.timestamp()).nl();
        printer.w("//").nl();
        printer.nl();
        printer.w("#include \"sedona.h\"").nl();
        printer.nl();
        int n = 0;
        while (n < this.nativeKits.length) {
            nativeKit = this.nativeKits[n];
            if (nativeKit != null) {
                printer.w("////////////////////////////////////////////////////////////////").nl();
                printer.w("// ").w(nativeKit.kitName).w(" (kitId=").w(nativeKit.kitId).w(")").nl();
                printer.w("////////////////////////////////////////////////////////////////").nl();
                printer.nl();
                int n2 = 0;
                while (n2 < nativeKit.methods.length) {
                    this.forward(printer, nativeKit.methods[n2]);
                    ++n2;
                }
                printer.w("// native table for kit ").w(n).nl();
                printer.w("NativeMethod ").w("kitNatives").w(n).w("[] = ").nl();
                printer.w("{").nl();
                n2 = 0;
                while (n2 < nativeKit.methods.length) {
                    IrMethod irMethod = nativeKit.methods[n2];
                    printer.w("  ").w(TextUtil.pad((String)(this.toFuncName(irMethod) + ','), (int)30)).w("  // ").w(nativeKit.kitId).w("::").w(n2).nl();
                    ++n2;
                }
                printer.w("};").nl();
                printer.nl();
            }
            ++n;
        }
        printer.w("////////////////////////////////////////////////////////////////").nl();
        printer.w("// Native Table").nl();
        printer.w("////////////////////////////////////////////////////////////////").nl();
        printer.nl();
        printer.w("NativeMethod* ").w("nativeTable[] = ").nl();
        printer.w("{").nl();
        n = 0;
        while (n < this.nativeKits.length) {
            nativeKit = this.nativeKits[n];
            String string = nativeKit == null ? "NULL," : "kitNatives" + n + ',';
            printer.w("  ").w(TextUtil.pad((String)string, (int)15)).w("  // " + n).nl();
            ++n;
        }
        printer.w("};").nl();
        printer.nl();
        printer.w("////////////////////////////////////////////////////////////////").nl();
        printer.w("// Native Id Check").nl();
        printer.w("////////////////////////////////////////////////////////////////").nl();
        printer.nl();
        printer.w("#ifdef SCODE_DEBUG").nl();
        printer.w("int isNativeIdValid(int kitId, int methodId)").nl();
        printer.w("{").nl();
        printer.w("  switch(kitId)").nl();
        printer.w("  {").nl();
        n = 0;
        while (n < this.nativeKits.length) {
            IrMethod[] irMethodArray;
            nativeKit = this.nativeKits[n];
            if (nativeKit != null && (irMethodArray = nativeKit.methods).length != 0) {
                if (irMethodArray[irMethodArray.length - 1] == null) {
                    throw new IllegalStateException();
                }
                printer.w("    case ").w(nativeKit.kitId).w(":").nl();
                printer.w("      if (methodId >= ").w(irMethodArray.length).w(") return 0;").nl();
                printer.w("      else return kitNatives").w(nativeKit.kitId).w("[methodId] != NULL;").nl();
            }
            ++n;
        }
        printer.w("    default:").nl();
        printer.w("       return 0;").nl();
        printer.w("  }").nl();
        printer.w("}").nl();
        printer.w("#endif").nl();
        printer.nl().nl();
    }

    private final void forward(Printer printer, IrMethod irMethod) {
        if (irMethod == null) {
            return;
        }
        printer.w("// ").w(irMethod.ret).w(" ").w(irMethod.parent.name).w(".").w(irMethod.name).w("(");
        int n = 0;
        while (n < irMethod.params.length) {
            Type type = irMethod.params[n];
            if (n > 0) {
                printer.w(", ");
            }
            printer.w(type);
            ++n;
        }
        printer.w(")").nl();
        printer.w("Cell ").w(this.toFuncName(irMethod)).w("(SedonaVM* vm, Cell* params);").nl().nl();
    }

    private final String toFuncName(IrMethod irMethod) {
        if (irMethod == null) {
            return "NULL";
        }
        String string = irMethod.parent.kit.name + '_' + irMethod.parent.name + '_' + irMethod.name;
        if (this.patches.get(irMethod.qname()) != null) {
            string = string + "_patch";
        }
        return string;
    }

    private final void findNativeMethods() {
        HashMap<Integer, NativeKit> hashMap = new HashMap<Integer, NativeKit>();
        IrKit[] irKitArray = this.compiler.kits;
        int n = 0;
        while (n < irKitArray.length) {
            IrType[] irTypeArray = irKitArray[n].types;
            int n2 = 0;
            while (n2 < irTypeArray.length) {
                IrSlot[] irSlotArray = irTypeArray[n2].declared;
                int n3 = 0;
                while (n3 < irSlotArray.length) {
                    if (irSlotArray[n3].isMethod() && irSlotArray[n3].isNative()) {
                        IrMethod irMethod = (IrMethod)irSlotArray[n3];
                        Integer n4 = new Integer(irMethod.nativeId.kitId);
                        NativeKit nativeKit = (NativeKit)hashMap.get(n4);
                        if (nativeKit == null) {
                            nativeKit = new NativeKit(irMethod);
                            hashMap.put(n4, nativeKit);
                        }
                        nativeKit.acc.add(irMethod);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.nativeKits = hashMap.values().toArray(new NativeKit[hashMap.size()]);
    }

    private final void orderKits() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.nativeKits.length) {
            n = Math.max(n, this.nativeKits[n2].kitId);
            ++n2;
        }
        NativeKit[] nativeKitArray = new NativeKit[n + 1];
        int n3 = 0;
        while (n3 < this.nativeKits.length) {
            NativeKit nativeKit;
            nativeKitArray[nativeKit.kitId] = nativeKit = this.nativeKits[n3];
            ++n3;
        }
        this.nativeKits = nativeKitArray;
    }

    private final void orderMethods() {
        int n = 0;
        while (n < this.nativeKits.length) {
            this.orderMethods(this.nativeKits[n]);
            ++n;
        }
    }

    private final void orderMethods(NativeKit nativeKit) {
        if (nativeKit == null) {
            return;
        }
        nativeKit.methods = nativeKit.acc.toArray(new IrMethod[nativeKit.acc.size()]);
        nativeKit.acc = null;
        int n = nativeKit.methods[0].nativeId.kitId;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nativeKit.methods.length) {
            IrMethod irMethod = nativeKit.methods[n3];
            if (irMethod.nativeId.kitId != n) {
                this.err("Native kitIds must all be the same", irMethod.nativeId.loc);
            }
            n2 = Math.max(n2, irMethod.nativeId.methodId);
            ++n3;
        }
        IrMethod[] irMethodArray = new IrMethod[n2 + 1];
        int n4 = 0;
        while (n4 < nativeKit.methods.length) {
            IrMethod irMethod;
            irMethodArray[irMethod.nativeId.methodId] = irMethod = nativeKit.methods[n4];
            ++n4;
        }
        nativeKit.methods = irMethodArray;
    }

    private final /* synthetic */ void this() {
        this.patches = new HashMap();
    }

    public GenNativeTable(Compiler compiler) {
        super(compiler);
        this.this();
        int n = 0;
        while (n < compiler.platform.nativePatches.length) {
            this.patches.put(compiler.platform.nativePatches[n], "");
            ++n;
        }
    }

    public static class Printer
    extends PrintWriter {
        public int indent;

        public Printer w(Object object) {
            this.print(object);
            return this;
        }

        public Printer w(int n) {
            this.print(n);
            return this;
        }

        public Printer indent() {
            this.print(TextUtil.getSpaces((int)(this.indent * 2)));
            return this;
        }

        public Printer nl() {
            this.println();
            return this;
        }

        public Printer(PrintWriter printWriter) {
            super(printWriter);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class NativeKit {
        String kitName;
        int kitId;
        ArrayList acc;
        IrMethod[] methods;

        private final /* synthetic */ void this() {
            this.acc = new ArrayList();
        }

        NativeKit(IrMethod irMethod) {
            this.this();
            this.kitName = irMethod.parent.kit.name;
            this.kitId = irMethod.nativeId.kitId;
        }
    }
}

