/*
 * Decompiled with CFR 0.152.
 */
package sedonac.parser;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import sedona.util.TextUtil;
import sedonac.Location;
import sedonac.namespace.Namespace;
import sedonac.namespace.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Token {
    public static final int EOF = 0;
    public static final int ID = 1;
    public static final int DOC_COMMENT = 2;
    public static final int INT_LITERAL = 3;
    public static final int LONG_LITERAL = 4;
    public static final int FLOAT_LITERAL = 5;
    public static final int DOUBLE_LITERAL = 6;
    public static final int STR_LITERAL = 7;
    public static final int TIME_LITERAL = 8;
    public static final int BUF_LITERAL = 9;
    public static final int DOT = 10;
    public static final int COMMA = 11;
    public static final int SEMICOLON = 12;
    public static final int COLON = 13;
    public static final int PLUS = 14;
    public static final int MINUS = 15;
    public static final int STAR = 16;
    public static final int SLASH = 17;
    public static final int PERCENT = 18;
    public static final int AMP = 19;
    public static final int PIPE = 20;
    public static final int DOUBLE_AMP = 21;
    public static final int DOUBLE_PIPE = 22;
    public static final int DOUBLE_COLON = 23;
    public static final int CARET = 24;
    public static final int QUESTION = 25;
    public static final int BANG = 26;
    public static final int TILDE = 27;
    public static final int AT = 28;
    public static final int LSHIFT = 29;
    public static final int RSHIFT = 30;
    public static final int EQ = 31;
    public static final int NOT_EQ = 32;
    public static final int GT = 33;
    public static final int GT_EQ = 34;
    public static final int LT = 35;
    public static final int LT_EQ = 36;
    public static final int INCREMENT = 37;
    public static final int DECREMENT = 38;
    public static final int ARROW = 39;
    public static final int LBRACE = 40;
    public static final int RBRACE = 41;
    public static final int LBRACKET = 42;
    public static final int RBRACKET = 43;
    public static final int LPAREN = 44;
    public static final int RPAREN = 45;
    public static final int ASSIGN = 46;
    public static final int ASSIGN_PLUS = 47;
    public static final int ASSIGN_MINUS = 48;
    public static final int ASSIGN_STAR = 49;
    public static final int ASSIGN_SLASH = 50;
    public static final int ASSIGN_PERCENT = 51;
    public static final int ASSIGN_AMP = 52;
    public static final int ASSIGN_PIPE = 53;
    public static final int ASSIGN_CARET = 54;
    public static final int ASSIGN_LSHIFT = 55;
    public static final int ASSIGN_RSHIFT = 56;
    public static final int SAFE_NAV = 57;
    public static final int ELVIS = 58;
    public static final int ABSTRACT = 100;
    public static final int ACTION = 101;
    public static final int ASSERT = 102;
    public static final int BOOL = 103;
    public static final int BREAK = 104;
    public static final int BYTE = 105;
    public static final int CASE = 106;
    public static final int CLASS = 107;
    public static final int CONST = 108;
    public static final int CONTINUE = 109;
    public static final int DEFAULT = 110;
    public static final int DEFINE = 111;
    public static final int DELETE = 112;
    public static final int DOUBLE = 113;
    public static final int DO = 114;
    public static final int ELSE = 115;
    public static final int ENUM = 116;
    public static final int EXTENDS = 117;
    public static final int FALSE = 118;
    public static final int FINAL = 119;
    public static final int FLOAT = 120;
    public static final int FOR = 121;
    public static final int FOREACH = 122;
    public static final int FUNCTION = 123;
    public static final int GOTO = 124;
    public static final int IF = 125;
    public static final int INLINE = 126;
    public static final int INT = 127;
    public static final int INTERNAL = 128;
    public static final int LONG = 129;
    public static final int NATIVE = 130;
    public static final int NEW = 131;
    public static final int NULL = 132;
    public static final int OVERRIDE = 133;
    public static final int PRIVATE = 134;
    public static final int PROPERTY = 135;
    public static final int PROTECTED = 136;
    public static final int PUBLIC = 137;
    public static final int RETURN = 138;
    public static final int SHORT = 139;
    public static final int STATIC = 140;
    public static final int SUPER = 141;
    public static final int SWITCH = 142;
    public static final int THIS = 143;
    public static final int TRUE = 144;
    public static final int VIRTUAL = 145;
    public static final int VOID = 146;
    public static final int WHILE = 147;
    private static HashMap idToKeyword = new HashMap();
    private static HashMap keywordToId = new HashMap();
    public Location loc;
    public int type;
    public Object value;
    static /* synthetic */ Class class$sedonac$parser$Token;

    public static String toKeyword(int n) {
        return (String)idToKeyword.get(new Integer(n));
    }

    public static int fromKeyword(String string) {
        Integer n = (Integer)keywordToId.get(string);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public boolean isId() {
        boolean bl = false;
        if (this.type == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isKeyword() {
        boolean bl = false;
        if (Token.toKeyword(this.type) != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isLiteral() {
        switch (this.type) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 118: 
            case 132: 
            case 144: {
                return true;
            }
        }
        return false;
    }

    public int toUnaryExprId(boolean bl) {
        switch (this.type) {
            case 15: {
                return 20;
            }
            case 26: {
                return 21;
            }
            case 27: {
                return 22;
            }
            case 37: {
                return bl ? 25 : 23;
            }
            case 38: {
                return bl ? 26 : 24;
            }
        }
        throw new IllegalStateException(this.toString());
    }

    public int toBinaryExprId() {
        switch (this.type) {
            case 20: {
                return 35;
            }
            case 24: {
                return 36;
            }
            case 19: {
                return 37;
            }
            case 31: {
                return 29;
            }
            case 32: {
                return 30;
            }
            case 33: {
                return 31;
            }
            case 34: {
                return 32;
            }
            case 35: {
                return 33;
            }
            case 36: {
                return 34;
            }
            case 29: {
                return 38;
            }
            case 30: {
                return 39;
            }
            case 16: {
                return 40;
            }
            case 17: {
                return 41;
            }
            case 18: {
                return 42;
            }
            case 14: {
                return 43;
            }
            case 15: {
                return 44;
            }
            case 46: {
                return 45;
            }
            case 47: {
                return 46;
            }
            case 48: {
                return 47;
            }
            case 49: {
                return 48;
            }
            case 50: {
                return 49;
            }
            case 51: {
                return 50;
            }
            case 52: {
                return 53;
            }
            case 53: {
                return 51;
            }
            case 54: {
                return 52;
            }
            case 55: {
                return 54;
            }
            case 56: {
                return 55;
            }
            case 58: {
                return 56;
            }
        }
        throw new IllegalStateException(this.toString());
    }

    public boolean isShift() {
        boolean bl = false;
        if (this.type == 29 || this.type == 30) {
            bl = true;
        }
        return bl;
    }

    public boolean isAssign() {
        switch (this.type) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                return true;
            }
        }
        return false;
    }

    public int assignToBinary() {
        switch (this.type) {
            case 47: {
                return 14;
            }
            case 48: {
                return 15;
            }
            case 49: {
                return 16;
            }
            case 50: {
                return 17;
            }
            case 51: {
                return 18;
            }
            case 52: {
                return 19;
            }
            case 53: {
                return 20;
            }
            case 54: {
                return 24;
            }
            case 55: {
                return 29;
            }
            case 56: {
                return 30;
            }
        }
        throw new IllegalStateException(this.toString());
    }

    public Type typeKeyword(Namespace namespace) {
        switch (this.type) {
            case 103: {
                return namespace.boolType;
            }
            case 105: {
                return namespace.byteType;
            }
            case 139: {
                return namespace.shortType;
            }
            case 127: {
                return namespace.intType;
            }
            case 129: {
                return namespace.longType;
            }
            case 120: {
                return namespace.floatType;
            }
            case 113: {
                return namespace.doubleType;
            }
            case 146: {
                return namespace.voidType;
            }
        }
        return null;
    }

    public int valueToInt() {
        return (Integer)this.value;
    }

    public long valueToLong() {
        return (Long)this.value;
    }

    public float valueToFloat() {
        return ((Float)this.value).floatValue();
    }

    public double valueToDouble() {
        return (Double)this.value;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return this.value.toString();
            }
            case 2: {
                return "DocComment";
            }
            case 3: {
                return this.value.toString();
            }
            case 4: {
                return this.value.toString() + 'L';
            }
            case 5: {
                return this.value.toString() + 'F';
            }
            case 6: {
                return this.value.toString() + 'D';
            }
            case 8: {
                return this.value.toString() + "ns";
            }
            case 7: {
                return "\"" + TextUtil.toLiteral((String)((String)this.value)) + '\"';
            }
            case 9: {
                return this.value.toString();
            }
        }
        return Token.toString(this.type);
    }

    public static String toString(int n) {
        switch (n) {
            case 0: {
                return "EOF";
            }
            case 1: {
                return "Identifier";
            }
            case 2: {
                return "DocComment";
            }
            case 3: {
                return "IntLiteral";
            }
            case 4: {
                return "LongLiteral";
            }
            case 5: {
                return "FloatLiteral";
            }
            case 6: {
                return "DoubleLiteral";
            }
            case 7: {
                return "StrLiteral";
            }
            case 10: {
                return ".";
            }
            case 11: {
                return ",";
            }
            case 12: {
                return ";";
            }
            case 13: {
                return ":";
            }
            case 14: {
                return "+";
            }
            case 15: {
                return "-";
            }
            case 16: {
                return "*";
            }
            case 17: {
                return "/";
            }
            case 18: {
                return "%";
            }
            case 19: {
                return "&";
            }
            case 20: {
                return "|";
            }
            case 21: {
                return "&&";
            }
            case 22: {
                return "||";
            }
            case 23: {
                return "::";
            }
            case 24: {
                return "^";
            }
            case 25: {
                return "?";
            }
            case 26: {
                return "!";
            }
            case 27: {
                return "~";
            }
            case 28: {
                return "@";
            }
            case 29: {
                return "<<";
            }
            case 30: {
                return ">>";
            }
            case 31: {
                return "==";
            }
            case 32: {
                return "!=";
            }
            case 33: {
                return ">";
            }
            case 34: {
                return ">=";
            }
            case 35: {
                return "<";
            }
            case 36: {
                return "<=";
            }
            case 37: {
                return "++";
            }
            case 38: {
                return "--";
            }
            case 39: {
                return "->";
            }
            case 40: {
                return "{";
            }
            case 41: {
                return "}";
            }
            case 42: {
                return "[";
            }
            case 43: {
                return "]";
            }
            case 44: {
                return "(";
            }
            case 45: {
                return ")";
            }
            case 46: {
                return "=";
            }
            case 47: {
                return "+=";
            }
            case 48: {
                return "-=";
            }
            case 49: {
                return "*=";
            }
            case 50: {
                return "/=";
            }
            case 51: {
                return "%=";
            }
            case 52: {
                return "&=";
            }
            case 53: {
                return "|=";
            }
            case 54: {
                return "^=";
            }
            case 55: {
                return "<<=";
            }
            case 56: {
                return ">>=";
            }
            case 57: {
                return "?.";
            }
            case 58: {
                return "?:";
            }
        }
        return Token.toKeyword(n);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.type = -1;
    }

    public Token(Location location, int n) {
        this.this();
        this.loc = location;
        this.type = n;
    }

    public Token(Location location, int n, Object object) {
        this.this();
        this.loc = location;
        this.type = n;
        this.value = object;
    }

    static {
        try {
            Class clazz = class$sedonac$parser$Token;
            if (clazz == null) {
                clazz = class$sedonac$parser$Token = Token.class("[Lsedonac.parser.Token;", false);
            }
            Field[] fieldArray = clazz.getFields();
            int n = 0;
            while (n < fieldArray.length) {
                int n2;
                Field field = fieldArray[n];
                int n3 = field.getModifiers();
                if (Modifier.isStatic(n3) && field.getType() == Integer.TYPE && (n2 = field.getInt(null)) >= 100) {
                    String string = TextUtil.toLowerCase((String)field.getName());
                    Integer n4 = new Integer(n2);
                    if (idToKeyword.get(n4) != null) {
                        System.out.println("ERROR: dup id: " + n4 + " / " + string);
                    }
                    keywordToId.put(string, n4);
                    idToKeyword.put(n4, string);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

