/*
 * Decompiled with CFR 0.152.
 */
package sedonac.parser;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.CompilerSupport;
import sedonac.Location;
import sedonac.ast.Block;
import sedonac.ast.Expr;
import sedonac.ast.FacetDef;
import sedonac.ast.FieldDef;
import sedonac.ast.MethodDef;
import sedonac.ast.ParamDef;
import sedonac.ast.SlotDef;
import sedonac.ast.Stmt;
import sedonac.ast.TypeDef;
import sedonac.ast.UnresolvedType;
import sedonac.namespace.ArrayType;
import sedonac.namespace.Type;
import sedonac.parser.Token;
import sedonac.parser.Tokenizer;

public class Parser
extends CompilerSupport {
    protected String filename;
    protected Tokenizer tokenizer;
    protected Location loc;
    protected Token[] tokens;
    protected int pos;
    protected int numTokens;
    protected Token cur;
    protected Token peek;
    protected int curt;
    protected int peekt;
    protected boolean curIsNewline;
    protected boolean inVoid;

    public TypeDef[] parse() {
        this.readTokens();
        ArrayList<TypeDef> arrayList = new ArrayList<TypeDef>();
        while (this.curt != 0) {
            arrayList.add(this.typeDef());
        }
        return arrayList.toArray(new TypeDef[arrayList.size()]);
    }

    public TypeDef typeDef() {
        Location location = this.loc;
        String string = null;
        while (this.curt == 2) {
            string = (String)this.consume((int)2).value;
        }
        FacetDef[] facetDefArray = this.facets();
        int n = this.typeFlags();
        this.consume(107);
        String string2 = this.consumeId();
        TypeDef typeDef = new TypeDef(location, this.compiler.ast, n, string2, facetDefArray);
        typeDef.doc = string;
        if (this.curt == 117) {
            this.consume();
            typeDef.base = this.tryTypeBase();
            if (typeDef.base == null) {
                this.err("'extends' missing base class identifier", this.loc);
            }
        } else if (!typeDef.qname.equals("sys::Obj")) {
            typeDef.base = this.ns.objType;
        }
        this.consume(40);
        while (this.curt != 41) {
            SlotDef slotDef = this.slotDef(typeDef);
            if (typeDef.slot(slotDef.name()) != null) {
                this.err("Duplicate slot name '" + slotDef.name + '\'', slotDef.loc);
                continue;
            }
            typeDef.addSlot(slotDef);
        }
        this.consume(41);
        return typeDef;
    }

    protected int typeFlags() {
        int n = 0;
        boolean bl = false;
        while (true) {
            if (this.curt == 100) {
                this.consume();
                n |= 1;
                continue;
            }
            if (this.curt == 108) {
                this.consume();
                n |= 2;
                continue;
            }
            if (this.curt == 119) {
                this.consume();
                n |= 4;
                continue;
            }
            if (this.curt == 128) {
                this.consume();
                n |= 8;
                bl = true;
                continue;
            }
            if (this.curt != 137) break;
            this.consume();
            n |= 0x10;
            bl = true;
        }
        if (!bl) {
            n |= 0x10;
        }
        return n;
    }

    private final SlotDef slotDef(TypeDef typeDef) {
        String string = null;
        while (this.curt == 2) {
            string = (String)this.consume((int)2).value;
        }
        SlotDef slotDef = this.doSlotDef(typeDef);
        slotDef.doc = string;
        return slotDef;
    }

    private final SlotDef doSlotDef(TypeDef typeDef) {
        Location location = this.loc;
        FacetDef[] facetDefArray = this.facets();
        int n = this.slotFlags();
        int n2 = this.pos;
        if (this.curt == 1 && this.cur.value.equals(typeDef.name) && this.peekt == 44) {
            boolean bl;
            this.consumeId();
            int n3 = this.pos;
            this.consume(44);
            boolean bl2 = false;
            if (this.curt == 45 || this.tryType() != null && this.cur.isId()) {
                bl2 = true;
            }
            if (bl = bl2) {
                this.reset(n3);
                return this.methodDef(location, typeDef, n, "_iInit", facetDefArray, this.ns.voidType);
            }
        }
        this.reset(n2);
        Type type = this.tryType();
        if (type == null) {
            throw this.err("Expected field or method definition, invalid type signature");
        }
        Expr[] exprArray = null;
        if (this.curt == 44) {
            if (type.isArray()) {
                this.err("Cannot call constructor on an array field", this.loc);
            }
            exprArray = this.callArgs();
        }
        String string = this.consumeId();
        if (this.curt == 44) {
            return this.methodDef(location, typeDef, n, string, facetDefArray, type);
        }
        return this.fieldDef(location, typeDef, n, string, facetDefArray, type, exprArray);
    }

    protected int slotFlags() {
        Location location = this.loc;
        int n = 0;
        boolean bl = false;
        while (true) {
            if (this.curt == 100) {
                this.consume();
                n |= 1;
                continue;
            }
            if (this.curt == 101) {
                this.consume();
                n |= 2;
                continue;
            }
            if (this.curt == 108) {
                this.consume();
                n |= 4;
                continue;
            }
            if (this.curt == 111) {
                this.consume();
                n |= 8;
                continue;
            }
            if (this.curt == 126) {
                this.consume();
                n |= 0x10;
                continue;
            }
            if (this.curt == 128) {
                this.consume();
                n |= 0x20;
                bl = true;
                continue;
            }
            if (this.curt == 130) {
                this.consume();
                n |= 0x40;
                continue;
            }
            if (this.curt == 133) {
                this.consume();
                n |= 0x80;
                continue;
            }
            if (this.curt == 134) {
                this.consume();
                n |= 0x200;
                bl = true;
                continue;
            }
            if (this.curt == 135) {
                this.consume();
                n |= 0x400;
                continue;
            }
            if (this.curt == 136) {
                this.consume();
                n |= 0x800;
                bl = true;
                continue;
            }
            if (this.curt == 137) {
                this.consume();
                n |= 0x100;
                bl = true;
                continue;
            }
            if (this.curt == 140) {
                this.consume();
                n |= 0x1000;
                continue;
            }
            if (this.curt != 145) break;
            this.consume();
            n |= 0x2000;
        }
        if ((n & 1) != 0) {
            if ((n & 0x2000) != 0) {
                this.err("The 'virtual' modifier is implied by 'abstract'", location);
            }
            n |= 0x2000;
        }
        if ((n & 8) != 0) {
            if ((n & 0x1000) != 0) {
                this.err("The 'static' modifier is implied by 'define'", location);
            }
            n |= 0x1000;
        }
        if ((n & 2) != 0) {
            if ((n & 0x2000) != 0 && (n & 1) == 0) {
                this.err("The 'virtual' modifier is implied by 'action'", location);
            }
            if (((n |= 0x2000) & 0x100) != 0) {
                this.err("The 'public' modifier is implied by 'action'", location);
            }
        }
        if ((n & 0x400) != 0 && (n & 0x100) != 0) {
            this.err("The 'public' modifier is implied by 'property'", location);
        }
        if ((n & 0x400) != 0 && (n & 0x10) != 0) {
            this.err("The 'inline' modifier is implied by 'property'", location);
        }
        if (!bl) {
            n |= 0x100;
        }
        return n;
    }

    private final FieldDef fieldDef(Location location, TypeDef typeDef, int n, String string, FacetDef[] facetDefArray, Type type, Expr[] exprArray) {
        if ((n & 0x400) != 0 && !type.isPrimitive()) {
            n |= 0x10;
        }
        Expr expr = null;
        boolean bl = false;
        if (this.curt == 46) {
            this.consume();
            expr = this.curt == 40 ? (this.peekt == 10 ? this.arrayInitializer() : this.arrayLiteral(n, type)) : this.expr();
        }
        this.endOfStmt();
        if ((n & 8) != 0) {
            if ((n & 4) != 0) {
                this.err("Cannot use 'const' modifier on define", location);
            }
            n |= 4;
        }
        return new FieldDef(location, typeDef, n, string, facetDefArray, type, expr, exprArray);
    }

    protected Expr.InitArray arrayInitializer() {
        Location location = this.loc;
        String string = "Expected object array initializer '{...}'";
        this.consume(40, string);
        this.consume(10, string);
        this.consume(10, string);
        this.consume(10, string);
        this.consume(41, string);
        return new Expr.InitArray(location);
    }

    protected Expr.Literal arrayLiteral(int n, Type type) {
        Location location = this.loc;
        if ((n & 8) == 0) {
            throw this.err("Array literals only supported on define fields", location);
        }
        if (!type.isArray()) {
            throw this.err("Cannot use array literal with non-array field", location);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.consume(40);
        if (this.curt == 11) {
            this.consume();
        } else {
            while (true) {
                arrayList.add(this.literal().value);
                if (this.curt != 11) break;
                this.consume(11);
            }
        }
        this.consume(41);
        return new Expr.Literal(location, 13, type, (Object)arrayList.toArray());
    }

    private final MethodDef methodDef(Location location, TypeDef typeDef, int n, String string, FacetDef[] facetDefArray, Type type) {
        Block block;
        this.inVoid = type.isVoid();
        boolean bl = false;
        if ((n & 0x1000) != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        ParamDef[] paramDefArray = this.params(bl2);
        if ((n & 0x41) != 0) {
            if (this.curt == 40) {
                throw this.err("Abstract and native methods cannot have method bodies");
            }
            block = null;
            this.endOfStmt();
        } else {
            if (this.curt != 40) {
                throw this.err("Expected method body");
            }
            block = this.block();
        }
        return new MethodDef(location, typeDef, n, string, facetDefArray, type, paramDefArray, block);
    }

    private final ParamDef[] params(boolean bl) {
        ArrayList<ParamDef> arrayList = new ArrayList<ParamDef>();
        this.consume(44);
        int n = 1 - bl;
        if (this.curt != 45) {
            while (true) {
                ParamDef paramDef = this.param(n);
                n += paramDef.type.isWide() + 1;
                arrayList.add(paramDef);
                if (this.curt == 45) break;
                this.consume(11);
            }
        }
        this.consume(45);
        return arrayList.toArray(new ParamDef[arrayList.size()]);
    }

    private final ParamDef param(int n) {
        return new ParamDef(this.loc, n, this.type(), this.consumeId());
    }

    public Block block() {
        this.verify(40);
        return this.stmtOrBlock();
    }

    public Block stmtOrBlock() {
        Block block = new Block(this.cur.loc);
        if (this.curt != 40) {
            block.stmts.add(this.stmt());
        } else {
            this.consume(40);
            while (this.curt != 41) {
                block.stmts.add(this.stmt());
            }
            this.consume(41);
        }
        return block;
    }

    private final Stmt stmt() {
        String string = null;
        if (this.curt == 1 && this.peekt == 13) {
            string = this.consumeId();
            this.consume(13);
        }
        Stmt stmt = this.doStmt();
        stmt.label = string;
        return stmt;
    }

    private final Stmt doStmt() {
        switch (this.curt) {
            case 138: {
                return this.returnStmt();
            }
            case 125: {
                return this.ifStmt();
            }
            case 121: {
                return this.forStmt();
            }
            case 122: {
                return this.foreachStmt();
            }
            case 147: {
                return this.whileStmt();
            }
            case 114: {
                return this.doWhileStmt();
            }
            case 104: {
                return this.breakStmt();
            }
            case 109: {
                return this.continueStmt();
            }
            case 102: {
                return this.assertStmt();
            }
            case 124: {
                return this.gotoStmt();
            }
            case 142: {
                return this.switchStmt();
            }
        }
        return this.exprOrLocalDef(true);
    }

    private final Stmt exprOrLocalDef(boolean bl) {
        Location location = this.loc;
        int n = this.pos;
        Type type = this.tryType();
        if (type != null && this.cur.isId()) {
            return this.localDefStmt(type, bl);
        }
        this.reset(n);
        Stmt.ExprStmt exprStmt = new Stmt.ExprStmt(location, this.expr());
        if (bl) {
            this.endOfStmt();
        }
        return exprStmt;
    }

    private final Stmt localDefStmt(Type type, boolean bl) {
        Location location = this.loc;
        String string = this.consumeId();
        Expr expr = null;
        if (this.curt == 46) {
            this.consume();
            expr = this.expr();
        }
        if (bl) {
            this.endOfStmt();
        }
        return new Stmt.LocalDef(location, type, string, expr);
    }

    private final Stmt returnStmt() {
        Stmt.Return return_ = new Stmt.Return(this.loc);
        this.consume(138);
        if (!this.inVoid) {
            return_.expr = this.expr();
        }
        this.endOfStmt();
        return return_;
    }

    private final Stmt ifStmt() {
        Stmt.If if_ = new Stmt.If(this.loc);
        this.consume(125);
        this.consume(44);
        if_.cond = this.expr();
        this.consume(45);
        if_.trueBlock = this.stmtOrBlock();
        if (this.curt == 115) {
            this.consume(115);
            if_.falseBlock = this.stmtOrBlock();
        }
        return if_;
    }

    private final Stmt.While whileStmt() {
        Stmt.While while_ = new Stmt.While(this.loc);
        this.consume(147);
        this.consume(44);
        while_.cond = this.expr();
        this.consume(45);
        if (this.curt == 12) {
            while_.block = new Block(this.loc);
            this.consume();
        } else {
            while_.block = this.stmtOrBlock();
        }
        return while_;
    }

    private final Stmt.DoWhile doWhileStmt() {
        Stmt.DoWhile doWhile = new Stmt.DoWhile(this.loc);
        this.consume(114);
        doWhile.block = this.stmtOrBlock();
        this.consume(147);
        this.consume(44);
        doWhile.cond = this.expr();
        this.consume(45);
        this.endOfStmt();
        return doWhile;
    }

    private final Stmt.For forStmt() {
        Stmt.For for_ = new Stmt.For(this.loc);
        this.consume(121);
        this.consume(44);
        Object var2_2 = null;
        if (this.curt != 12) {
            for_.init = this.exprOrLocalDef(false);
        }
        this.consume(12);
        if (this.curt != 12) {
            for_.cond = this.expr();
        }
        this.consume(12);
        if (this.curt != 45) {
            for_.update = this.expr();
        }
        this.consume(45);
        if (this.curt == 12) {
            for_.block = new Block(this.loc);
            this.consume();
        } else {
            for_.block = this.stmtOrBlock();
        }
        return for_;
    }

    private final Stmt.Foreach foreachStmt() {
        Stmt.Foreach foreach = new Stmt.Foreach(this.loc);
        this.consume(122);
        this.consume(44);
        Location location = this.loc;
        Type type = this.type();
        String string = this.consumeId();
        foreach.local = new Stmt.LocalDef(location, type, string);
        this.consume(13);
        foreach.array = this.expr();
        if (this.curt == 11) {
            this.consume(11);
            foreach.length = this.expr();
        }
        this.consume(45);
        foreach.block = this.stmtOrBlock();
        return foreach;
    }

    private final Stmt.Break breakStmt() {
        Stmt.Break break_ = new Stmt.Break(this.loc);
        this.consume(104);
        this.endOfStmt();
        return break_;
    }

    private final Stmt.Continue continueStmt() {
        Stmt.Continue continue_ = new Stmt.Continue(this.loc);
        this.consume(109);
        this.endOfStmt();
        return continue_;
    }

    private final Stmt assertStmt() {
        Stmt.Assert assert_ = new Stmt.Assert(this.loc);
        this.consume(102);
        this.consume(44);
        assert_.cond = this.expr();
        this.consume(45);
        this.endOfStmt();
        return assert_;
    }

    private final Stmt gotoStmt() {
        Stmt.Goto goto_ = new Stmt.Goto(this.loc);
        this.consume(124);
        goto_.destLabel = this.consumeId();
        this.endOfStmt();
        return goto_;
    }

    private final Stmt.Switch switchStmt() {
        Stmt.Switch switch_ = new Stmt.Switch(this.loc);
        this.consume(142);
        this.consume(44);
        switch_.cond = this.expr();
        this.consume(45);
        this.consume(40);
        ArrayList<Stmt.Case> arrayList = new ArrayList<Stmt.Case>();
        while (this.curt == 106) {
            Stmt.Case case_ = new Stmt.Case(this.loc);
            arrayList.add(case_);
            this.consume(106);
            case_.label = this.expr();
            this.consume(13);
            Block block = new Block(this.loc);
            while (this.curt != 106 && this.curt != 110 && this.curt != 41) {
                block.add(this.stmt());
            }
            if (block.isEmpty()) continue;
            case_.block = block;
        }
        switch_.cases = arrayList.toArray(new Stmt.Case[arrayList.size()]);
        if (this.curt == 110) {
            this.consume(110);
            this.consume(13);
            switch_.defaultBlock = new Block(this.loc);
            while (this.curt != 41) {
                switch_.defaultBlock.add(this.stmt());
            }
        }
        this.consume(41);
        return switch_;
    }

    void endOfStmt() {
        if (this.curt == 12) {
            this.consume();
            return;
        }
        if (this.curIsNewline) {
            return;
        }
        if (this.curt == 41) {
            return;
        }
        throw this.err("Expected end of statement, not " + this.cur);
    }

    public Expr expr() {
        return this.assignExpr();
    }

    private final Expr assignExpr() {
        Expr expr = this.ternary();
        if (this.cur.isAssign()) {
            return new Expr.Binary(expr.loc, this.consume(), expr, this.assignExpr());
        }
        return expr;
    }

    private final Expr ternary() {
        Expr expr = this.condOrExpr();
        if (this.curt == 25) {
            Expr.Ternary ternary = new Expr.Ternary(expr.loc);
            ternary.cond = expr;
            this.consume(25);
            ternary.trueExpr = this.condOrExpr();
            this.consume(13);
            ternary.falseExpr = this.condOrExpr();
            return ternary;
        }
        return expr;
    }

    private final Expr condOrExpr() {
        Expr expr = this.condAndExpr();
        if (this.curt == 22) {
            Expr.Cond cond = new Expr.Cond(expr.loc, 27, this.cur, expr);
            while (this.curt == 22) {
                this.consume();
                cond.operands.add(this.condAndExpr());
            }
            expr = cond;
        }
        return expr;
    }

    private final Expr condAndExpr() {
        Expr expr = this.bitOrExpr();
        if (this.curt == 21) {
            Expr.Cond cond = new Expr.Cond(expr.loc, 28, this.cur, expr);
            while (this.curt == 21) {
                this.consume();
                cond.operands.add(this.bitOrExpr());
            }
            expr = cond;
        }
        return expr;
    }

    private final Expr bitOrExpr() {
        Expr expr = this.bitXorExpr();
        while (this.curt == 20) {
            expr = new Expr.Binary(expr.loc, this.consume(), expr, this.bitXorExpr());
        }
        return expr;
    }

    private final Expr bitXorExpr() {
        Expr expr = this.bitAndExpr();
        while (this.curt == 24) {
            expr = new Expr.Binary(expr.loc, this.consume(), expr, this.bitAndExpr());
        }
        return expr;
    }

    private final Expr bitAndExpr() {
        Expr expr = this.equalityExpr();
        while (this.curt == 19) {
            expr = new Expr.Binary(expr.loc, this.consume(), expr, this.equalityExpr());
        }
        return expr;
    }

    private final Expr equalityExpr() {
        Expr expr = this.relationalExpr();
        while (this.curt == 31 || this.curt == 32) {
            expr = new Expr.Binary(expr.loc, this.consume(), expr, this.relationalExpr());
        }
        return expr;
    }

    private final Expr relationalExpr() {
        Expr expr = this.elvis();
        while (this.curt == 35 || this.curt == 36 || this.curt == 33 || this.curt == 34) {
            expr = new Expr.Binary(expr.loc, this.consume(), expr, this.elvis());
        }
        return expr;
    }

    private final Expr elvis() {
        Expr expr = this.shiftExpr();
        while (this.curt == 58) {
            expr = new Expr.Binary(expr.loc, this.consume(), expr, this.shiftExpr());
        }
        return expr;
    }

    private final Expr shiftExpr() {
        Expr expr = this.addExpr();
        while (this.curt == 29 || this.curt == 30) {
            expr = new Expr.Binary(expr.loc, this.consume(), expr, this.addExpr());
        }
        return expr;
    }

    private final Expr addExpr() {
        Expr expr = this.multExpr();
        while (this.curt == 14 || this.curt == 15) {
            expr = new Expr.Binary(expr.loc, this.consume(), expr, this.multExpr());
        }
        return expr;
    }

    private final Expr multExpr() {
        Expr expr = this.parenExpr();
        while (this.curt == 16 || this.curt == 17 || this.curt == 18) {
            expr = new Expr.Binary(expr.loc, this.consume(), expr, this.parenExpr());
        }
        return expr;
    }

    private final Expr parenExpr() {
        if (this.curt != 44) {
            return this.unaryExpr();
        }
        Location location = this.loc;
        this.consume(44);
        Type type = this.tryCastType();
        if (type != null) {
            this.consume(45);
            return new Expr.Cast(location, type, this.parenExpr());
        }
        Expr expr = this.expr();
        this.consume(45);
        Expr expr2;
        while ((expr2 = this.termSuffixExpr(expr)) != null) {
            expr = expr2;
        }
        return expr;
    }

    private final Expr unaryExpr() {
        if (this.curt == 14) {
            this.consume();
            return this.parenExpr();
        }
        if (this.curt == 131) {
            return this.newExpr();
        }
        if (this.curt == 112) {
            return this.deleteExpr();
        }
        if (this.curt == 26 || this.curt == 15 || this.curt == 27 || this.curt == 37 || this.curt == 38) {
            return new Expr.Unary(this.loc, this.consume(), this.parenExpr(), false);
        }
        Expr expr = this.termExpr();
        if (this.curt == 37 || this.curt == 38) {
            return new Expr.Unary(this.loc, this.consume(), expr, true);
        }
        return expr;
    }

    private final Expr newExpr() {
        Expr.New new_ = new Expr.New(this.loc);
        this.consume();
        new_.of = this.tryTypeBase();
        if (new_.of == null) {
            throw this.err("Expected type name");
        }
        if (this.curt == 42) {
            this.consume();
            new_.arrayLength = this.expr();
            this.consume(43);
        } else {
            this.consume(44);
            this.consume(45);
        }
        return new_;
    }

    private final Expr deleteExpr() {
        Expr.Delete delete = new Expr.Delete(this.loc);
        this.consume();
        delete.target = this.expr();
        return delete;
    }

    private final Expr termExpr() {
        Expr expr = this.termBaseExpr();
        Expr expr2;
        while ((expr2 = this.termSuffixExpr(expr)) != null) {
            expr = expr2;
        }
        return expr;
    }

    private final Expr termBaseExpr() {
        if (this.cur.isLiteral()) {
            return this.literal();
        }
        Location location = this.loc;
        switch (this.curt) {
            case 1: {
                return this.idExpr(null, false);
            }
            case 143: {
                this.consume();
                return new Expr.This(location);
            }
            case 141: {
                this.consume();
                return new Expr.Super(location);
            }
        }
        Type type = this.cur.typeKeyword(this.ns);
        if (type != null && this.peekt == 10) {
            this.consume();
            this.consume();
            if (this.curt == 1) {
                String string = this.consumeId();
                if (string.equals("type")) {
                    return new Expr.Literal(location, this.ns, 11, (Object)type);
                }
                if (string.equals("sizeof")) {
                    return new Expr.Literal(location, this.ns, 14, (Object)type);
                }
            }
            throw this.err("Expected type literal expression, not '" + this.cur + '\'');
        }
        throw this.err("Expected expression, not '" + this.cur + '\'');
    }

    public Expr.Literal literal() {
        Location location = this.loc;
        if (this.curt == 15) {
            Expr.Literal literal;
            this.consume();
            switch (this.curt) {
                case 3: {
                    literal = new Expr.Literal(location, this.ns, 3, this.consume().value);
                    break;
                }
                case 4: {
                    literal = new Expr.Literal(location, this.ns, 4, this.consume().value);
                    break;
                }
                case 5: {
                    literal = new Expr.Literal(location, this.ns, 5, this.consume().value);
                    break;
                }
                case 6: {
                    literal = new Expr.Literal(location, this.ns, 6, this.consume().value);
                    break;
                }
                case 8: {
                    literal = new Expr.Literal(location, this.ns, 7, this.consume().value);
                    break;
                }
                default: {
                    throw this.err("Expected int, long, float, double, or time literal, not '" + this.cur + '\'');
                }
            }
            return literal.negate();
        }
        switch (this.curt) {
            case 144: {
                this.consume();
                return new Expr.Literal(location, this.ns, 1, (Object)Boolean.TRUE);
            }
            case 118: {
                this.consume();
                return new Expr.Literal(location, this.ns, 2, (Object)Boolean.FALSE);
            }
            case 3: {
                return new Expr.Literal(location, this.ns, 3, this.consume().value);
            }
            case 4: {
                return new Expr.Literal(location, this.ns, 4, this.consume().value);
            }
            case 5: {
                return new Expr.Literal(location, this.ns, 5, this.consume().value);
            }
            case 6: {
                return new Expr.Literal(location, this.ns, 6, this.consume().value);
            }
            case 132: {
                this.consume();
                return new Expr.Literal(location, this.ns, 8, null);
            }
            case 8: {
                return new Expr.Literal(location, this.ns, 7, this.consume().value);
            }
            case 7: {
                return new Expr.Literal(location, this.ns, 9, this.consume().value);
            }
            case 9: {
                return new Expr.Literal(location, this.ns, 10, this.consume().value);
            }
        }
        throw this.err("Expected literal, not '" + this.cur + '\'');
    }

    private final Expr idExpr(Expr expr, boolean bl) {
        Expr.Name name;
        Location location = this.loc;
        String string = this.consumeId();
        if (this.curt == 44) {
            name = new Expr.Call(location, expr, string, this.callArgs());
        } else {
            if (this.curt == 23) {
                this.consume(23);
                string = string + "::" + this.consumeId();
            }
            name = new Expr.Name(location, expr, string);
        }
        name.safeNav = bl;
        return name;
    }

    private final Expr[] callArgs() {
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        this.consume(44);
        if (this.curt != 45) {
            while (true) {
                arrayList.add(this.expr());
                if (this.curt == 45) break;
                this.consume(11);
            }
        }
        this.consume(45);
        return arrayList.toArray(new Expr[arrayList.size()]);
    }

    private final Expr termSuffixExpr(Expr expr) {
        if (this.curt == 10) {
            this.consume(10);
            return this.idExpr(expr, false);
        }
        if (this.curt == 57) {
            this.consume(57);
            return this.idExpr(expr, true);
        }
        if (this.curt == 42) {
            Location location = this.loc;
            this.consume(42);
            if (this.curt == 43) {
                throw this.err("Local variable array types not supported yet");
            }
            Expr expr2 = this.expr();
            this.consume(43);
            return new Expr.Index(location, expr, expr2);
        }
        return null;
    }

    private final FacetDef[] facets() {
        if (this.curt != 28) {
            return FacetDef.empty;
        }
        ArrayList<FacetDef> arrayList = new ArrayList<FacetDef>();
        while (this.curt == 28) {
            Expr expr;
            this.consume();
            Location location = this.loc;
            String string = this.consumeId();
            if (this.curt == 46) {
                this.consume(46);
                expr = this.expr();
            } else {
                expr = new Expr.Literal(location, this.ns, 1, (Object)Boolean.TRUE);
            }
            arrayList.add(new FacetDef(location, string, expr));
        }
        return arrayList.toArray(new FacetDef[arrayList.size()]);
    }

    public Type type() {
        try {
            Type type = this.doTryType();
            if (type != null) {
                return type;
            }
            throw this.err("Expected type name", this.loc);
        }
        catch (ParseTypeException parseTypeException) {
            throw this.err(parseTypeException.getMessage(), parseTypeException.loc);
        }
    }

    public Type tryType() {
        try {
            return this.doTryType();
        }
        catch (ParseTypeException parseTypeException) {
            return null;
        }
    }

    private final Type doTryType() {
        Type type = this.tryTypeBase();
        if (type == null) {
            return null;
        }
        if (this.curt == 42) {
            type = this.arrayType(type);
        }
        if (this.curt == 42) {
            throw new ParseTypeException("Multi-dimensional arrays not supported", this.cur.loc);
        }
        return type;
    }

    public Type tryTypeBase() {
        Type type = this.cur.typeKeyword(this.ns);
        if (type != null) {
            this.consume();
            return type;
        }
        Location location = this.loc;
        if (this.curt == 1) {
            String string = this.consumeId();
            if (this.curt == 23) {
                this.consume();
                string = string + "::" + this.consumeId();
            }
            return new UnresolvedType(location, string);
        }
        return null;
    }

    private final Type arrayType(Type type) {
        this.consume(42);
        Location location = this.cur.loc;
        if (this.curt == 43) {
            type = new ArrayType(location, type, null);
        } else if (this.curt == 1) {
            String string = this.defineId();
            type = new ArrayType(location, type, new ArrayType.UnresolvedLen(string));
        } else if (this.curt == 3) {
            int n = this.consume().valueToInt();
            type = new ArrayType(location, type, new ArrayType.LiteralLen(n));
        } else {
            throw new ParseTypeException("Expected array length, not '" + this.cur + '\'', location);
        }
        if (this.curt != 43) {
            throw new ParseTypeException("Expected ']', not '" + this.cur + '\'', location);
        }
        this.consume();
        return type;
    }

    private final Type tryCastType() {
        int n = this.pos;
        Type type = this.tryType();
        if (type != null && this.curt == 45 && (this.peekt == 1 || this.peekt == 27 || this.peekt == 26 || this.peekt == 44 || this.peek.isLiteral() || this.peek.isKeyword())) {
            return type;
        }
        this.reset(n);
        return null;
    }

    private final String defineId() {
        String string = this.consumeId();
        if (this.curt == 23) {
            this.consume();
            string = string + "::" + this.consumeId();
        }
        if (this.curt == 10) {
            this.consume();
            string = string + '.' + this.consumeId();
        }
        return string;
    }

    public CompilerException err(String string) {
        return super.err(string, this.cur.loc);
    }

    protected String consumeId() {
        return this.consume((int)1).value.toString();
    }

    protected Token consume(int n) {
        this.verify(n);
        return this.consume();
    }

    protected Token consume(int n, String string) {
        this.verify(n, string);
        return this.consume();
    }

    protected void verify(int n) {
        if (this.curt != n) {
            throw this.err("Expected '" + Token.toString(n) + "', not '" + this.cur.toString() + '\'');
        }
    }

    protected void verify(int n, String string) {
        if (this.curt != n) {
            throw this.err(string);
        }
    }

    protected Token consume() {
        Token token = this.cur;
        ++this.pos;
        Token token2 = this.pos + 1 < this.numTokens ? this.tokens[this.pos + 1] : this.tokens[this.numTokens - 1];
        this.cur = this.peek;
        this.peek = token2;
        this.curt = this.cur.type;
        this.peekt = this.peek.type;
        this.loc = this.cur.loc;
        boolean bl = false;
        if (token.loc.line < this.cur.loc.line) {
            bl = true;
        }
        this.curIsNewline = bl;
        return token;
    }

    public void readTokens() {
        this.tokens = this.tokenizer.tokenize();
        this.numTokens = this.tokens.length;
        this.reset(0);
    }

    protected void reset(int n) {
        this.pos = n;
        this.cur = this.tokens[n];
        this.peek = n + 1 < this.numTokens ? this.tokens[n + 1] : this.tokens[n];
        this.curt = this.cur.type;
        this.peekt = this.peek.type;
        this.loc = this.cur.loc;
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            File file = new File(stringArray[0]);
            Parser parser = new Parser(null, file);
            parser.parse()[0].dump();
        }
        catch (CompilerException compilerException) {
            System.out.println(compilerException.toLogString());
            compilerException.printStackTrace();
        }
    }

    public Parser(Compiler compiler, File file) {
        super(compiler);
        this.filename = Location.toString(file);
        this.tokenizer = new Tokenizer(compiler, this.filename, Tokenizer.readFile(file));
    }

    public Parser(Compiler compiler, Location location, InputStream inputStream) {
        super(compiler);
        this.filename = location.file;
        this.tokenizer = new Tokenizer(compiler, this.filename, Tokenizer.readFile(location, inputStream));
    }

    public Parser(Compiler compiler, String string) {
        super(compiler);
        this.filename = "test";
        this.tokenizer = new Tokenizer(compiler, "test", string.toCharArray());
    }

    static class ParseTypeException
    extends RuntimeException {
        Location loc;

        ParseTypeException(String string, Location location) {
            super(string);
            this.loc = location;
        }
    }
}

