/*
 * Decompiled with CFR 0.152.
 */
package sedonac.jasm;

import sedonac.Compiler;
import sedonac.CompilerSupport;
import sedonac.ast.FieldDef;
import sedonac.ast.MethodDef;
import sedonac.ast.SlotDef;
import sedonac.ir.IrKit;
import sedonac.jasm.Assembler;
import sedonac.jasm.Code;
import sedonac.jasm.JavaClass;
import sedonac.jasm.JavaClassAsm;
import sedonac.jasm.MethodInfo;
import sedonac.jasm.OpCodes;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JavaSlotAccessorAsm
extends CompilerSupport
implements OpCodes {
    IrKit ir;
    SlotDef slot;
    int parentCls;
    int fieldRef;

    public JavaClass assemble() {
        Object object;
        String string = "Acc_" + this.slot.parent.name + '_' + this.slot.name;
        String string2 = "sedona/vm/" + this.ir.name + '/' + string;
        Assembler assembler = new Assembler(string2, "sedona/vm/SlotAccessor", 17, null);
        this.assembleCtor(assembler);
        if (this.slot.isField()) {
            object = (FieldDef)this.slot;
            switch (((FieldDef)object).type.id()) {
                case 1: {
                    this.assembleBoolProp(assembler);
                    break;
                }
                case 2: {
                    this.assembleByteProp(assembler);
                    break;
                }
                case 3: {
                    this.assembleShortProp(assembler);
                    break;
                }
                case 4: {
                    this.assembleIntProp(assembler);
                    break;
                }
                case 5: {
                    this.assembleLongProp(assembler);
                    break;
                }
                case 6: {
                    this.assembleFloatProp(assembler);
                    break;
                }
                case 7: {
                    this.assembleDoubleProp(assembler);
                    break;
                }
                case 8: {
                    this.assembleBufProp(assembler);
                    break;
                }
                default: {
                    throw new IllegalStateException(((FieldDef)object).type().toString());
                }
            }
        } else {
            object = (MethodDef)this.slot;
            switch (((MethodDef)object).actionType(this.ns).id()) {
                case 0: {
                    this.assembleVoidAction(assembler);
                    break;
                }
                case 1: {
                    this.assembleBoolAction(assembler);
                    break;
                }
                case 4: {
                    this.assembleIntAction(assembler);
                    break;
                }
                case 5: {
                    this.assembleLongAction(assembler);
                    break;
                }
                case 6: {
                    this.assembleFloatAction(assembler);
                    break;
                }
                case 7: {
                    this.assembleDoubleAction(assembler);
                    break;
                }
                case 8: {
                    this.assembleBufAction(assembler);
                    break;
                }
                default: {
                    throw new IllegalStateException(((MethodDef)object).actionType(this.ns).toString());
                }
            }
        }
        object = new JavaClass();
        ((JavaClass)object).kitName = this.ir.name;
        ((JavaClass)object).name = string;
        ((JavaClass)object).qname = this.ir.name + "::" + string;
        ((JavaClass)object).classfile = assembler.compile();
        return object;
    }

    void assembleCtor(Assembler assembler) {
        Code code = new Code(assembler);
        code.add(42);
        code.add(183, assembler.cp.method("sedona/vm/SlotAccessor", "<init>", "()V"));
        code.add(177);
        code.maxLocals = 1;
        code.maxStack = 2;
        assembler.addMethod(new MethodInfo(assembler, "<init>", "()V", 1, code));
    }

    void assembleBoolProp(Assembler assembler) {
        this.assembleGetter(assembler, "getBool", "(Ljava/lang/Object;)B", 172, 0);
        this.assembleSetter(assembler, "setBool", "(Ljava/lang/Object;B)V", 28);
    }

    void assembleByteProp(Assembler assembler) {
        this.assembleGetter(assembler, "getInt", "(Ljava/lang/Object;)I", 172, 255);
        this.assembleSetter(assembler, "setInt", "(Ljava/lang/Object;I)V", 28);
    }

    void assembleShortProp(Assembler assembler) {
        this.assembleGetter(assembler, "getInt", "(Ljava/lang/Object;)I", 172, (char)-1);
        this.assembleSetter(assembler, "setInt", "(Ljava/lang/Object;I)V", 28);
    }

    void assembleIntProp(Assembler assembler) {
        this.assembleGetter(assembler, "getInt", "(Ljava/lang/Object;)I", 172, 0);
        this.assembleSetter(assembler, "setInt", "(Ljava/lang/Object;I)V", 28);
    }

    void assembleLongProp(Assembler assembler) {
        this.assembleGetter(assembler, "getLong", "(Ljava/lang/Object;)J", 173, 0);
        this.assembleSetter(assembler, "setLong", "(Ljava/lang/Object;J)V", 32);
    }

    void assembleFloatProp(Assembler assembler) {
        this.assembleGetter(assembler, "getFloat", "(Ljava/lang/Object;)F", 174, 0);
        this.assembleSetter(assembler, "setFloat", "(Ljava/lang/Object;F)V", 36);
    }

    void assembleDoubleProp(Assembler assembler) {
        this.assembleGetter(assembler, "getDouble", "(Ljava/lang/Object;)D", 175, 0);
        this.assembleSetter(assembler, "setDouble", "(Ljava/lang/Object;D)V", 40);
    }

    void assembleBufProp(Assembler assembler) {
        this.assembleGetter(assembler, "getBuf", "(Ljava/lang/Object;)Ljava/lang/Object;", 176, 0);
    }

    void assembleGetter(Assembler assembler, String string, String string2, int n, int n2) {
        Code code = new Code(assembler);
        code.add(43);
        code.add(192, this.parentCls(assembler));
        code.add(180, this.fieldRef(assembler));
        if (n2 != 0) {
            code.addIntConst(n2);
            code.add(126);
        }
        code.add(n);
        code.maxLocals = 2;
        code.maxStack = 2;
        assembler.addMethod(new MethodInfo(assembler, string, string2, 17, code));
    }

    void assembleSetter(Assembler assembler, String string, String string2, int n) {
        Code code = new Code(assembler);
        code.add(43);
        code.add(192, this.parentCls(assembler));
        code.add(n);
        code.add(181, this.fieldRef(assembler));
        code.add(177);
        code.maxLocals = 4;
        code.maxStack = 3;
        assembler.addMethod(new MethodInfo(assembler, string, string2, 17, code));
    }

    void assembleVoidAction(Assembler assembler) {
        this.assembleInvoke(assembler, "invokeVoid", "(Ljava/lang/Object;)V", 0);
    }

    void assembleBoolAction(Assembler assembler) {
        this.assembleInvoke(assembler, "invokeBool", "(Ljava/lang/Object;B)V", 28);
    }

    void assembleIntAction(Assembler assembler) {
        this.assembleInvoke(assembler, "invokeInt", "(Ljava/lang/Object;I)V", 28);
    }

    void assembleLongAction(Assembler assembler) {
        this.assembleInvoke(assembler, "invokeLong", "(Ljava/lang/Object;J)V", 32);
    }

    void assembleFloatAction(Assembler assembler) {
        this.assembleInvoke(assembler, "invokeFloat", "(Ljava/lang/Object;F)V", 36);
    }

    void assembleDoubleAction(Assembler assembler) {
        this.assembleInvoke(assembler, "invokeDouble", "(Ljava/lang/Object;D)V", 40);
    }

    void assembleBufAction(Assembler assembler) {
        this.assembleInvoke(assembler, "invokeBuf", "(Ljava/lang/Object;Ljava/lang/Object;)V", 44);
    }

    void assembleInvoke(Assembler assembler, String string, String string2, int n) {
        Code code = new Code(assembler);
        code.add(43);
        code.add(192, this.parentCls(assembler));
        if (n != 0) {
            code.add(n);
        }
        if (string.equals("invokeBuf")) {
            code.add(192, assembler.cp.cls("sedona/vm/sys/Buf"));
        }
        code.add(182, this.methodRef(assembler));
        code.add(177);
        code.maxLocals = 4;
        code.maxStack = 4;
        assembler.addMethod(new MethodInfo(assembler, string, string2, 17, code));
    }

    int parentCls(Assembler assembler) {
        if (this.parentCls == 0) {
            this.parentCls = assembler.cp.cls(JavaClassAsm.jname(this.slot.parent, false));
        }
        return this.parentCls;
    }

    int fieldRef(Assembler assembler) {
        if (this.fieldRef == 0) {
            this.fieldRef = assembler.cp.field(this.parentCls(assembler), this.slot.name, JavaClassAsm.jsig(((FieldDef)this.slot).type));
        }
        return this.fieldRef;
    }

    int methodRef(Assembler assembler) {
        if (this.fieldRef == 0) {
            this.fieldRef = assembler.cp.method(this.parentCls(assembler), this.slot.name, JavaClassAsm.jsig((MethodDef)this.slot));
        }
        return this.fieldRef;
    }

    private final /* synthetic */ void this() {
        this.parentCls = 0;
        this.fieldRef = 0;
    }

    public JavaSlotAccessorAsm(Compiler compiler, SlotDef slotDef) {
        super(compiler);
        this.this();
        this.ir = this.compiler.ir;
        this.slot = slotDef;
    }
}

