/*
 * Decompiled with CFR 0.152.
 */
package sedonac.jasm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import sedona.Buf;
import sedonac.Compiler;
import sedonac.CompilerSupport;
import sedonac.ast.FieldDef;
import sedonac.ast.KitDef;
import sedonac.ast.MethodDef;
import sedonac.ast.SlotDef;
import sedonac.ast.TypeDef;
import sedonac.ir.IrField;
import sedonac.ir.IrFlat;
import sedonac.ir.IrKit;
import sedonac.ir.IrMethod;
import sedonac.ir.IrSlot;
import sedonac.jasm.Assembler;
import sedonac.jasm.Code;
import sedonac.jasm.ConstantPool;
import sedonac.jasm.FieldInfo;
import sedonac.jasm.JavaClass;
import sedonac.jasm.JavaClassAsm;
import sedonac.jasm.JavaSlotAccessorAsm;
import sedonac.jasm.MethodInfo;
import sedonac.jasm.OpCodes;
import sedonac.namespace.Method;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;
import sedonac.steps.FindTestCases;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JavaKitAsm
extends CompilerSupport
implements OpCodes {
    KitDef ast;
    IrKit ir;
    final String jnameKitConst;
    final String jnameBootstrap;
    boolean isSys;
    ArrayList classes;
    HashMap strings;
    HashMap bufs;
    ArrayList logs;

    public JavaClass[] assemble() {
        this.assembleTypeClasses();
        this.assembleKitClass();
        this.assembleBootstrapClass();
        return this.classes.toArray(new JavaClass[this.classes.size()]);
    }

    void assembleTypeClasses() {
        int n = 0;
        while (n < this.ir.types.length) {
            this.classes.add(new JavaClassAsm(this, this.ir.types[n]).assemble());
            ++n;
        }
    }

    void assembleKitClass() {
        Assembler assembler = new Assembler(this.jnameKitConst, "java/lang/Object", 1, null);
        Code code = new Code(assembler);
        this.assembleReflect(assembler, code);
        code.add(177);
        code.maxLocals = 4;
        code.maxStack = 4;
        assembler.addMethod(new MethodInfo(assembler, "initReflect", "()V", 8, code));
        Code code2 = new Code(assembler);
        this.assembleTests(assembler, code2);
        code2.add(177);
        code2.maxLocals = 4;
        code2.maxStack = 4;
        assembler.addMethod(new MethodInfo(assembler, "initTests", "()V", 8, code2));
        Code code3 = new Code(assembler);
        this.assembleStrConsts(assembler, code3);
        this.assembleBufConsts(assembler, code3);
        this.assembleLogConsts(assembler, code3);
        code3.add(184, assembler.cp.method(this.jnameKitConst, "initReflect", "()V"));
        code3.add(184, assembler.cp.method(this.jnameKitConst, "initTests", "()V"));
        code3.add(177);
        code3.maxLocals = 4;
        code3.maxStack = 4;
        assembler.addMethod(new MethodInfo(assembler, "<clinit>", "()V", 9, code3));
        Code code4 = new Code(assembler);
        code4.add(42);
        code4.add(183, assembler.cp.method("java/lang/Object", "<init>", "()V"));
        code4.add(177);
        code4.maxLocals = 1;
        code4.maxStack = 2;
        assembler.addMethod(new MethodInfo(assembler, "<init>", "()V", 1, code4));
        JavaClass javaClass = new JavaClass();
        javaClass.kitName = this.ir.name;
        javaClass.name = "KitConst";
        javaClass.qname = this.ir.name + "::KitConst";
        javaClass.classfile = assembler.compile();
        this.classes.add(javaClass);
    }

    void assembleBootstrapClass() {
        Object object;
        Object object2;
        Assembler assembler = new Assembler(this.jnameBootstrap, "java/lang/Object", 1, null);
        Code code = new Code(assembler);
        code.maxLocals = 4;
        code.maxStack = 0;
        IrFlat irFlat = new IrFlat(this.compiler.ns, new IrKit[]{this.compiler.ir});
        irFlat.preResolve();
        IrMethod[] irMethodArray = irFlat.staticInits;
        int n = assembler.cp.field("sedona/vm/sys/Sys", "context", "Lsedona/vm/Context;");
        int n2 = 0;
        while (n2 < irMethodArray.length) {
            object2 = irMethodArray[n2];
            object = JavaClassAsm.jname(((IrSlot)object2).parent(), false);
            String string = JavaClassAsm.jsig((Method)object2);
            int n3 = assembler.cp.cls((String)object);
            int n4 = assembler.cp.nt(((IrSlot)object2).name(), string);
            if (string.indexOf("Lsedona/vm/Context;") != -1) {
                code.add(178, n);
                ++code.maxStack;
            }
            code.add(184, assembler.cp.method(n3, n4));
            ++n2;
        }
        code.add(177);
        assembler.addMethod(new MethodInfo(assembler, "bootstrap", "()V", 9, code));
        Code code2 = new Code(assembler);
        code2.add(177);
        code2.maxLocals = 4;
        code2.maxStack = 4;
        assembler.addMethod(new MethodInfo(assembler, "<clinit>", "()V", 9, code2));
        object2 = new Code(assembler);
        ((Code)object2).add(42);
        ((Code)object2).add(183, assembler.cp.method("java/lang/Object", "<init>", "()V"));
        ((Code)object2).add(177);
        ((Code)object2).maxLocals = 1;
        ((Code)object2).maxStack = 2;
        assembler.addMethod(new MethodInfo(assembler, "<init>", "()V", 1, (Code)object2));
        object = new JavaClass();
        ((JavaClass)object).kitName = this.ir.name;
        ((JavaClass)object).name = "JsvmBootstrap";
        ((JavaClass)object).qname = this.ir.name + "::JsvmBootstrap";
        ((JavaClass)object).classfile = assembler.compile();
        this.classes.add(object);
    }

    void assembleReflect(Assembler assembler, Code code) {
        int n;
        TypeDef[] typeDefArray = this.findReflectiveTypes();
        this.assembleKit(assembler, code, this.typesLen(typeDefArray));
        if (this.isSys) {
            n = 0;
            while (n < this.ns.primitiveTypes.length) {
                this.assembleType(assembler, code, this.ns.primitiveTypes[n]);
                ++n;
            }
        }
        n = 0;
        while (n < typeDefArray.length) {
            this.assembleType(assembler, code, typeDefArray[n]);
            ++n;
        }
        n = 0;
        while (n < typeDefArray.length) {
            TypeDef typeDef = typeDefArray[n];
            if (typeDef.reflectiveSlots != null) {
                int n2 = 0;
                while (n2 < typeDef.reflectiveSlots.length) {
                    this.assembleSlot(assembler, code, typeDef.reflectiveSlots[n2]);
                    ++n2;
                }
            }
            ++n;
        }
    }

    TypeDef[] findReflectiveTypes() {
        ArrayList<TypeDef> arrayList = new ArrayList<TypeDef>();
        int n = 0;
        while (n < this.ast.types.length) {
            TypeDef typeDef = this.ast.types[n];
            if (typeDef.isReflective()) {
                arrayList.add(typeDef);
            }
            ++n;
        }
        return arrayList.toArray(new TypeDef[arrayList.size()]);
    }

    int typesLen(TypeDef[] typeDefArray) {
        if (typeDefArray.length == 0) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < typeDefArray.length) {
            n = Math.max(n, typeDefArray[n2].id);
            ++n2;
        }
        return n + 1;
    }

    void assembleKit(Assembler assembler, Code code, int n) {
        ConstantPool constantPool = assembler.cp;
        int n2 = constantPool.cls("sedona/vm/sys/Kit");
        int n3 = constantPool.method(n2, "<init>", "()V");
        String string = "kit";
        int n4 = 9;
        assembler.addField(new FieldInfo(assembler, "kit", "Lsedona/vm/sys/Kit;", n4));
    }

    void assembleType(Assembler assembler, Code code, Type type) {
        ConstantPool constantPool = assembler.cp;
        int n = constantPool.cls("sedona/vm/sys/Type");
        int n2 = constantPool.method(n, "<init>", "()V");
        String string = "type" + type.name();
        int n3 = assembler.cp.field(this.jnameKitConst, string, "Lsedona/vm/sys/Type;");
        int n4 = 9;
        assembler.addField(new FieldInfo(assembler, string, "Lsedona/vm/sys/Type;", n4));
    }

    void assembleSlot(Assembler assembler, Code code, SlotDef slotDef) {
        ConstantPool constantPool = assembler.cp;
        int n = constantPool.cls("sedona/vm/sys/Slot");
        int n2 = constantPool.method(n, "<init>", "()V");
        String string = "slot" + slotDef.parent.name + '_' + slotDef.name;
        int n3 = assembler.cp.field(this.jnameKitConst, string, "Lsedona/vm/sys/Slot;");
        JavaClass javaClass = new JavaSlotAccessorAsm(this.compiler, slotDef).assemble();
        this.classes.add(javaClass);
        int n4 = 9;
        assembler.addField(new FieldInfo(assembler, string, "Lsedona/vm/sys/Slot;", n4));
    }

    Type slotReflectionType(Slot slot) {
        if (slot.isField()) {
            return ((FieldDef)slot).type();
        }
        MethodDef methodDef = (MethodDef)slot;
        if (methodDef.params.length == 0) {
            return this.ns.voidType;
        }
        return methodDef.params[0].type;
    }

    void assembleTests(Assembler assembler, Code code) {
        int n = 9;
        assembler.addField(new FieldInfo(assembler, "tests", "[Ljava/lang/String;", n));
        IrMethod[] irMethodArray = FindTestCases.findTestMethods(this.ir.types, true);
        code.addIntConst(irMethodArray.length);
        code.add(189, assembler.cp.cls("java/lang/String"));
        int n2 = 0;
        while (n2 < irMethodArray.length) {
            code.add(89);
            code.addIntConst(n2);
            code.add(18, assembler.cp.string(irMethodArray[n2].qname()));
            code.add(83);
            ++n2;
        }
        code.add(179, assembler.cp.field(this.jnameKitConst, "tests", "[Ljava/lang/String;"));
    }

    void assembleStrConsts(Assembler assembler, Code code) {
        if (this.strings.size() == 0) {
            return;
        }
        int n = assembler.cp.method("sedona/vm/VmUtil", "strConst", "(Ljava/lang/String;)Lsedona/vm/StrRef;");
        Iterator iterator = this.strings.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.strings.get(string);
            int n2 = 9;
            assembler.addField(new FieldInfo(assembler, string2, "Lsedona/vm/StrRef;", n2));
            code.add(18, assembler.cp.string(string));
            code.add(184, n);
            code.add(179, assembler.cp.field(this.jnameKitConst, string2, "Lsedona/vm/StrRef;"));
        }
    }

    void assembleBufConsts(Assembler assembler, Code code) {
        if (this.bufs.size() == 0) {
            return;
        }
        int n = assembler.cp.method("sedona/vm/VmUtil", "bufConst", "(Ljava/lang/String;)[B");
        int n2 = assembler.cp.cls("sedona/vm/sys/Buf");
        int n3 = assembler.cp.method(n2, "<init>", "()V");
        int n4 = assembler.cp.field(n2, "bytes", "[B");
        int n5 = assembler.cp.field(n2, "size", "S");
        int n6 = assembler.cp.field(n2, "bytesLen", "S");
        Iterator iterator = this.bufs.keySet().iterator();
        while (iterator.hasNext()) {
            Buf buf = (Buf)iterator.next();
            String string = (String)this.bufs.get(buf);
            int n7 = 9;
            assembler.addField(new FieldInfo(assembler, string, "Lsedona/vm/sys/Buf;", n7));
            code.add(187, n2);
            code.add(89);
            code.add(183, n3);
            code.add(89);
            code.add(18, assembler.cp.string(buf.encodeString()));
            code.add(184, n);
            code.add(181, n4);
            code.add(89);
            code.addIntConst(buf.size);
            code.add(181, n6);
            code.add(89);
            code.addIntConst(buf.size);
            code.add(181, n5);
            code.add(179, assembler.cp.field(this.jnameKitConst, string, "Lsedona/vm/sys/Buf;"));
        }
    }

    void assembleLogConsts(Assembler assembler, Code code) {
        int n = assembler.cp.cls("sedona/vm/sys/Log");
        int n2 = assembler.cp.method(n, "<init>", "()V");
        int n3 = 0;
        while (n3 < this.logs.size()) {
            IrField irField = (IrField)this.logs.get(n3);
            code.add(187, n);
            code.add(89);
            code.add(89);
            code.add(183, n2);
            code.add(179, JavaClassAsm.fieldRef(assembler, irField));
            int n4 = 9;
            String string = "log_" + irField.parent().name() + '_' + irField.name();
            assembler.addField(new FieldInfo(assembler, string, "Lsedona/vm/sys/Log;", n4));
            code.add(179, assembler.cp.field(this.jnameKitConst, string, "Lsedona/vm/sys/Log;"));
            ++n3;
        }
    }

    void loadStr(Code code, String string) {
        if (string == null) {
            throw new IllegalStateException();
        }
        String string2 = (String)this.strings.get(string);
        if (string2 == null) {
            string2 = "str" + this.strings.size();
            this.strings.put(string, string2);
        }
        code.add(178, code.cp.field(this.jnameKitConst, string2, "Lsedona/vm/StrRef;"));
    }

    void loadBuf(Code code, Buf buf) {
        if (buf == null) {
            throw new IllegalStateException();
        }
        String string = (String)this.bufs.get(buf);
        if (string == null) {
            string = "buf" + this.bufs.size();
            this.bufs.put(buf, string);
        }
        code.add(178, code.cp.field(this.jnameKitConst, string, "Lsedona/vm/sys/Buf;"));
    }

    void loadType(Code code, Type type) {
        if (type == null) {
            throw new IllegalStateException();
        }
        String string = type.isPrimitive() ? "sys" : type.kit().name();
        String string2 = "sedona/vm/" + string + "/KitConst";
        String string3 = "type" + type.name();
        String string4 = "Lsedona/vm/sys/Type;";
        code.add(178, code.cp.field(string2, string3, string4));
    }

    void loadSlot(Code code, Slot slot) {
        if (slot == null) {
            throw new IllegalStateException();
        }
        String string = "sedona/vm/" + slot.parent().kit().name() + "/KitConst";
        String string2 = "slot" + slot.parent().name() + '_' + slot.name();
        String string3 = "Lsedona/vm/sys/Slot;";
        code.add(178, code.cp.field(string, string2, string3));
    }

    private final /* synthetic */ void this() {
        this.ast = this.compiler.ast;
        this.ir = this.compiler.ir;
        this.classes = new ArrayList();
        this.strings = new HashMap();
        this.bufs = new HashMap();
        this.logs = new ArrayList();
    }

    public JavaKitAsm(Compiler compiler) {
        super(compiler);
        this.this();
        this.ir = this.compiler.ir;
        this.isSys = this.ir.name.equals("sys");
        this.jnameKitConst = "sedona/vm/" + this.ir.name + "/KitConst";
        this.jnameBootstrap = "sedona/vm/" + this.ir.name + "/JsvmBootstrap";
    }
}

