/*
 * Decompiled with CFR 0.152.
 */
package sedonac.jasm;

import java.util.NoSuchElementException;

public class IntHashMap {
    private Entry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.count == 0) {
            bl = true;
        }
        return bl;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public Object get(int n) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private final void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n) {
                Object object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(n, object);
        }
        entry = new Entry();
        entry.hash = n;
        entry.value = object;
        entry.next = entryArray[n2];
        entryArray[n2] = entry;
        ++this.count;
        return null;
    }

    public Object remove(int n) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public void clear() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntHashMap)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        IntHashMap intHashMap = (IntHashMap)object;
        if (this.size() != intHashMap.size()) {
            return false;
        }
        int n = 0;
        while (n < this.table.length) {
            Entry entry = this.table[n];
            while (entry != null) {
                Object object2 = entry.value;
                Object object3 = intHashMap.get(entry.hash);
                if (object3 == null || !object2.equals(object3)) {
                    return false;
                }
                entry = entry.next;
            }
            ++n;
        }
        return true;
    }

    public Object clone() {
        IntHashMap intHashMap = new IntHashMap(this.size() * 3);
        int n = 0;
        while (n < this.table.length) {
            Entry entry = this.table[n];
            while (entry != null) {
                intHashMap.put(entry.hash, entry.value);
                entry = entry.next;
            }
            ++n;
        }
        return intHashMap;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.table.length) {
            Entry entry = this.table[n2];
            while (entry != null && n < this.count) {
                objectArray[n++] = entry.value;
                entry = entry.next;
            }
            ++n2;
        }
        return objectArray;
    }

    public IntHashMap() {
        this(31, 0.75f);
    }

    public IntHashMap(int n) {
        this(n, 0.75f);
    }

    public IntHashMap(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Iterator
    implements java.util.Iterator {
        private int index;
        private Entry entry;
        private int key;

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.entry == null) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                this.entry = IntHashMap.access$0(IntHashMap.this)[this.index];
                if (this.entry == null) continue;
                return true;
lbl6:
                // 2 sources

                ** while (this.index-- > 0)
            }
lbl7:
            // 1 sources

            return false;
        }

        public int key() {
            return this.key;
        }

        public Object next() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = IntHashMap.this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                Entry entry = this.entry;
                this.entry = entry.next;
                this.key = entry.hash;
                return entry.value;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private final /* synthetic */ void this() {
            this.index = IntHashMap.this.table.length;
        }

        public Iterator() {
            this.this();
        }
    }

    static class Entry {
        int hash;
        Object value;
        Entry next;

        Entry() {
        }
    }
}

