/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ir;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import sedona.Bool;
import sedona.Facets;
import sedona.Value;
import sedonac.Compiler;
import sedonac.Location;
import sedonac.ast.Expr;
import sedonac.ir.IrField;
import sedonac.ir.IrKit;
import sedonac.ir.IrMethod;
import sedonac.ir.IrOp;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.namespace.NativeId;
import sedonac.namespace.Type;
import sedonac.parser.Parser;
import sedonac.parser.Token;
import sedonac.scode.SCode;

public class IrReader
extends Parser {
    public IrType readType(IrKit irKit) {
        this.readTokens();
        Facets facets = this.readFacets();
        int n = this.typeFlags();
        this.consume(107);
        String string = this.consumeId();
        Type type = null;
        if (!irKit.name.equals("sys") || !string.equals("Obj")) {
            this.consume(117);
            type = this.tryTypeBase();
        }
        IrType irType = new IrType(irKit, n, string, facets);
        irType.base = type;
        HashMap<String, IrSlot> hashMap = new HashMap<String, IrSlot>();
        ArrayList<IrSlot> arrayList = new ArrayList<IrSlot>();
        this.consume(40);
        while (this.curt != 41) {
            IrSlot irSlot = this.readSlot(irType);
            arrayList.add(irSlot);
            hashMap.put(irSlot.name, irSlot);
        }
        this.consume(41);
        irType.declared = arrayList.toArray(new IrSlot[arrayList.size()]);
        irType.slots = arrayList;
        irType.slotsByName = hashMap;
        return irType;
    }

    private final Facets readFacets() {
        if (this.curt != 28) {
            return new Facets();
        }
        Facets facets = new Facets();
        while (this.curt == 28) {
            this.consume();
            String string = this.consumeId();
            Bool bool = Bool.TRUE;
            if (this.curt == 46) {
                this.consume(46);
                bool = this.literal().toValue();
            }
            facets.set(string, (Value)bool);
        }
        return facets;
    }

    private final IrSlot readSlot(IrType irType) {
        Facets facets = this.readFacets();
        int n = this.slotFlags();
        Type type = this.type();
        String string = this.consumeId();
        if (this.curt == 44) {
            return this.readMethod(irType, n, string, facets, type);
        }
        return this.readField(irType, n, string, facets, type);
    }

    private final IrSlot readField(IrType irType, int n, String string, Facets facets, Type type) {
        Expr.Literal literal = null;
        boolean bl = false;
        if (this.curt == 46) {
            this.consume();
            if ((n & 8) != 0) {
                literal = this.curt == 40 ? this.arrayLiteral(n, type) : this.literal();
            } else {
                this.arrayInitializer();
                bl = true;
            }
        }
        if ((n & 0x400) != 0 && !type.isPrimitive()) {
            n |= 0x10;
        }
        IrField irField = new IrField(irType, n, string, facets, type);
        irField.define = literal;
        irField.arrayInit = bl;
        if (this.curt == 40) {
            this.consume(40);
            this.readFieldDirectives(irField);
            this.consume(41);
        }
        return irField;
    }

    private final void readFieldDirectives(IrField irField) {
        while (this.curt == 10) {
            this.consume();
            String string = this.consumeId();
            this.consume(46);
            if (string.equals("ctorLengthParam")) {
                irField.ctorLengthParam = Integer.parseInt(this.consume().toString());
                continue;
            }
            if (string.equals("ctorLengthArg")) {
                irField.ctorLengthArg = this.literalOrDefine();
                continue;
            }
            this.err("Unknown field directive: " + string);
        }
    }

    private final IrMethod readMethod(IrType irType, int n, String string, Facets facets, Type type) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        this.consume(44);
        while (this.curt != 45) {
            if (arrayList.size() > 0) {
                this.consume(11);
            }
            arrayList.add(this.type());
        }
        this.consume(45);
        Type[] typeArray = arrayList.toArray(new Type[arrayList.size()]);
        IrMethod irMethod = new IrMethod(irType, n, string, facets, type, typeArray);
        if (this.curt == 46) {
            this.consume(46);
            Location location = this.loc;
            int n2 = this.consume().valueToInt();
            this.consume(23);
            int n3 = this.consume().valueToInt();
            irMethod.nativeId = new NativeId(location, n2, n3);
        }
        if ((n & 0x41) != 0) {
            if (this.curt == 40) {
                throw this.err("Abstract and native methods cannot have method bodies");
            }
            if ((n & 0x40) != 0 && irMethod.nativeId == null) {
                throw this.err("Native method missing native id");
            }
        } else {
            if (this.curt != 40) {
                throw this.err("Expected method body");
            }
            this.consume(40);
            this.readCodeDirectives(irMethod);
            irMethod.code = this.readCode();
            this.consume(41);
        }
        return irMethod;
    }

    private final void readCodeDirectives(IrMethod irMethod) {
        while (this.curt == 10) {
            this.consume();
            String string = this.consumeId();
            this.consume(46);
            String string2 = this.consume().toString();
            if (string.equals("maxLocals")) {
                irMethod.maxLocals = Integer.parseInt(string2);
                continue;
            }
            this.err("Unknown code directive: " + string);
        }
    }

    private final IrOp[] readCode() {
        ArrayList<IrOp> arrayList = new ArrayList<IrOp>();
        while (this.curt != 41) {
            arrayList.add(this.readOp());
        }
        return arrayList.toArray(new IrOp[arrayList.size()]);
    }

    private final IrOp readOp() {
        IrOp irOp = new IrOp();
        irOp.index = this.consume(3).valueToInt();
        this.consume(13);
        String string = this.consumeId();
        irOp.opcode = SCode.opcode(string);
        if (irOp.opcode < 0) {
            throw this.err("Unknown opcode '" + string + '\'');
        }
        if (!this.curIsNewline) {
            Token token = this.consume();
            irOp.arg = token.toString();
            while (!this.curIsNewline) {
                irOp.arg = irOp.arg + this.consume().toString();
            }
        }
        return irOp;
    }

    private final Expr literalOrDefine() {
        if (this.curt != 1) {
            return this.literal();
        }
        Location location = this.cur.loc;
        String string = this.consumeId();
        this.consume(23);
        string = string + "::" + this.consumeId();
        this.consume(10);
        string = string + '.' + this.consumeId();
        return new Expr.Name(location, null, string);
    }

    public IrReader(Compiler compiler, Location location, InputStream inputStream) {
        super(compiler, location, inputStream);
    }
}

