/*
 * Decompiled with CFR 0.152.
 */
package sedonac.analysis;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.analysis.BasicBlock;
import sedonac.analysis.ControlFlowGraph;
import sedonac.ast.Expr;
import sedonac.ast.Stmt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefiniteAssignmentAnalysis
extends CompilerStep {
    private ControlFlowGraph cfg;
    private HashMap map;
    private HashMap errs;
    private boolean changed;
    private DefinedSets curBlockSets;

    public void run() {
        int n = 0;
        this.changed = true;
        while (this.changed) {
            ++n;
            this.changed = false;
            Iterator iterator = this.cfg.reversePostorderIterator();
            while (iterator.hasNext()) {
                BasicBlock basicBlock = (BasicBlock)iterator.next();
                this.curBlockSets = this.getBlockSets(basicBlock);
                if (this.curBlockSets == null) {
                    this.changed |= true;
                    this.curBlockSets = new DefinedSets();
                    this.map.put(basicBlock, this.curBlockSets);
                }
                this.computeDefinedIn(basicBlock);
                this.analyzeBlock(basicBlock);
                this.computeDefinedOut();
            }
        }
        this.reportErrors();
    }

    private final void reportErrors() {
        if (this.errs.size() == 0) {
            return;
        }
        Expr.Local[] localArray = this.errs.values().toArray(new Expr.Local[this.errs.size()]);
        Arrays.sort(localArray, new Comparator(){

            public final int compare(Object object, Object object2) {
                return ((Expr.Local)object).loc.compareTo(((Expr.Local)object2).loc);
            }
        });
        int n = 0;
        while (n < localArray.length) {
            this.err("Local variable '" + localArray[n].name + "' may not have been initalized", localArray[n].loc);
            ++n;
        }
    }

    private final DefinedSets getBlockSets(BasicBlock basicBlock) {
        return (DefinedSets)this.map.get(basicBlock);
    }

    private final void computeDefinedIn(BasicBlock basicBlock) {
        if (basicBlock == this.cfg.entry()) {
            return;
        }
        int n = basicBlock.backEdges.size();
        DefinedSets definedSets = null;
        HashSet hashSet = null;
        int n2 = 0;
        while (n2 < n) {
            BasicBlock basicBlock2 = (BasicBlock)basicBlock.backEdges.get(n2);
            if (basicBlock2 != basicBlock && (definedSets = this.getBlockSets(basicBlock2)) != null) {
                if (hashSet == null) {
                    hashSet = new HashSet(definedSets.defOut);
                } else {
                    this.intersect(hashSet, definedSets.defOut);
                }
                if (hashSet.isEmpty()) break;
            }
            ++n2;
        }
        if (hashSet.size() != this.curBlockSets.defIn.size()) {
            this.changed |= true;
            this.curBlockSets.defIn = hashSet;
        } else {
            Iterator iterator = this.curBlockSets.defIn.iterator();
            while (iterator.hasNext()) {
                if (hashSet.contains(iterator.next())) continue;
                this.changed |= true;
                this.curBlockSets.defIn = hashSet;
                break;
            }
        }
    }

    private final void computeDefinedOut() {
        this.curBlockSets.defOut = new HashSet(this.curBlockSets.defIn);
        if (!this.curBlockSets.defAt.isEmpty()) {
            this.curBlockSets.defOut.addAll(this.curBlockSets.defAt);
        }
    }

    private final void analyzeBlock(BasicBlock basicBlock) {
        Stmt[] stmtArray = basicBlock.stmts();
        int n = 0;
        while (n < stmtArray.length) {
            Stmt stmt = stmtArray[n];
            switch (stmt.id) {
                case 2: {
                    this.localDefStmt((Stmt.LocalDef)stmt);
                    break;
                }
                case 1: {
                    this.doExpr(((Stmt.ExprStmt)stmt).expr);
                    break;
                }
                case 11: {
                    this.doExpr(((Stmt.Assert)stmt).cond);
                    break;
                }
                case 4: {
                    this.doExpr(((Stmt.If)stmt).cond);
                    break;
                }
                case 13: {
                    this.doExpr(((Stmt.Switch)stmt).cond);
                    break;
                }
                case 8: {
                    this.doExpr(((Stmt.DoWhile)stmt).cond);
                    break;
                }
                case 7: {
                    this.doExpr(((Stmt.While)stmt).cond);
                    break;
                }
                case 3: {
                    this.doExpr(((Stmt.Return)stmt).expr);
                    break;
                }
                case 5: {
                    this.forStmt((Stmt.For)stmt);
                    break;
                }
                case 6: {
                    this.forEachStmt((Stmt.Foreach)stmt);
                    break;
                }
                case 9: 
                case 10: 
                case 12: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown Statement: " + stmt.loc);
                }
            }
            ++n;
        }
    }

    private final void localDefStmt(Stmt.LocalDef localDef) {
        if (localDef.init != null) {
            this.curBlockSets.defAt.add(localDef);
            this.doExpr(localDef.init);
        }
    }

    private final void forEachStmt(Stmt.Foreach foreach) {
        this.curBlockSets.defAt.add(foreach.local);
        this.doExpr(foreach.array);
        this.doExpr(foreach.length);
    }

    private final void forStmt(Stmt.For for_) {
        this.doExpr(for_.cond);
    }

    private final void doExpr(Expr expr) {
        if (expr == null) {
            return;
        }
        switch (expr.id) {
            case 60: {
                this.checkDefinitelyAssigned((Expr.Local)expr);
                break;
            }
            case 65: 
            case 71: {
                this.callExpr((Expr.Call)expr);
                break;
            }
            case 45: {
                this.assignExpr((Expr.Binary)expr);
                break;
            }
            case 64: {
                this.indexExpr((Expr.Index)expr);
                break;
            }
            case 72: {
                this.interpolateExpr((Expr.Interpolation)expr);
                break;
            }
            case 27: 
            case 28: {
                this.condExpr((Expr.Cond)expr);
                break;
            }
            case 57: {
                this.ternaryExpr((Expr.Ternary)expr);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                this.doExpr(((Expr.Unary)expr).operand);
                break;
            }
            case 66: {
                this.doExpr(((Expr.Cast)expr).target);
                break;
            }
            case 56: {
                this.doExpr(((Expr.Binary)expr).lhs);
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                Expr.Binary binary = (Expr.Binary)expr;
                this.doExpr(binary.lhs);
                this.doExpr(binary.rhs);
                break;
            }
            case 73: {
                this.doExpr(((Expr.New)expr).arrayLength);
                break;
            }
            case 74: {
                this.doExpr(((Expr.Delete)expr).target);
                break;
            }
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                break;
            }
            default: {
                if (expr.isLiteral()) break;
                System.out.println("### Unhandled Expr: " + this.cfg.method.name + ' ' + expr.id + ' ' + expr + '\n' + expr.loc);
            }
        }
    }

    private final void checkDefinitelyAssigned(Expr.Local local) {
        Expr.Local local2;
        if (!(this.curBlockSets.defIn.contains(local.def) || this.curBlockSets.defAt.contains(local.def) || (local2 = (Expr.Local)this.errs.get(local.def)) != null && local.loc.compareTo(local2.loc) >= 0)) {
            this.errs.put(local.def, local);
        }
    }

    private final void assignExpr(Expr.Binary binary) {
        switch (binary.lhs.id) {
            case 60: {
                Expr.Local local = (Expr.Local)binary.lhs;
                this.doExpr(binary.rhs);
                this.curBlockSets.defAt.add(local.def);
                break;
            }
            case 64: {
                this.doExpr(binary.lhs);
                this.doExpr(binary.rhs);
                break;
            }
            case 59: 
            case 63: {
                this.doExpr(binary.rhs);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled assignment: " + binary.lhs.id + ' ' + binary + '\n' + binary.loc);
            }
        }
    }

    private final void callExpr(Expr.Call call) {
        int n = 0;
        while (n < call.args.length) {
            this.doExpr(call.args[n]);
            ++n;
        }
        this.doExpr(call.target);
    }

    private final void indexExpr(Expr.Index index) {
        this.doExpr(index.index);
        this.doExpr(index.target);
    }

    private final void condExpr(Expr.Cond cond) {
        int n = 0;
        while (n < cond.operands.size()) {
            Expr expr = (Expr)cond.operands.get(n);
            this.doExpr(expr);
            if (cond.id == 28 && 1 != expr.id || cond.id == 27 && 2 != expr.id) break;
            ++n;
        }
    }

    private final void ternaryExpr(Expr.Ternary ternary) {
        this.doExpr(ternary.cond);
        if (1 == ternary.cond.id) {
            this.doExpr(ternary.trueExpr);
        } else if (2 == ternary.cond.id) {
            this.doExpr(ternary.falseExpr);
        } else {
            DefinedSets definedSets = new DefinedSets(this.curBlockSets);
            this.doExpr(ternary.trueExpr);
            DefinedSets definedSets2 = new DefinedSets(this.curBlockSets);
            this.intersect(this.curBlockSets.defAt, definedSets.defAt);
            this.doExpr(ternary.falseExpr);
            this.intersect(this.curBlockSets.defAt, definedSets2.defAt);
        }
    }

    private final void interpolateExpr(Expr.Interpolation interpolation) {
        int n = 0;
        while (n < interpolation.parts.size()) {
            Expr expr = (Expr)interpolation.parts.get(n);
            this.doExpr(expr);
            ++n;
        }
    }

    private final boolean intersect(HashSet hashSet, HashSet hashSet2) {
        if (hashSet.isEmpty()) {
            return false;
        }
        if (hashSet2 == null || hashSet2.isEmpty()) {
            hashSet.clear();
            return true;
        }
        boolean bl = false;
        Object[] objectArray = hashSet.toArray();
        int n = 0;
        while (n < objectArray.length) {
            if (!hashSet2.contains(objectArray[n])) {
                bl |= true;
                hashSet.remove(objectArray[n]);
            }
            ++n;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.map = new HashMap();
        this.errs = new HashMap();
    }

    public DefiniteAssignmentAnalysis(Compiler compiler, ControlFlowGraph controlFlowGraph) {
        super(compiler);
        this.this();
        this.cfg = controlFlowGraph;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class DefinedSets {
        public HashSet defIn;
        public HashSet defAt;
        public HashSet defOut;

        private final /* synthetic */ void this() {
            this.defIn = new HashSet();
            this.defAt = new HashSet();
            this.defOut = new HashSet();
        }

        public DefinedSets() {
            this.this();
        }

        public DefinedSets(DefinedSets definedSets) {
            this.this();
            this.defIn.addAll(definedSets.defIn);
            this.defAt.addAll(definedSets.defAt);
            this.defOut.addAll(definedSets.defOut);
        }
    }
}

