/*
 * Decompiled with CFR 0.152.
 */
package sedonac;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import sedona.Env;
import sedona.util.Version;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.test.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Main {
    static /* synthetic */ Class array$Ljava$lang$String;

    public static void usage() {
        Main.println("usage:");
        Main.println("  sedonac [options] <input file>");
        Main.println("inputs:");
        Main.println("  dir          directory containing kit.xml file");
        Main.println("  kit.xml      compile Sedona source files into kit file");
        Main.println("  scode.xml    compile Sedona kits into a scode image");
        Main.println("  *.sax        convert sax to sab");
        Main.println("  *.sab        convert sab to sax");
        Main.println("options:");
        Main.println("  -doc         generate HTML Sedona docs for kit");
        Main.println("  -outDir      output directory");
        Main.println("  -v           verbose logging");
        Main.println("  -ver         print version info and exit");
        Main.println("  -? -help     print this usage synopsis");
        Main.println("  -test        run test suite");
        Main.println("  -layout      dump field layout (when compiling image)");
        Main.println("  -kitVersion  force output kit to have specified version");
        Main.println("  -noOptimize  skip const folding and optimization steps");
        Main.println("  -noChecksum  exclude checksums from sax if input is sab file");
    }

    private static final void errUsage(String string) {
        if (string != null) {
            Main.println("ERROR: " + string + '\n');
        }
        Main.usage();
        System.exit(1);
    }

    public static void println(String string) {
        System.out.println(string);
    }

    public static int doMain(String[] stringArray) {
        if (!Env.checkJavaVersion()) {
            return 1;
        }
        if (stringArray.length == 0) {
            Main.usage();
            return 1;
        }
        if (stringArray[0].startsWith("sedona.") || stringArray[0].startsWith("sedonac.")) {
            try {
                Class<?> clazz = Class.forName(stringArray[0]);
                String[] stringArray2 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
                Class[] classArray = new Class[1];
                Class clazz2 = array$Ljava$lang$String;
                if (clazz2 == null) {
                    clazz2 = array$Ljava$lang$String = Main.class("[Ljava.lang.String;", true);
                }
                classArray[0] = clazz2;
                clazz.getMethod("main", classArray).invoke(null, new Object[]{stringArray2});
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace();
            }
            catch (Exception exception) {
                System.out.println("ERROR: Cannot run main: " + stringArray[0]);
                exception.printStackTrace();
            }
            return 0;
        }
        Compiler compiler = new Compiler();
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string2.equals("-?") || string2.equals("-help")) {
                Main.usage();
                return 1;
            }
            if (string2.equals("-doc")) {
                compiler.doc = true;
            } else if (string2.equals("-outDir")) {
                if (n + 1 >= stringArray.length) {
                    Main.errUsage("Missing outDir option");
                } else {
                    compiler.outDir = new File(stringArray[++n]);
                }
            } else {
                if (string2.equals("-ver")) {
                    Env.printVersion((String)"Sedona Compiler");
                    return 1;
                }
                if (string2.equals("-v")) {
                    compiler.log.severity = 1;
                } else if (string2.equals("-noOptimize")) {
                    compiler.optimize = false;
                } else if (string2.equals("-www")) {
                    compiler.www = true;
                } else if (string2.equals("-layout")) {
                    compiler.dumpLayout = true;
                } else {
                    if (string2.equals("-test")) {
                        String string3 = null;
                        if (n + 1 < stringArray.length) {
                            string3 = stringArray[n + 1];
                        }
                        return Test.run(string3);
                    }
                    if (string2.equals("-kitVersion")) {
                        if (n + 1 >= stringArray.length) {
                            Main.errUsage("Missing kitVersion option");
                        } else {
                            compiler.kitVersion = new Version(stringArray[++n]);
                        }
                    } else if (string2.equals("-noChecksum")) {
                        compiler.nochk = true;
                    } else if (string2.startsWith("-")) {
                        Main.errUsage("Unrecognized option " + string2);
                    } else if (string == null) {
                        string = string2;
                    } else {
                        Main.println("WARNING: Ignoring argument " + string2);
                    }
                }
            }
            ++n;
        }
        if (string == null) {
            Main.println("ERROR: No input specified");
            return 1;
        }
        try {
            compiler.compile(new File(string));
            n = compiler.warnings.size();
            if (n > 0) {
                System.out.println("*** Success with " + n + " warning(s) ***");
            } else {
                System.out.println("*** Success! ***");
            }
            return 0;
        }
        catch (CompilerException compilerException) {
            int n2 = compiler.warnings.size();
            int n3 = compiler.logErrors();
            if (n3 == 0) {
                compilerException.printStackTrace();
            } else {
                System.out.println("*** FAILED with " + n3 + " error(s) and " + n2 + " warning(s) ***");
            }
            return 1;
        }
        catch (Throwable throwable) {
            compiler.log.error("Internal compiler error", throwable);
            throwable.printStackTrace();
            return 1;
        }
    }

    public static void main(String[] stringArray) {
        try {
            int n = Main.doMain(stringArray);
            System.exit(n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

