/*
 * Decompiled with CFR 0.152.
 */
package sedonac;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import sedona.manifest.KitManifest;
import sedona.util.Version;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XParser;
import sedonac.CompilerException;
import sedonac.CompilerLog;
import sedonac.Location;
import sedonac.SourceFile;
import sedonac.ast.KitDef;
import sedonac.ir.IrFlat;
import sedonac.ir.IrKit;
import sedonac.ir.IrMethod;
import sedonac.jasm.JavaClass;
import sedonac.namespace.Namespace;
import sedonac.platform.PlatformDef;
import sedonac.scode.SCodeImage;
import sedonac.steps.Assemble;
import sedonac.steps.AssembleJava;
import sedonac.steps.AssignSlotIds;
import sedonac.steps.BuildManifest;
import sedonac.steps.CheckErrors;
import sedonac.steps.CheckHtmlLinks;
import sedonac.steps.CompileDir;
import sedonac.steps.ConstFolding;
import sedonac.steps.ConvertAppFile;
import sedonac.steps.FieldLayout;
import sedonac.steps.FilterTestClasses;
import sedonac.steps.FindTestCases;
import sedonac.steps.GenNativeTable;
import sedonac.steps.Generate;
import sedonac.steps.Inherit;
import sedonac.steps.InitImageCompile;
import sedonac.steps.InitKitCompile;
import sedonac.steps.InitStagePlatform;
import sedonac.steps.InlineConsts;
import sedonac.steps.InstanceInit;
import sedonac.steps.MountAstIntoNamespace;
import sedonac.steps.Normalize;
import sedonac.steps.NormalizeExpr;
import sedonac.steps.OptimizeIr;
import sedonac.steps.OrderAstTypes;
import sedonac.steps.OrderIrTypes;
import sedonac.steps.OrderStaticInits;
import sedonac.steps.Parse;
import sedonac.steps.ReadKits;
import sedonac.steps.ResolveDepends;
import sedonac.steps.ResolveExpr;
import sedonac.steps.ResolveFacets;
import sedonac.steps.ResolveIR;
import sedonac.steps.ResolveIncludes;
import sedonac.steps.ResolveNatives;
import sedonac.steps.ResolveTypes;
import sedonac.steps.StageNatives;
import sedonac.steps.StagePlatform;
import sedonac.steps.StaticAnalysis;
import sedonac.steps.TableOfContents;
import sedonac.steps.VTableLayout;
import sedonac.steps.WriteDoc;
import sedonac.steps.WriteImage;
import sedonac.steps.WriteKit;
import sedonac.translate.Translation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Compiler {
    public CompilerLog log;
    public boolean doc;
    public File input;
    public boolean dumpLayout;
    public Version kitVersion;
    public File outDir;
    public boolean optimize;
    public boolean www;
    public boolean nochk;
    public Namespace ns;
    public XElem xml;
    ArrayList errors;
    ArrayList warnings;
    public KitDef ast;
    public SourceFile[] sourceFiles;
    public boolean[] testOnly;
    public IrKit ir;
    public JavaClass[] java;
    public KitManifest manifest;
    public IrKit[] kits;
    public SCodeImage image;
    public IrFlat flat;
    public IrMethod[] testMethods;
    public int dataSize;
    public PlatformDef platform;
    public Translation translation;

    public void compile(File file) {
        Object object;
        if (!file.exists()) {
            throw this.err("Input file does not exist", new Location(this.input));
        }
        if (file.isDirectory()) {
            object = file;
            if (!(file = new File((File)object, "kit.xml")).exists()) {
                file = new File((File)object, "dir.xml");
            }
            if (!file.exists() || file.isDirectory()) {
                throw this.err("Invalid input directory", new Location((File)object));
            }
        }
        try {
            this.input = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            this.input = file;
        }
        if (file.getName().endsWith(".sab")) {
            this.appBinaryToXml();
            return;
        }
        try {
            this.xml = XParser.make((File)file).parse();
        }
        catch (XException xException) {
            throw this.err(xException);
        }
        catch (Exception exception) {
            throw this.err("Cannot parse XML input file", new Location(file), (Throwable)exception);
        }
        object = this.xml.name();
        if (((String)object).equals("sedonaKit")) {
            this.compileKit();
            return;
        }
        if (((String)object).equals("sedonaCode")) {
            this.compileImage();
            return;
        }
        if (((String)object).equals("sedonaDir")) {
            this.compileDir();
            return;
        }
        if (((String)object).equals("sedonaTranslate")) {
            this.translate();
            return;
        }
        if (((String)object).equals("sedonaPlatform")) {
            this.stagePlatform();
            return;
        }
        if (((String)object).equals("sedonaApp")) {
            this.appXmlToBinary();
            return;
        }
        if (((String)object).equals("toc")) {
            this.compileDocs();
            return;
        }
        throw this.err("Unknown XML input file type <" + (String)object + '>', new Location(this.xml));
    }

    public void compileKit() {
        new InitKitCompile(this).run();
        new ResolveDepends(this).run();
        new ResolveIncludes(this).run();
        new OrderIrTypes(this).run();
        new ResolveIR(this).run();
        new Parse(this).run();
        new MountAstIntoNamespace(this).run();
        new ResolveTypes(this).run();
        new OrderAstTypes(this).run();
        new Inherit(this).run();
        new InstanceInit(this).run();
        new Normalize(this).run();
        new ResolveExpr(this).run();
        new ConstFolding(this).run();
        new ResolveFacets(this).run();
        new CheckErrors(this).run();
        new NormalizeExpr(this).run();
        new ResolveNatives(this).run();
        new StaticAnalysis(this).run();
        new Assemble(this).run();
        new FieldLayout(this).run();
        new BuildManifest(this).run();
        new AssembleJava(this).run();
        new OptimizeIr(this).run();
        new WriteKit(this).run();
        new WriteDoc(this).run();
    }

    public void compileImage() {
        new InitImageCompile(this).run();
        new ReadKits(this).run();
        new FilterTestClasses(this).run();
        new OrderIrTypes(this).run();
        new ResolveIR(this).run();
        new Inherit(this).run();
        new AssignSlotIds(this).run();
        new OrderStaticInits(this).run();
        new FieldLayout(this).run();
        new VTableLayout(this).run();
        new InlineConsts(this).run();
        new FindTestCases(this).run();
        new Generate(this).run();
        new WriteImage(this).run();
    }

    public void compileDir() {
        new CompileDir(this).run();
    }

    public void stagePlatform() {
        new InitStagePlatform(this).run();
        new ReadKits(this).run();
        new StageNatives(this).run();
        new GenNativeTable(this).run();
        new StagePlatform(this).run();
    }

    public void translate() {
        throw new RuntimeException("translate not supported yet");
    }

    public void appXmlToBinary() {
        new ConvertAppFile(this).run();
    }

    public void appBinaryToXml() {
        new ConvertAppFile(this).run();
    }

    public void compileDocs() {
        new TableOfContents(this).run();
        new CheckHtmlLinks(this).run();
    }

    public CompilerException[] errors() {
        return this.errors.toArray(new CompilerException[this.errors.size()]);
    }

    public void quitIfErrors() {
        if (this.errors.size() > 0) {
            throw (CompilerException)this.errors.get(0);
        }
    }

    public int logErrors() {
        CompilerException[] compilerExceptionArray = this.errors();
        int n = 0;
        while (n < compilerExceptionArray.length) {
            this.log.error(compilerExceptionArray[n]);
            ++n;
        }
        return compilerExceptionArray.length;
    }

    public CompilerException err(String string) {
        return this.err(new CompilerException(string, null));
    }

    public CompilerException err(String string, Location location) {
        return this.err(new CompilerException(string, location));
    }

    public CompilerException err(String string, String string2) {
        return this.err(new CompilerException(string, new Location(string2)));
    }

    public CompilerException err(String string, Location location, Throwable throwable) {
        return this.err(new CompilerException(string, null, throwable));
    }

    public CompilerException err(String string, String string2, Throwable throwable) {
        return this.err(new CompilerException(string, new Location(string2), throwable));
    }

    public CompilerException err(CompilerException compilerException) {
        this.errors.add(compilerException);
        return compilerException;
    }

    public CompilerException err(XException xException) {
        return this.err(new CompilerException(xException));
    }

    public void warn(String string) {
        this.log.warn("[WARNING] " + string);
        this.warnings.add(string);
    }

    public void warn(String string, Location location) {
        if (location != null) {
            string = location + ": " + string;
        }
        this.warn(string);
    }

    public Compiler spawn() {
        Compiler compiler = new Compiler();
        compiler.log = this.log;
        compiler.doc = this.doc;
        compiler.dumpLayout = this.dumpLayout;
        compiler.errors = this.errors;
        compiler.warnings = this.warnings;
        compiler.outDir = this.outDir;
        compiler.kitVersion = this.kitVersion;
        compiler.optimize = this.optimize;
        compiler.www = this.www;
        return compiler;
    }

    private final /* synthetic */ void this() {
        this.optimize = true;
        this.www = false;
        this.nochk = false;
    }

    public Compiler() {
        this.this();
        this.log = new CompilerLog();
        this.errors = new ArrayList();
        this.warnings = new ArrayList();
        this.ns = new Namespace();
    }
}

