/*
 * Decompiled with CFR 0.152.
 */
package sedona.vm;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import sedona.Kit;
import sedona.Schema;
import sedona.Slot;
import sedona.Type;
import sedona.vm.Context;
import sedona.vm.ReflectUtil;
import sedona.vm.StrRef;
import sedona.vm.VmUtil;

public class Reflector
extends ReflectUtil {
    public final ClassLoader loader;
    public final Schema schema;
    public final Context context;
    public final Class kitCls;
    public final Class typeCls;
    public final Class slotCls;
    public final Class sysCls;
    public final Class logCls;
    public final Class bufCls;

    void initContext() throws Exception {
        Reflector.set(this.sysCls, "context", (Object)this.context);
    }

    void initKitConsts() throws Exception {
        Kit[] kitArray = this.schema.kits;
        Object[] objectArray = (Object[])Array.newInstance(this.kitCls, this.schema.kits.length);
        Reflector.set(this.sysCls, "kitsLen", (Object)new Integer(objectArray.length));
        Reflector.set(this.sysCls, "kits", (Object)objectArray);
        int n = 0;
        while (n < kitArray.length) {
            this.initKitConst(kitArray[n]);
            ++n;
        }
        n = 0;
        while (n < kitArray.length) {
            this.finishKitConst(kitArray[n]);
            ++n;
        }
        this.initLogs();
        this.finishCompTypes();
    }

    void initKitConst(Kit kit) throws Exception {
        Class clazz = this.toKitConstCls(kit);
        Object t = this.kitCls.newInstance();
        Reflector.set(clazz, "kit", t);
        ((Object[])Reflector.get((Class)this.sysCls, (String)"kits"))[kit.id] = t;
        Object[] objectArray = (Object[])Array.newInstance(this.typeCls, kit.types.length);
        Reflector.set(t, "id", (Object)new Byte((byte)kit.id));
        Reflector.set(t, "_name", (Object)kit.name);
        Reflector.set(t, "name", (Object)StrRef.make(kit.name));
        Reflector.set(t, "version", (Object)StrRef.make(kit.manifest.version.toString()));
        Reflector.set(t, "checksum", (Object)new Integer(kit.checksum));
        Reflector.set(t, "typesLen", (Object)new Byte((byte)kit.types.length));
        Reflector.set(t, "types", (Object)objectArray);
        int n = 0;
        while (n < kit.types.length) {
            objectArray[n] = this.typeCls.newInstance();
            Object t2 = objectArray[n];
            Type type = kit.types[n];
            Slot[] slotArray = type.slots;
            Object[] objectArray2 = (Object[])Array.newInstance(this.slotCls, slotArray.length);
            Reflector.set(clazz, "type" + type.name, t2);
            Reflector.set(t2, "id", (Object)new Byte((byte)type.id));
            Reflector.set(t2, "kit", t);
            Reflector.set(t2, "_name", (Object)type.name);
            Reflector.set(t2, "name", (Object)StrRef.make(type.name));
            Reflector.set(t2, "slotsLen", (Object)new Byte((byte)objectArray2.length));
            Reflector.set(t2, "slots", (Object)objectArray2);
            int n2 = 0;
            while (n2 < slotArray.length) {
                Slot slot = slotArray[n2];
                if (slot.parent == type) {
                    objectArray2[n2] = this.slotCls.newInstance();
                    Object t3 = objectArray2[n2];
                    Reflector.set(clazz, "slot" + slot.parent.name + '_' + slot.name, t3);
                    String string = "Acc_" + slot.parent.name + '_' + slot.name;
                    Object t4 = this.typeClass(kit.name, string).newInstance();
                    Reflector.set(t4, "slot", t3);
                    Reflector.set(t3, "id", (Object)new Byte((byte)slot.id));
                    Reflector.set(t3, "_name", (Object)slot.name);
                    Reflector.set(t3, "name", (Object)StrRef.make(slot.name));
                    Reflector.set(t3, "flags", (Object)new Byte((byte)slot.flags));
                    Reflector.set(t3, "type", this.rtype(slot.type));
                    Reflector.set(t3, "accessor", t4);
                }
                ++n2;
            }
            ++n;
        }
    }

    void finishKitConst(Kit kit) throws Exception {
        Class clazz = this.toKitConstCls(kit);
        int n = 0;
        while (n < kit.types.length) {
            Type type = kit.types[n];
            Object object = Reflector.get(clazz, "type" + type.name);
            Reflector.set(object, "base", this.rtype(type.base));
            Object[] objectArray = (Object[])Reflector.get(object, "slots");
            int n2 = 0;
            while (n2 < type.slots.length) {
                Slot slot = type.slots[n2];
                if (slot.parent != type) {
                    objectArray[n2] = ((Object[])Reflector.get(this.rtype(slot.parent), "slots"))[n2];
                }
                ++n2;
            }
            ++n;
        }
    }

    void initLogs() throws Exception {
        Object[] objectArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.schema.kits.length) {
            objectArray = this.schema.kits[n];
            Class clazz = this.toKitConstCls((Kit)objectArray);
            Field[] fieldArray = clazz.getFields();
            int n2 = 0;
            while (n2 < fieldArray.length) {
                Field field = fieldArray[n2];
                if (field.getName().startsWith("log_")) {
                    String string = Reflector.logFieldNameToQname((Kit)objectArray, field.getName());
                    Object object = field.get(null);
                    Reflector.set(object, "id", (Object)new Short((short)arrayList.size()));
                    Reflector.set(object, "qname", (Object)VmUtil.strConst(string));
                    arrayList.add(object);
                }
                ++n2;
            }
            ++n;
        }
        n = arrayList.size();
        objectArray = (Object[])Array.newInstance(this.logCls, n);
        arrayList.toArray(objectArray);
        Reflector.set(this.sysCls, "logs", (Object)objectArray);
        Reflector.set(this.sysCls, "logsLen", (Object)new Short((short)n));
        Reflector.set(this.sysCls, "logLevels", (Object)new byte[n]);
    }

    static String logFieldNameToQname(Kit kit, String string) {
        string = string.substring(4);
        int n = string.indexOf(95);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = kit.name + "::" + string2;
        if (string3.equals("log")) {
            return string4;
        }
        if (string3.endsWith("Log")) {
            string3 = string3.substring(0, string3.length() - 3);
        }
        return string4 + '.' + string3;
    }

    void finishCompTypes() throws Exception {
        Object object = Reflector.get(this.sysCls, "app");
        Reflector.set(object, "type", this.rtype("sys", "App"));
    }

    String[] kitTests(Kit kit) throws Exception {
        return (String[])Reflector.get(this.toKitConstCls(kit), "tests");
    }

    Class toKitConstCls(Kit kit) throws Exception {
        return this.loader.loadClass("sedona.vm." + kit.name + ".KitConst");
    }

    Kit classToKit(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(46, n - 1);
        return this.schema.kit(string.substring(n2 + 1, n));
    }

    Object rtype(Type type) throws Exception {
        if (type == null) {
            return null;
        }
        return this.rtype(type.kit.name, type.name);
    }

    Object rtype(String string) throws Exception {
        int n = string.indexOf(58);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 2);
        return this.rtype(string2, string3);
    }

    Object rtype(String string, String string2) throws Exception {
        Class<?> clazz = this.loader.loadClass("sedona.vm." + string + ".KitConst");
        Object object = Reflector.get(clazz, "type" + string2);
        if (object == null) {
            System.out.println("WARNING: static init ordering problem rtype(" + string + "::" + string2 + ')');
        }
        return object;
    }

    Class typeClass(String string) throws Exception {
        int n = string.indexOf(58);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 2);
        return this.typeClass(string2, string3);
    }

    Class typeClass(String string, String string2) throws Exception {
        return this.loader.loadClass("sedona.vm." + string + '.' + string2);
    }

    Reflector(ClassLoader classLoader, Schema schema, Context context) throws Exception {
        this.loader = classLoader;
        this.schema = schema;
        this.context = context;
        this.kitCls = classLoader.loadClass("sedona.vm.sys.Kit");
        this.typeCls = classLoader.loadClass("sedona.vm.sys.Type");
        this.slotCls = classLoader.loadClass("sedona.vm.sys.Slot");
        this.sysCls = classLoader.loadClass("sedona.vm.sys.Sys");
        this.logCls = classLoader.loadClass("sedona.vm.sys.Log");
        this.bufCls = classLoader.loadClass("sedona.vm.sys.Buf");
        this.initContext();
        this.initKitConsts();
    }
}

