/*
 * Decompiled with CFR 0.152.
 */
package sedona.sox;

import sedona.sox.Msg;
import sedona.sox.SoxClient;

class SoxReceiver
extends Thread {
    SoxClient client;

    public void kill() {
        this.interrupt();
    }

    public void run() {
        while (!this.client.isClosed()) {
            try {
                Msg msg = this.client.receive(1000L);
                if (msg == null) continue;
                this.dispatch(msg);
            }
            catch (Exception exception) {
                if (this.client.closing || this.client.isClosed()) continue;
                exception.printStackTrace();
            }
        }
    }

    void dispatch(Msg msg) throws Exception {
        int n = msg.command();
        switch (n) {
            case 101: {
                this.dispatchEvent(msg);
                return;
            }
            case 107: {
                this.client.fileTransfer.receiveChunk(msg);
                return;
            }
            case 122: {
                this.client.fileTransfer.receiveClose(msg);
                return;
            }
        }
        this.client.exchange.receive(msg);
    }

    void dispatchEvent(Msg msg) {
        int n = 63;
        try {
            n = msg.u1();
            msg.u1();
            this.client.applyToCache(msg);
        }
        catch (Exception exception) {
            System.out.println("ERROR: dispatching event cmd=" + (char)n + " 0x" + Integer.toHexString(n));
            exception.printStackTrace();
        }
    }

    SoxReceiver(SoxClient soxClient) {
        super("SoxReceiver");
        this.client = soxClient;
    }
}

