/*
 * Decompiled with CFR 0.152.
 */
package sedona.sox;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import sedona.Buf;
import sedona.Env;
import sedona.sox.Msg;
import sedona.sox.SoxClient;
import sedona.sox.SoxFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class FileTransfer {
    SoxClient client;
    SoxClient.TransferListener listener;
    String uri;
    SoxFile file;
    String method;
    int fileSize;
    int offset;
    int chunkSize;
    int numChunks;
    int transferedChunks;
    Properties reqHeaders;
    Properties resHeaders;
    long startTicks;
    long lastReceiveTicks;
    boolean closeReceived;
    Object lock;
    volatile boolean opened;
    final LinkedList chunkQueue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getFile() throws Exception {
        this.file.open("w");
        try {
            this.doGetFile();
            Properties properties = this.resHeaders;
            Object var2_2 = null;
            this.file.close();
            return properties;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.file.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doGetFile() throws Exception {
        this.method = "g";
        this.fileSize = FileTransfer.geti(this.reqHeaders, "fileSize", 0);
        this.start();
        this.lastReceiveTicks = Env.ticks();
        Object object = this.lock;
        synchronized (object) {
            this.receiveChunk(null);
            while (this.transferedChunks < this.numChunks) {
                if (this.client.session() == null) {
                    throw new IOException("file transfer session disconnected");
                }
                if (Env.ticks() - this.lastReceiveTicks > this.client.session().receiveTimeout()) {
                    throw new IOException("file transfer timed out");
                }
                try {
                    this.lock.wait(1000L);
                }
                catch (Exception exception) {}
            }
        }
        Msg msg = Msg.prepareRequest(122);
        Msg msg2 = this.client.request(msg);
        msg2.checkResponse(90);
        this.progress();
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void receiveChunk(Msg msg) {
        try {
            if (msg != null) {
                this.chunkQueue.add(msg);
            }
            if (!this.opened) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                while (true) {
                    if (this.chunkQueue.isEmpty()) {
                        this.lock.notifyAll();
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 6, 9] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                        this.progress();
                        return;
                    }
                    msg = (Msg)this.chunkQueue.remove(0);
                    int n = msg.u1();
                    int n2 = msg.u1();
                    int n3 = msg.u2();
                    int n4 = msg.u2();
                    this.lastReceiveTicks = Env.ticks();
                    if (n != 107) {
                        System.out.println("WARNING: This code is hosed up " + (char)n);
                        return;
                    }
                    if (n3 >= this.numChunks) {
                        System.out.println("WARNING: Received received out of range chunk " + n3 + " >= " + this.numChunks);
                        return;
                    }
                    ++this.transferedChunks;
                    this.file.write(n3 * this.chunkSize, msg, n4);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties putFile() throws Exception {
        this.file.open("r");
        try {
            this.doPutFile();
            Properties properties = this.resHeaders;
            Object var2_2 = null;
            this.file.close();
            return properties;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.file.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doPutFile() throws Exception {
        this.method = "p";
        this.fileSize = FileTransfer.geti(this.reqHeaders, "fileSize", this.file.size());
        this.start();
        int n = 0;
        while (n < this.numChunks || n == 0 && this.numChunks == 0) {
            this.sendChunk(n);
            ++this.transferedChunks;
            this.progress();
            ++n;
        }
        long l = Env.ticks();
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (this.closeReceived) {
                    // MONITOREXIT @DISABLED, blocks:[2, 6, 9] lbl21 : MonitorExitStatement: MONITOREXIT : var3_3
                    this.progress();
                    this.done();
                    return;
                }
                if (this.client.session() == null) {
                    throw new IOException("file transfer session disconnected");
                }
                if (Env.ticks() - l > this.client.session().receiveTimeout()) {
                    throw new IOException("file transfer timed out waiting for put close");
                }
                try {
                    this.lock.wait(1000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    private final void sendChunk(int n) throws Exception {
        int n2 = this.chunkSize;
        if (n == this.numChunks - 1) {
            if (this.fileSize % this.chunkSize > 0) {
                n2 = this.fileSize % this.chunkSize;
            } else if (this.fileSize == 0) {
                n2 = 0;
            }
        }
        Msg msg = Msg.prepareRequest(107, 0);
        msg.u2(n);
        msg.u2(n2);
        this.file.read(n * this.chunkSize, msg, n2);
        this.client.send(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void receiveClose(Msg msg) {
        Object object = this.lock;
        synchronized (object) {
            this.closeReceived = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            block8: {
                String string;
                Object object2;
                this.opened = false;
                this.chunkQueue.clear();
                Msg msg = Msg.prepareRequest(102);
                msg.str(this.method);
                msg.str(this.uri);
                msg.i4(this.fileSize);
                msg.u2(this.chunkSize);
                Iterator<Object> iterator = this.reqHeaders.keySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) break;
                    object2 = (String)iterator.next();
                    if (((String)object2).equals("fileSize")) continue;
                    string = (String)this.reqHeaders.get(object2);
                    msg.str((String)object2);
                    msg.str(string);
                }
                msg.u1(0);
                object2 = this.client.request(msg);
                ((Msg)object2).checkResponse(70);
                this.fileSize = ((Buf)object2).i4();
                this.chunkSize = ((Buf)object2).u2();
                this.resHeaders = new Properties();
                while (true) {
                    if ((string = ((Buf)object2).str()).equals("")) {
                        this.resHeaders.put("fileSize", "" + this.fileSize);
                        this.resHeaders.put("chunkSize", "" + this.chunkSize);
                        this.numChunks = this.fileSize / this.chunkSize;
                        if (this.fileSize % this.chunkSize > 0) {
                            break;
                        }
                        break block8;
                    }
                    String string2 = ((Buf)object2).str();
                    this.resHeaders.put(string, string2);
                }
                ++this.numChunks;
            }
            if (this.numChunks == 0 && this.method.equals("p")) {
                this.numChunks = 1;
            }
            this.transferedChunks = 0;
            this.opened = true;
            return;
        }
    }

    static int geti(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    static boolean getb(Properties properties, String string, boolean bl) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equals("true");
    }

    private final void progress() {
        if (this.listener == null) {
            return;
        }
        try {
            this.listener.progress(this.transferedChunks * this.chunkSize, this.fileSize);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private final void done() {
        long l = Env.ticks() - this.startTicks;
        if (!this.client.traceXferStats) {
            return;
        }
        System.out.println();
        System.out.println("Done [" + this.uri + ']');
        System.out.println("  duration:    " + l + "ms");
        System.out.println("  fileSize:    " + this.fileSize + " bytes");
        System.out.println("  chunkSize:   " + this.chunkSize + " bytes");
        System.out.println("  numChunks:   " + this.numChunks);
        System.out.println();
    }

    private final /* synthetic */ void this() {
        this.chunkQueue = new LinkedList();
    }

    FileTransfer(SoxClient soxClient, String string, SoxFile soxFile, Properties properties, SoxClient.TransferListener transferListener) {
        this.this();
        if (properties == null) {
            properties = new Properties();
        }
        int n = soxClient.session().idealMax() - 18;
        this.client = soxClient;
        this.listener = transferListener;
        this.uri = string;
        this.file = soxFile;
        this.reqHeaders = properties;
        this.offset = FileTransfer.geti(properties, "offset", 0);
        this.chunkSize = FileTransfer.geti(properties, "chunkSize", n);
        this.lock = new Object();
        this.startTicks = Env.ticks();
    }
}

