/*
 * Decompiled with CFR 0.152.
 */
package sedona.dasp;

import java.util.Hashtable;
import sedona.dasp.DaspMsg;
import sedona.dasp.DaspSession;
import sedona.dasp.DaspSocket;
import sedona.dasp.DaspTestHooks;
import sedona.dasp.ReceiveWindow;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class SendWindow {
    private static int verifies;
    private final DaspSession session;
    private final DaspSocket socket;
    private Packet head;
    private Packet tail;
    private String blocked;
    private boolean isAlive;
    private int size;
    private int seqNum;
    long sendRetry;
    int maxSend;
    int sendSize;
    int[] ackTimes;
    private int ackTimesPos;

    final synchronized int size() {
        return this.size;
    }

    final synchronized void kill() {
        this.isAlive = false;
        this.notifyAll();
    }

    private final synchronized int nextSeqNum() {
        return this.seqNum++ & (char)-1;
    }

    final int curSeqNum() {
        return this.seqNum & (char)-1;
    }

    final void send(byte[] byArray) throws InterruptedException {
        Packet packet = new Packet();
        packet.enqueuedTime = DaspSession.ticks();
        packet.seqNum = this.nextSeqNum();
        packet.payload = byArray;
        this.enqueue(packet);
        packet.sentTime = DaspSession.ticks();
        this.session.send(this.toMsg(packet));
    }

    private final DaspMsg toMsg(Packet packet) {
        DaspMsg daspMsg = new DaspMsg();
        daspMsg.msgType = 6;
        daspMsg.sessionId = this.session.remoteId;
        daspMsg.seqNum = packet.seqNum;
        daspMsg.payload = packet.payload;
        this.session.receiveWindow.setAckHeaders(daspMsg);
        return daspMsg;
    }

    private final synchronized void enqueue(Packet packet) throws InterruptedException {
        while (this.isAlive && this.full()) {
            try {
                this.blocked = Thread.currentThread().getName();
            }
            catch (Exception exception) {}
            this.wait();
        }
        this.blocked = null;
        if (packet.next != null) {
            throw new IllegalStateException();
        }
        if (this.tail == null) {
            this.head = this.tail = packet;
        } else {
            this.tail.next = packet;
            this.tail = packet;
        }
        ++this.size;
        this.notifyAll();
    }

    private final boolean full() {
        boolean bl = false;
        if (this.size >= this.sendSize) {
            bl = true;
        }
        return bl;
    }

    public final synchronized void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
        this.notifyAll();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SendWindow size=").append(this.size).append(" sendSize=").append(this.sendSize);
        Packet packet = this.head;
        while (packet != null) {
            stringBuffer.append(" ").append(packet.seqNum);
            if (packet.acked) {
                stringBuffer.append("a");
            }
            packet = packet.next;
        }
        if (this.blocked != null) {
            stringBuffer.append(" blocked=").append(this.blocked);
        }
        return stringBuffer.toString();
    }

    final synchronized void checkAckHeaders(DaspMsg daspMsg) {
        int n = daspMsg.ack;
        if (n < 0 || this.head == null) {
            return;
        }
        int n2 = n + 1 & (char)-1;
        int n3 = n2 + 10000 & (char)-1;
        Packet packet = this.head;
        long l = DaspSession.ticks();
        while (packet != null) {
            if (!packet.acked && this.isAcked(n2, n3, daspMsg, packet.seqNum)) {
                packet.acked = true;
                this.ackTimes[this.ackTimesPos] = (int)(l - packet.enqueuedTime);
                this.ackTimesPos = (this.ackTimesPos + 1) % this.ackTimes.length;
            }
            if (packet == this.head && packet.acked) {
                this.head = packet.next;
                --this.size;
            }
            packet = packet.next;
        }
        if (this.head == null) {
            this.tail = null;
        }
        this.notifyAll();
    }

    final boolean isAcked(int n, int n2, DaspMsg daspMsg, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n <= n2 ? n3 < n || n3 > n2 : n3 < n && n3 > n2) {
            return true;
        }
        byte[] byArray = daspMsg.ackMore;
        return byArray != null && (n7 = byArray.length - ((n6 = n3 - daspMsg.ack & (char)-1) >> 3) - 1) >= 0 && n7 < byArray.length && ((n5 = 1 << (n6 & 7)) & (n4 = byArray[n7] & 0xFF)) != 0;
    }

    final synchronized long sendRetries() {
        long l = DaspSession.ticks();
        long l2 = 0L;
        Packet packet = this.head;
        while (packet != null) {
            if (!packet.acked) {
                if (l - packet.sentTime >= this.sendRetry) {
                    packet.sentTime = l;
                    ++packet.sendAttempts;
                    ++this.session.numRetries;
                    ++this.session.iface.numRetries;
                    this.session.send(this.toMsg(packet));
                }
                l2 = Math.max(l2, l - packet.enqueuedTime);
            }
            packet = packet.next;
        }
        return l2;
    }

    public static final void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        DaspSocket daspSocket = DaspSocket.open(-1, null, 14);
        Hashtable<String, 1> hashtable = new Hashtable<String, 1>();
        hashtable.put("dasp.test", new DaspTestHooks(){

            public final boolean send(int n, int n2, byte[] byArray) {
                return false;
            }
        });
        DaspSession daspSession = new DaspSession(daspSocket.interfaces[0], 0, null, 0, true, hashtable);
        SendWindow sendWindow = new SendWindow(daspSession);
        sendWindow.test();
        long l2 = System.currentTimeMillis();
        System.out.println("  SendWindow Success: " + verifies + " verifies [" + (l2 - l) + "ms]");
        daspSocket.close();
    }

    private final void test() throws Exception {
        this.seqNum = 0;
        this.sendSize = 4;
        byte[] byArray = new byte[]{};
        this.verify("");
        this.send(byArray);
        this.verify("0");
        this.send(byArray);
        this.verify("0 1");
        this.send(byArray);
        this.verify("0 1 2");
        this.send(byArray);
        this.verify("0 1 2 3 full");
        this.ack(0);
        this.verify("1 2 3");
        this.send(byArray);
        this.verify("1 2 3 4 full");
        this.ack(1);
        this.verify("2 3 4");
        this.ack(2);
        this.verify("3 4");
        this.ack(2);
        this.verify("3 4");
        this.ack(0);
        this.verify("3 4");
        this.ack(65000);
        this.verify("3 4");
        this.ack(3);
        this.verify("4");
        this.ack(4);
        this.verify("");
        this.send(byArray);
        this.verify("5");
        this.send(byArray);
        this.verify("5 6");
        this.send(byArray);
        this.verify("5 6 7");
        this.send(byArray);
        this.verify("5 6 7 8 full");
        this.ack(7);
        this.verify("8");
        this.send(byArray);
        this.verify("8 9");
        this.ack(9);
        this.verify("");
        this.seqNum = 65534;
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.verify("65534 65535 0 1 full");
        this.ack(65534);
        this.verify("65535 0 1");
        this.ack(65533);
        this.verify("65535 0 1");
        this.ack(65534);
        this.verify("65535 0 1");
        this.ack(0);
        this.ack(1);
        this.verify("");
        this.seqNum = 65534;
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.verify("65534 65535 0 1 full");
        this.ack((char)-1);
        this.verify("0 1");
        this.ack(1);
        this.verify("");
        this.seqNum = 65534;
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.verify("65534 65535 0 1 full");
        this.ack(0);
        this.verify("1");
        this.ack(1);
        this.verify("");
        this.seqNum = 65534;
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.verify("65534 65535 0 1 full");
        this.ack(1);
        this.verify("");
        this.seqNum = (char)-1;
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.verify("65535 0 1 2 full");
        this.ack((char)-1);
        this.verify("0 1 2");
        this.ack(2);
        this.verify("");
        this.seqNum = (char)-1;
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.verify("65535 0 1 2 full");
        this.ack(1);
        this.verify("2");
        this.ack(2);
        this.verify("");
        this.seqNum = 10;
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.verify("10 11 12 13 full");
        this.ack(9, 11);
        this.verify("10 11a 12 13 full");
        this.ack(9, 11, 13);
        this.verify("10 11a 12 13a full");
        this.ack(10);
        this.verify("12 13a");
        this.ack(12);
        this.verify("");
        this.seqNum = 65534;
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.verify("65534 65535 0 1 full");
        this.ack(65533, (char)-1);
        this.verify("65534 65535a 0 1 full");
        this.ack(65534);
        this.verify("0 1");
        this.ack(1);
        this.verify("");
        this.seqNum = 65533;
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.verify("65533 65534 65535 0 full");
        this.ack(65532, 0);
        this.verify("65533 65534 65535 0a full");
        this.ack(65532, (char)-1, 0);
        this.verify("65533 65534 65535a 0a full");
        this.ack(65534);
        this.verify("");
        this.seqNum = (char)-1;
        this.send(byArray);
        this.send(byArray);
        this.send(byArray);
        this.verify("65535 0 1");
        this.ack(65533, 0);
        this.verify("65535 0a 1");
        this.send(byArray);
        this.verify("65535 0a 1 2 full");
        this.ack((char)-1);
        this.verify("1 2");
        this.ack(2);
        this.verify("");
        this.seqNum = 100;
        this.sendSize = 32;
        int n = 0;
        while (n < 18) {
            this.send(byArray);
            ++n;
        }
        this.verify("100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 116 117");
        this.ack(99, 107, 117);
        this.verify("100 101 102 103 104 105 106 107a 108 109 110 111 112 113 114 115 116 117a");
        this.ack(99, 101, 102, 111, 117);
        this.verify("100 101a 102a 103 104 105 106 107a 108 109 110 111a 112 113 114 115 116 117a");
        this.ack(104);
        this.verify("105 106 107a 108 109 110 111a 112 113 114 115 116 117a");
        this.ack(106);
        this.verify("108 109 110 111a 112 113 114 115 116 117a");
    }

    private final void ack(int n) {
        this.ack(new int[]{n});
    }

    private final void ack(int n, int n2) {
        this.ack(new int[]{n, n2});
    }

    private final void ack(int n, int n2, int n3) {
        this.ack(new int[]{n, n2, n3});
    }

    private final void ack(int n, int n2, int n3, int n4) {
        this.ack(new int[]{n, n2, n3, n4});
    }

    private final void ack(int n, int n2, int n3, int n4, int n5) {
        this.ack(new int[]{n, n2, n3, n4, n5});
    }

    private final void ack(int[] nArray) {
        DaspMsg daspMsg = new DaspMsg();
        daspMsg.ack = nArray[0];
        if (nArray.length > 1) {
            int n = 1;
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = nArray[n2] - nArray[0];
                n |= 1 << n3;
                ++n2;
            }
            daspMsg.ackMore = ReceiveWindow.toAckMore(n, 4);
        }
        this.checkAckHeaders(daspMsg);
    }

    private final void verify(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Packet packet = this.head;
        int n = 0;
        while (packet != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(packet.seqNum);
            if (packet.acked) {
                stringBuffer.append('a');
            }
            packet = packet.next;
            ++n;
        }
        if (this.full()) {
            stringBuffer.append(" full");
        }
        String string2 = stringBuffer.toString().trim();
        boolean bl = false;
        if (n == this.size) {
            bl = true;
        }
        this.verify(bl);
        if (string.equals("")) {
            boolean bl2 = false;
            if (this.head == null) {
                bl2 = true;
            }
            this.verify(bl2);
            boolean bl3 = false;
            if (this.tail == null) {
                bl3 = true;
            }
            this.verify(bl3);
        }
        if (string.equals(string2)) {
            ++verifies;
        } else {
            throw new RuntimeException(string + " != " + string2);
        }
    }

    private final void verify(boolean bl) {
        if (bl) {
            ++verifies;
        } else {
            throw new RuntimeException();
        }
    }

    private final /* synthetic */ void this() {
        this.isAlive = true;
        this.sendRetry = 1000L;
        this.maxSend = 3;
        this.sendSize = 8;
    }

    SendWindow(DaspSession daspSession) {
        this.this();
        this.session = daspSession;
        this.socket = daspSession.socket;
        this.seqNum = this.socket.rand.nextInt();
        this.ackTimes = new int[20];
        int n = 0;
        while (n < this.ackTimes.length) {
            this.ackTimes[n] = -1;
            ++n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Packet {
        int seqNum;
        byte[] payload;
        boolean acked;
        long enqueuedTime;
        long sentTime;
        int sendAttempts;
        Packet next;

        private final /* synthetic */ void this() {
            this.sendAttempts = 1;
        }

        Packet() {
            this.this();
        }
    }
}

