/*
 * Decompiled with CFR 0.152.
 */
package sedona.dasp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import sedona.dasp.DaspMsg;
import sedona.dasp.DaspSession;
import sedona.dasp.DaspSocket;

public abstract class DaspSocketInterface {
    Receiver receiver;
    HouseKeeping houseKeeping;
    DaspSocket daspSocket;
    DatagramPacket sendPacket = new DatagramPacket(new byte[1024], 1024);
    int numSent;
    int numReceived;
    int numRetries;

    public final DaspSocket daspSocket() {
        return this.daspSocket;
    }

    public abstract boolean routes(InetAddress var1, int var2);

    public abstract void send(DatagramPacket var1) throws IOException;

    protected abstract void receive(DatagramPacket var1) throws IOException;

    public abstract void close() throws IOException;

    void start(DaspSocket daspSocket) {
        this.daspSocket = daspSocket;
        this.receiver = new Receiver();
        this.receiver.start();
        this.houseKeeping = new HouseKeeping();
        this.houseKeeping.start();
    }

    void stop() {
        try {
            this.receiver.interrupt();
            this.receiver = null;
        }
        catch (Exception exception) {}
        try {
            this.houseKeeping.interrupt();
            this.houseKeeping = null;
        }
        catch (Exception exception) {}
        try {
            this.close();
        }
        catch (Exception exception) {}
    }

    public int numSent() {
        return this.numSent;
    }

    public int numReceived() {
        return this.numReceived;
    }

    public int numRetries() {
        return this.numRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void send(DaspSession daspSession, DaspMsg daspMsg) {
        DatagramPacket datagramPacket = this.sendPacket;
        synchronized (datagramPacket) {
            try {
                this.sendPacket.setAddress(daspSession.host);
                this.sendPacket.setPort(daspSession.port);
                this.sendPacket.setLength(daspMsg.encode(this.sendPacket.getData()));
                this.send(this.sendPacket);
            }
            catch (IOException iOException) {
                if (this.daspSocket.traceSend) {
                    System.out.println("ERROR: DaspSocket error on send - " + iOException.getMessage());
                    iOException.printStackTrace();
                }
                daspSession.shutdown(iOException.getMessage());
            }
            return;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Receiver
    extends Thread {
        public void run() {
            byte[] byArray = new byte[1024];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            while (DaspSocketInterface.this.daspSocket.isAlive) {
                try {
                    datagramPacket.setLength(byArray.length);
                    DaspSocketInterface.this.receive(datagramPacket);
                    DaspSocketInterface.this.daspSocket.dispatch(DaspSocketInterface.this, datagramPacket);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (Throwable throwable) {
                    if (!DaspSocketInterface.this.daspSocket.isAlive) continue;
                    throwable.printStackTrace();
                }
            }
        }

        Receiver() {
            super("DaspSocketInterface.Receiver");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class HouseKeeping
    extends Thread {
        public void run() {
            while (DaspSocketInterface.this.daspSocket.isAlive) {
                try {
                    long l = System.currentTimeMillis();
                    DaspSession[] daspSessionArray = DaspSocketInterface.this.daspSocket.sessions();
                    int n = 0;
                    while (n < daspSessionArray.length) {
                        block7: {
                            try {
                                DaspSession daspSession = daspSessionArray[n];
                                if (daspSession.iface == DaspSocketInterface.this) {
                                    daspSessionArray[n].houseKeeping();
                                }
                            }
                            catch (Throwable throwable) {
                                if (!DaspSocketInterface.this.daspSocket.isAlive) break block7;
                                throwable.printStackTrace();
                            }
                        }
                        ++n;
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = 100L - (l2 - l);
                    if (l3 <= (long)5) continue;
                    Thread.sleep(l3);
                }
                catch (Throwable throwable) {
                    if (!DaspSocketInterface.this.daspSocket.isAlive) continue;
                    throwable.printStackTrace();
                }
            }
        }

        HouseKeeping() {
            super("DaspSocket.HouseKeeping");
        }
    }
}

