/*
 * Decompiled with CFR 0.152.
 */
package sedona.dasp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Random;
import sedona.Buf;
import sedona.Env;
import sedona.dasp.DaspAcceptor;
import sedona.dasp.DaspConst;
import sedona.dasp.DaspException;
import sedona.dasp.DaspMessage;
import sedona.dasp.DaspMsg;
import sedona.dasp.DaspSession;
import sedona.dasp.DaspSocketInterface;
import sedona.dasp.DefaultDaspSocketInterface;
import sedona.dasp.ReceiveQueue;

public class DaspSocket
implements DaspConst {
    static final SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final int SOCKET_QUEUING = 13;
    public static final int SESSION_QUEUING = 14;
    public boolean traceSend;
    public boolean traceReceive;
    DaspAcceptor acceptor;
    volatile boolean isAlive;
    DaspSocketInterface[] interfaces;
    Object interfacesLock;
    HashMap sessions;
    Random rand;
    int qMode;
    ReceiveQueue queue;

    public static DaspSocket open(int n, DaspAcceptor daspAcceptor, int n2) throws Exception {
        if (n2 != 13 && n2 != 14) {
            throw new IllegalArgumentException("invalid queueingMode");
        }
        DaspSocket daspSocket = new DaspSocket(daspAcceptor, n2);
        daspSocket.addInterface(new DefaultDaspSocketInterface(n));
        return daspSocket;
    }

    public int queuingMode() {
        return this.qMode;
    }

    public DaspAcceptor acceptor() {
        return this.acceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DaspSocketInterface[] interfaces() {
        Object object = this.interfacesLock;
        synchronized (object) {
            return (DaspSocketInterface[])this.interfaces.clone();
        }
    }

    public DaspSocketInterface route(InetAddress inetAddress, int n) {
        DaspSocketInterface[] daspSocketInterfaceArray = this.interfaces();
        int n2 = daspSocketInterfaceArray.length - 1;
        while (n2 >= 0) {
            DaspSocketInterface daspSocketInterface = daspSocketInterfaceArray[n2];
            if (daspSocketInterface.routes(inetAddress, n)) {
                return daspSocketInterface;
            }
            --n2;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addInterface(DaspSocketInterface daspSocketInterface) {
        Object object = this.interfacesLock;
        synchronized (object) {
            DaspSocketInterface[] daspSocketInterfaceArray = new DaspSocketInterface[this.interfaces.length + 1];
            System.arraycopy(this.interfaces, 0, daspSocketInterfaceArray, 0, this.interfaces.length);
            daspSocketInterfaceArray[this.interfaces.length] = daspSocketInterface;
            this.interfaces = daspSocketInterfaceArray;
            daspSocketInterface.start(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeInterface(DaspSocketInterface daspSocketInterface) {
        Object object = this.interfacesLock;
        synchronized (object) {
            ArrayList<DaspSocketInterface> arrayList = new ArrayList<DaspSocketInterface>(this.interfaces.length);
            int n = 0;
            while (true) {
                if (n >= this.interfaces.length) {
                    this.interfaces = arrayList.toArray(new DaspSocketInterface[arrayList.size()]);
                    return;
                }
                if (this.interfaces[n] != daspSocketInterface) {
                    arrayList.add(this.interfaces[n]);
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DaspSession[] sessions() {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            return this.sessions.values().toArray(new DaspSession[this.sessions.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DaspSession session(int n) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            return (DaspSession)this.sessions.get(new Integer(n));
        }
    }

    public int port() {
        return ((DefaultDaspSocketInterface)this.interfaces[0]).sock.getLocalPort();
    }

    public boolean isClosed() {
        return this.isAlive ^ true;
    }

    public void close() {
        DaspSession[] daspSessionArray = this.sessions();
        int n = 0;
        while (n < daspSessionArray.length) {
            try {
                daspSessionArray[n].close(Integer.MAX_VALUE, "socket closed");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        this.isAlive = false;
        DaspSocketInterface[] daspSocketInterfaceArray = this.interfaces();
        int n2 = 0;
        while (n2 < daspSocketInterfaceArray.length) {
            try {
                daspSocketInterfaceArray[n2].stop();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
    }

    public DaspSession connect(InetAddress inetAddress, int n, String string, String string2) throws Exception {
        return this.connect(inetAddress, n, string, string2, null);
    }

    public DaspSession connect(InetAddress inetAddress, int n, String string, String string2, Hashtable hashtable) throws Exception {
        if (!this.isAlive) {
            throw new IllegalStateException("socket is closed");
        }
        if (hashtable == null) {
            hashtable = System.getProperties();
        }
        DaspSocketInterface daspSocketInterface = this.route(inetAddress, n);
        DaspSession daspSession = this.alloc(daspSocketInterface, inetAddress, n, true, hashtable);
        daspSession.user = string;
        daspSession.pass = string2;
        daspSession.connect();
        return daspSession;
    }

    public DaspMessage receive(long l) throws Exception {
        if (this.qMode != 13) {
            throw new IllegalStateException("not using socket queuing mode");
        }
        DaspMessage daspMessage = this.queue.dequeue(l);
        if (daspMessage == null) {
            return null;
        }
        if (daspMessage.msgType != 6) {
            throw new DaspException("Invalid message received: " + daspMessage.msgType);
        }
        return daspMessage;
    }

    void enqueue(DaspMessage daspMessage) {
        try {
            this.queue.enqueue(daspMessage);
        }
        catch (ReceiveQueue.FullException fullException) {
            System.out.println("ERROR: DaspSocket queue full!");
        }
    }

    void dispatch(DaspSocketInterface daspSocketInterface, DatagramPacket datagramPacket) throws Exception {
        InetAddress inetAddress = datagramPacket.getAddress();
        int n = datagramPacket.getPort();
        byte[] byArray = datagramPacket.getData();
        int n2 = datagramPacket.getLength();
        DaspMessage daspMessage = new DaspMessage(byArray, n2);
        DaspSession daspSession = this.session(daspMessage.sessionId);
        this.received(daspSocketInterface, daspSession, daspMessage);
        if (daspMessage.msgType == 1) {
            if (this.acceptor == null) {
                throw new IllegalStateException("Received hello with no acceptor");
            }
            DaspSession daspSession2 = this.alloc(daspSocketInterface, inetAddress, n, false, this.acceptor.options());
            daspSession2.challenge(daspMessage);
            return;
        }
        if (daspSession == null || !daspSession.host.equals(inetAddress) || daspSession.port != n) {
            return;
        }
        daspMessage.session = daspSession;
        daspSession.dispatch(daspMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DaspSession alloc(DaspSocketInterface daspSocketInterface, InetAddress inetAddress, int n, boolean bl, Hashtable hashtable) throws Exception {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            int n2;
            if (this.sessions.size() >= 10000) {
                throw new Exception("busy - too many sessions");
            }
            Integer n3 = null;
            while ((n2 = this.rand.nextInt() & (char)-1) == (char)-1 || this.sessions.get(n3 = new Integer(n2)) != null) {
            }
            DaspSession daspSession = this.createDaspSession(daspSocketInterface, n3, inetAddress, n, bl, hashtable);
            if (daspSession.id != n3) {
                throw new IllegalStateException("session not created with required id: " + n3);
            }
            this.sessions.put(n3, daspSession);
            return daspSession;
        }
    }

    protected DaspSession createDaspSession(DaspSocketInterface daspSocketInterface, int n, InetAddress inetAddress, int n2, boolean bl, Hashtable hashtable) {
        return new DaspSession(daspSocketInterface, n, inetAddress, n2, bl, hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void free(DaspSession daspSession) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(new Integer(daspSession.id));
            return;
        }
    }

    void send(DaspSession daspSession, DaspMsg daspMsg) {
        if (this.traceSend || daspSession.traceSend) {
            this.trace("->", daspMsg);
        }
        daspSession.iface.send(daspSession, daspMsg);
        ++daspSession.numSent;
        ++daspSession.iface.numSent;
    }

    void received(DaspSocketInterface daspSocketInterface, DaspSession daspSession, DaspMsg daspMsg) {
        if (this.traceReceive || daspSession != null && daspSession.traceReceive) {
            this.trace("<-", daspMsg);
        }
        ++daspSocketInterface.numReceived;
    }

    void trace(String string, DaspMsg daspMsg) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(format.format(new Date())).append(' ').append(string).append(" s=").append(Integer.toHexString(daspMsg.sessionId)).append(" seq=").append(Integer.toHexString(daspMsg.seqNum));
        if (daspMsg.msgType == 1 || daspMsg.msgType == 2 || daspMsg.msgType == 4) {
            stringBuffer.append(" remId=").append(Integer.toHexString(daspMsg.remoteId()));
        }
        if (daspMsg.ack >= 0) {
            stringBuffer.append(" ack=").append(Integer.toHexString(daspMsg.ack));
            if (daspMsg.ackMore != null) {
                stringBuffer.append(" ackMore=").append(new Buf(daspMsg.ackMore));
            }
        }
        if (daspMsg.msgType == 6) {
            String string2 = daspMsg.payload[1] == -1 ? "ff" : Integer.toHexString(daspMsg.payload[1]);
            stringBuffer.append(" c=").append((char)daspMsg.payload[0]).append(" r=").append(string2).append(' ').append(new Buf(daspMsg.payload));
        } else if (daspMsg.msgType == 7) {
            stringBuffer.append(" err=").append(Integer.toHexString(daspMsg.errorCode)).append(" msgType=").append(daspMsg.msgType).append(' ').append(new Buf(daspMsg.payload));
        } else {
            stringBuffer.append(" msgType=").append(daspMsg.msgType);
        }
        System.out.println(stringBuffer.toString());
    }

    protected DaspSocket(DaspAcceptor daspAcceptor, int n) {
        Hashtable hashtable = Env.getProperties();
        if (daspAcceptor != null) {
            hashtable = daspAcceptor.options();
        }
        this.acceptor = daspAcceptor;
        this.isAlive = true;
        this.sessions = new HashMap(300);
        this.rand = new Random();
        this.interfacesLock = new Object();
        this.interfaces = new DaspSocketInterface[0];
        this.qMode = n;
        this.queue = new ReceiveQueue(DaspSession.option(hashtable, "dasp.socketQueueMax", 10000));
        this.traceSend = DaspSession.option(hashtable, "dasp.traceSend", false);
        this.traceReceive = DaspSession.option(hashtable, "dasp.traceReceive", false);
    }
}

