/*
 * Decompiled with CFR 0.152.
 */
package sedona.dasp;

import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.Hashtable;
import sedona.Env;
import sedona.dasp.DaspConst;
import sedona.dasp.DaspException;
import sedona.dasp.DaspMessage;
import sedona.dasp.DaspMsg;
import sedona.dasp.DaspSocket;
import sedona.dasp.DaspSocketInterface;
import sedona.dasp.DaspTestHooks;
import sedona.dasp.ReceiveQueue;
import sedona.dasp.ReceiveWindow;
import sedona.dasp.SendWindow;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DaspSession
implements DaspConst {
    static final boolean CLIENT = true;
    static final boolean SERVER = false;
    public final int id;
    public final boolean isClient;
    public final boolean isServer;
    public final DaspSocket socket;
    public final InetAddress host;
    public final int port;
    public final DaspTestHooks test;
    public final DaspSocketInterface iface;
    public Object userData;
    public Listener listener;
    public boolean traceSend;
    public boolean traceReceive;
    int remoteId;
    volatile boolean isClosed;
    int numSent;
    int numReceived;
    int numRetries;
    String closeCause;
    String user;
    String pass;
    byte[] nonce;
    ReceiveQueue receiveQueue;
    ReceiveWindow receiveWindow;
    SendWindow sendWindow;
    long connectTimeout;
    int remoteReceiveMax;
    int idealMax;
    int absMax;
    long receiveTimeout;
    long connectTime;
    long lastSend;
    long lastReceive;

    static boolean option(Hashtable hashtable, String string, boolean bl) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return string2.equals("true");
        }
        return Env.getProperty(string, bl);
    }

    static int option(Hashtable hashtable, String string, int n) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return Env.getProperty(string, n);
    }

    static long option(Hashtable hashtable, String string, long l) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return Long.parseLong(string2);
        }
        return Env.getProperty(string, l);
    }

    public int remoteId() {
        return this.remoteId;
    }

    public int idealMax() {
        return this.idealMax;
    }

    public int absMax() {
        return this.absMax;
    }

    public int localReceiveMax() {
        return 31;
    }

    public int remoteReceiveMax() {
        return this.remoteReceiveMax;
    }

    public long receiveTimeout() {
        return this.receiveTimeout;
    }

    public String toString() {
        return (this.isClient ? "Client [" : "Server [") + this.id + " -> " + this.remoteId + ']';
    }

    public void send(byte[] byArray) throws Exception {
        this.send(byArray, 0, byArray.length);
    }

    public void send(byte[] byArray, int n, int n2) throws Exception {
        if (this.isClosed) {
            throw new DaspException("DaspSession is closed: " + this.closeCause);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.sendWindow.send(byArray2);
    }

    public DaspMessage receive(long l) throws Exception {
        if (this.socket.qMode != 14) {
            throw new IllegalStateException("not using session queuing mode");
        }
        DaspMessage daspMessage = this.receiveQueue.dequeue(l);
        if (this.isClosed) {
            throw new DaspException("DaspSession is closed: " + this.closeCause);
        }
        if (daspMessage == null) {
            return null;
        }
        if (daspMessage.msgType != 6) {
            throw new DaspException("Invalid message received: " + daspMessage.msgType);
        }
        return daspMessage;
    }

    protected final DaspMessage receiveAny(long l) throws Exception {
        if (this.socket.qMode != 14) {
            throw new IllegalStateException("not using session queueing mode");
        }
        return this.receiveQueue.dequeue(l);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void close() {
        this.close(-1, "close() api");
    }

    public String closeCause() {
        return this.closeCause;
    }

    void close(int n, String string) {
        if (this.isClosed) {
            return;
        }
        DaspMsg daspMsg = new DaspMsg();
        daspMsg.msgType = 7;
        daspMsg.sessionId = this.remoteId;
        daspMsg.seqNum = (char)-1;
        if (n != Integer.MAX_VALUE) {
            daspMsg.errorCode = n;
            if (n == 225) {
                daspMsg.version = 256;
            }
        }
        this.send(daspMsg);
        if (n == -1) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            this.send(daspMsg);
        }
        this.shutdown(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void shutdown(String string) {
        DaspSession daspSession = this;
        synchronized (daspSession) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.closeCause = string;
            try {
                if (this.listener != null) {
                    this.listener.daspSessionClosed(this);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.socket.free(this);
            this.sendWindow.kill();
            this.receiveQueue.kill();
            return;
        }
    }

    protected void connect() throws Exception {
        DaspMsg daspMsg = this.hello();
        DaspMsg daspMsg2 = null;
        switch (daspMsg.msgType) {
            case 7: {
                throw new DaspException("Connection denied", daspMsg.errorCode);
            }
            case 2: {
                this.remoteId = daspMsg.remoteId();
                daspMsg2 = this.authenticate(daspMsg);
                break;
            }
            case 4: {
                this.remoteId = daspMsg.remoteId();
                daspMsg2 = daspMsg;
                break;
            }
            default: {
                throw new DaspException("Unexpected response to hello " + daspMsg.msgType);
            }
        }
        switch (daspMsg2.msgType) {
            case 7: {
                throw new DaspException("Connection denied ", daspMsg2.errorCode);
            }
            case 4: {
                this.tune(daspMsg2);
                break;
            }
            default: {
                throw new DaspException("Expected welcome, not " + daspMsg2.msgType);
            }
        }
    }

    DaspMsg hello() throws Exception {
        DaspMsg daspMsg = new DaspMsg();
        daspMsg.msgType = 1;
        daspMsg.sessionId = (char)-1;
        daspMsg.seqNum = this.sendWindow.curSeqNum();
        daspMsg.remoteId = this.id;
        daspMsg.version = 256;
        daspMsg.idealMax = this.idealMax;
        daspMsg.absMax = this.absMax;
        daspMsg.receiveMax = this.localReceiveMax();
        daspMsg.receiveTimeout = this.receiveTimeout;
        long l = this.connectTimeout / (long)3;
        if (l < 1000L) {
            l = 1000L;
        }
        int n = 0;
        while (n < 3) {
            this.send(daspMsg);
            DaspMessage daspMessage = this.receiveQueue.dequeue(l);
            if (daspMessage != null) {
                return daspMessage;
            }
            ++n;
        }
        throw new DaspException("No response from hello");
    }

    DaspMsg authenticate(DaspMsg daspMsg) throws Exception {
        int n = -1;
        String string = daspMsg.digestAlgorithm();
        if (string != "SHA-1") {
            this.close(227, "digest not supported");
            throw new DaspException("Unsupported algorithm", 227);
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        byte[] byArray = messageDigest.digest((this.user + ':' + this.pass).getBytes("UTF-8"));
        messageDigest.reset();
        messageDigest.update(byArray);
        messageDigest.update(daspMsg.nonce());
        byte[] byArray2 = messageDigest.digest();
        DaspMsg daspMsg2 = new DaspMsg();
        daspMsg2.msgType = 3;
        daspMsg2.sessionId = this.remoteId;
        daspMsg2.seqNum = this.sendWindow.curSeqNum();
        daspMsg2.username = this.user;
        daspMsg2.digest = byArray2;
        long l = this.connectTimeout / (long)3;
        if (l < 1000L) {
            l = 1000L;
        }
        int n2 = 0;
        while (n2 < 3) {
            this.send(daspMsg2);
            DaspMessage daspMessage = this.receiveQueue.dequeue(l);
            if (daspMessage != null && daspMessage.msgType() != 2) {
                return daspMessage;
            }
            ++n2;
        }
        throw new DaspException("No response from authenticate");
    }

    void challenge(DaspMsg daspMsg) {
        this.remoteId = daspMsg.remoteId();
        if (daspMsg.version() != 256) {
            this.close(225, "incompatible version");
            return;
        }
        this.tune(daspMsg);
        this.nonce = new byte[10];
        int n = 0;
        while (n < this.nonce.length) {
            this.nonce[n] = (byte)this.socket.rand.nextInt();
            ++n;
        }
        DaspMsg daspMsg2 = new DaspMsg();
        daspMsg2.msgType = 2;
        daspMsg2.sessionId = this.remoteId;
        daspMsg2.seqNum = this.sendWindow.curSeqNum();
        daspMsg2.remoteId = this.id;
        daspMsg2.nonce = this.nonce;
        this.send(daspMsg2);
    }

    void welcome(DaspMsg daspMsg) {
        Object object;
        boolean bl = false;
        try {
            object = this.socket.acceptor.credentials(daspMsg.username());
            if (object != null) {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                messageDigest.update((byte[])object);
                messageDigest.update(this.nonce);
                byte[] byArray = messageDigest.digest();
                byte[] byArray2 = daspMsg.digest();
                bl = DaspSession.equals(byArray2, byArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!bl) {
            this.close(228, "not authenticated");
            return;
        }
        object = new DaspMsg();
        object.msgType = 4;
        object.sessionId = this.remoteId;
        object.seqNum = this.sendWindow.curSeqNum();
        object.remoteId = this.id;
        object.idealMax = this.idealMax;
        object.absMax = this.absMax;
        object.receiveMax = this.localReceiveMax();
        object.receiveTimeout = this.receiveTimeout;
        this.send((DaspMsg)object);
    }

    static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    void tune(DaspMsg daspMsg) {
        this.idealMax = Math.min(daspMsg.idealMax(), this.idealMax);
        this.absMax = Math.min(daspMsg.absMax(), this.absMax);
        this.remoteReceiveMax = daspMsg.receiveMax();
        this.receiveTimeout = Math.max(daspMsg.receiveTimeout(), this.receiveTimeout);
        this.sendWindow.sendSize = this.remoteReceiveMax;
        this.receiveWindow.init(daspMsg.seqNum);
    }

    void dispatch(DaspMessage daspMessage) {
        if (this.test != null && !this.test.receive(daspMessage.msgType, daspMessage.seqNum, daspMessage.payload)) {
            return;
        }
        ++this.numReceived;
        this.lastReceive = DaspSession.ticks();
        if (daspMessage.msgType == 3) {
            this.welcome(daspMessage);
            return;
        }
        this.sendWindow.checkAckHeaders(daspMessage);
        if (daspMessage.msgType == 6 && !this.receiveWindow.receive(daspMessage.seqNum)) {
            return;
        }
        switch (daspMessage.msgType) {
            case 2: 
            case 4: {
                this.enqueue(daspMessage);
                return;
            }
            case 7: {
                this.enqueue(daspMessage);
                this.shutdown("remote endpoint sent close (" + daspMessage.errorCode + ')');
                return;
            }
            case 6: {
                if (this.socket.qMode == 13) {
                    this.socket.enqueue(daspMessage);
                } else {
                    this.enqueue(daspMessage);
                }
                return;
            }
            case 5: {
                return;
            }
        }
        System.out.println("DaspSession unexpected msgType=" + daspMessage.msgType);
    }

    void enqueue(DaspMessage daspMessage) {
        try {
            this.receiveQueue.enqueue(daspMessage);
        }
        catch (ReceiveQueue.FullException fullException) {
            System.out.println("ERROR: DaspSession queue full!");
            this.close(229, "receive queue full");
        }
    }

    void houseKeeping() {
        if (DaspSession.ticks() - this.lastReceive > this.receiveTimeout) {
            this.close(229, "receive timeout");
            return;
        }
        long l = this.sendWindow.sendRetries();
        if (l > this.receiveTimeout) {
            this.close(229, "unacked send timeout");
            return;
        }
        if (this.receiveWindow.unacked() || DaspSession.ticks() - this.lastSend > this.receiveTimeout / (long)3) {
            this.keepAlive();
        }
    }

    void keepAlive() {
        DaspMsg daspMsg = new DaspMsg();
        daspMsg.msgType = 5;
        daspMsg.sessionId = this.remoteId;
        daspMsg.seqNum = (char)-1;
        this.receiveWindow.setAckHeaders(daspMsg);
        this.send(daspMsg);
    }

    protected void send(DaspMsg daspMsg) {
        this.lastSend = DaspSession.ticks();
        if (this.test != null && !this.test.send(daspMsg.msgType, daspMsg.seqNum, daspMsg.payload)) {
            return;
        }
        this.socket.send(this, daspMsg);
    }

    static long ticks() {
        return Env.ticks();
    }

    public long uptime() {
        return DaspSession.ticks() - this.connectTime;
    }

    public long lastSend() {
        return this.lastSend;
    }

    public long lastReceive() {
        return this.lastReceive;
    }

    public int numSent() {
        return this.numSent;
    }

    public int numReceived() {
        return this.numReceived;
    }

    public int numRetries() {
        return this.numRetries;
    }

    public int sendWindowSize() {
        return this.sendWindow.sendSize;
    }

    public long sendWindowRetry() {
        return this.sendWindow.sendRetry;
    }

    public int[] ackTimes() {
        return (int[])this.sendWindow.ackTimes.clone();
    }

    private final /* synthetic */ void this() {
        this.closeCause = "???";
    }

    protected DaspSession(DaspSocketInterface daspSocketInterface, int n, InetAddress inetAddress, int n2, boolean bl, Hashtable hashtable) {
        this.this();
        this.socket = daspSocketInterface.daspSocket;
        this.iface = daspSocketInterface;
        this.id = n;
        this.host = inetAddress;
        this.port = n2;
        this.isClient = bl;
        this.isServer = bl ^ true;
        this.receiveQueue = new ReceiveQueue(DaspSession.option(hashtable, "dasp.sessionQueueMax", 2000));
        this.receiveWindow = new ReceiveWindow(this);
        this.sendWindow = new SendWindow(this);
        this.idealMax = DaspSession.option(hashtable, "dasp.idealMax", 512);
        this.absMax = DaspSession.option(hashtable, "dasp.absMax", 512);
        this.receiveTimeout = DaspSession.option(hashtable, "dasp.receiveTimeout", 30000L);
        this.connectTimeout = DaspSession.option(hashtable, "dasp.connectTimeout", 10000L);
        this.sendWindow.sendRetry = DaspSession.option(hashtable, "dasp.sendRetry", 1000L);
        this.sendWindow.maxSend = DaspSession.option(hashtable, "dasp.maxSend", 3);
        this.lastReceive = DaspSession.ticks();
        this.connectTime = DaspSession.ticks();
        this.test = (DaspTestHooks)hashtable.get("dasp.test");
        if (this.test != null) {
            this.test.session = this;
        }
    }

    public static interface Listener {
        public void daspSessionClosed(DaspSession var1);
    }
}

