/*
 * Decompiled with CFR 0.152.
 */
package sedona.dasp;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import sedona.dasp.DaspConst;
import sedona.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DaspMsg
implements DaspConst {
    protected static final byte[] noBytes = new byte[0];
    protected int sessionId;
    protected int msgType;
    protected int seqNum;
    protected int version;
    protected int remoteId;
    protected String digestAlgorithm;
    protected byte[] nonce;
    protected String username;
    protected byte[] digest;
    protected int idealMax;
    protected int absMax;
    protected int ack;
    protected byte[] ackMore;
    protected int receiveMax;
    protected long receiveTimeout;
    protected int errorCode;
    protected byte[] payload;

    public static DaspMsg decode(DatagramPacket datagramPacket) throws UnsupportedEncodingException {
        return DaspMsg.decode(datagramPacket.getData(), datagramPacket.getLength());
    }

    public static DaspMsg decode(byte[] byArray, int n) throws UnsupportedEncodingException {
        return new DaspMsg(byArray, n);
    }

    protected void doDecode(byte[] byArray, int n) throws UnsupportedEncodingException {
        this.sessionId = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        this.seqNum = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        this.msgType = (byArray[4] & 0xFF) >> 4;
        int n2 = byArray[4] & 0xF;
        int n3 = 5;
        int n4 = 0;
        while (n4 < n2) {
            byte by = byArray[n3++];
            int n5 = 0;
            String string = null;
            byte[] byArray2 = null;
            switch (by & 3) {
                case 0: {
                    break;
                }
                case 1: {
                    n5 = (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
                    break;
                }
                case 2: {
                    int n6 = n3;
                    while (byArray[n3++] != 0) {
                    }
                    string = new String(byArray, n6, n3 - n6 - 1, "UTF-8");
                    break;
                }
                case 3: {
                    int n7 = byArray[n3++] & 0xFF;
                    byArray2 = n7 == 0 ? noBytes : new byte[n7];
                    System.arraycopy(byArray, n3, byArray2, 0, n7);
                    n3 += n7;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown header type: " + (by & 3));
                }
            }
            switch (by) {
                case 5: {
                    this.version = n5;
                    break;
                }
                case 9: {
                    this.remoteId = n5;
                    break;
                }
                case 14: {
                    this.digestAlgorithm = string;
                    break;
                }
                case 19: {
                    this.nonce = byArray2;
                    break;
                }
                case 22: {
                    this.username = string;
                    break;
                }
                case 27: {
                    this.digest = byArray2;
                    break;
                }
                case 29: {
                    this.idealMax = n5;
                    break;
                }
                case 33: {
                    this.absMax = n5;
                    break;
                }
                case 37: {
                    this.ack = n5;
                    break;
                }
                case 43: {
                    this.ackMore = byArray2;
                    break;
                }
                case 45: {
                    this.receiveMax = n5;
                    break;
                }
                case 49: {
                    this.receiveTimeout = (long)n5 * 1000L;
                    break;
                }
                case 53: {
                    this.errorCode = n5;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown field id: " + by);
                }
            }
            ++n4;
        }
        n4 = n - n3;
        this.payload = n4 == 0 ? noBytes : new byte[n4];
        System.arraycopy(byArray, n3, this.payload, 0, n4);
    }

    public int encode(byte[] byArray) {
        int n = 0;
        n = this.u2(n, byArray, this.sessionId);
        n = this.u2(n, byArray, this.seqNum);
        ++n;
        boolean bl = false;
        if (this.idealMax > -1 && this.idealMax != 512) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (this.absMax > -1 && this.absMax != 512) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        boolean bl5 = false;
        if (this.receiveMax > -1 && this.receiveMax != 31) {
            bl5 = true;
        }
        boolean bl6 = bl5;
        boolean bl7 = false;
        if (this.receiveTimeout > (long)-1 && this.receiveTimeout != 30000L) {
            bl7 = true;
        }
        boolean bl8 = bl7;
        int n2 = 0;
        if (this.version > -1) {
            ++n2;
            byArray[n++] = 5;
            n = this.u2(n, byArray, this.version);
        }
        if (this.remoteId > -1) {
            ++n2;
            byArray[n++] = 9;
            n = this.u2(n, byArray, this.remoteId);
        }
        if (this.digestAlgorithm != null) {
            ++n2;
            byArray[n++] = 14;
            n = this.str(n, byArray, this.digestAlgorithm);
        }
        if (this.nonce != null) {
            ++n2;
            byArray[n++] = 19;
            n = this.bytes(n, byArray, this.nonce);
        }
        if (this.username != null) {
            ++n2;
            byArray[n++] = 22;
            n = this.str(n, byArray, this.username);
        }
        if (this.digest != null) {
            ++n2;
            byArray[n++] = 27;
            n = this.bytes(n, byArray, this.digest);
        }
        if (bl2) {
            ++n2;
            byArray[n++] = 29;
            n = this.u2(n, byArray, this.idealMax);
        }
        if (bl4) {
            ++n2;
            byArray[n++] = 33;
            n = this.u2(n, byArray, this.absMax);
        }
        if (this.ack > -1) {
            ++n2;
            byArray[n++] = 37;
            n = this.u2(n, byArray, this.ack);
        }
        if (this.ackMore != null) {
            ++n2;
            byArray[n++] = 43;
            n = this.bytes(n, byArray, this.ackMore);
        }
        if (bl6) {
            ++n2;
            byArray[n++] = 45;
            n = this.u2(n, byArray, this.receiveMax);
        }
        if (bl8) {
            ++n2;
            byArray[n++] = 49;
            n = this.u2(n, byArray, (int)(this.receiveTimeout / 1000L));
        }
        if (this.errorCode > -1) {
            ++n2;
            byArray[n++] = 53;
            n = this.u2(n, byArray, this.errorCode);
        }
        byArray[4] = (byte)(this.msgType << 4 | n2);
        if (this.payload != null) {
            System.arraycopy(this.payload, 0, byArray, n, this.payload.length);
            n += this.payload.length;
        }
        return n;
    }

    private final int u2(int n, byte[] byArray, int n2) {
        byArray[n++] = (byte)(n2 >>> 8);
        byArray[n++] = (byte)n2;
        return n;
    }

    private final int bytes(int n, byte[] byArray, byte[] byArray2) {
        byArray[n++] = (byte)byArray2.length;
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return n + byArray2.length;
    }

    private final int str(int n, byte[] byArray, String string) {
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c > '\u007f') {
                throw new RuntimeException("String must be ASCII " + string);
            }
            byArray[n++] = (byte)c;
            ++n2;
        }
        byArray[n++] = 0;
        return n;
    }

    public final int sessionId() {
        return this.sessionId;
    }

    public final void setSessionId(int n) {
        this.sessionId = n;
    }

    public final int seqNum() {
        return this.seqNum;
    }

    public final void setSeqNum(int n) {
        this.seqNum = n;
    }

    public final int msgType() {
        return this.msgType;
    }

    public final void setMsgType(int n) {
        this.msgType = n;
    }

    public final byte[] payload() {
        return this.payload;
    }

    public final void setPayload(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            this.payload = noBytes;
        } else {
            this.payload = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.payload, 0, byArray.length);
        }
    }

    public final int version() {
        return Math.max(-1, this.version);
    }

    public final void setVersion(int n) {
        this.version = Math.max(-1, n);
    }

    public final int remoteId() {
        return Math.max(-1, this.remoteId);
    }

    public final void setRemoteId(int n) {
        this.remoteId = Math.max(-1, n);
    }

    public final String digestAlgorithm() {
        if (this.digestAlgorithm == null) {
            return "SHA-1";
        }
        return this.digestAlgorithm;
    }

    public final void setDigestAlgorithm(String string) {
        this.digestAlgorithm = "SHA-1".equals(string) ? null : string;
    }

    public final byte[] nonce() {
        return this.nonce;
    }

    public final void setNonce(byte[] byArray) {
        if (byArray == null) {
            this.nonce = null;
        } else {
            this.nonce = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.nonce, 0, byArray.length);
        }
    }

    public final String username() {
        return this.username;
    }

    public final void setUsername(String string) {
        this.username = string;
    }

    public final byte[] digest() {
        return this.digest;
    }

    public final void setDigest(byte[] byArray) {
        if (byArray == null) {
            this.digest = null;
        } else {
            this.digest = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.digest, 0, byArray.length);
        }
    }

    public final int idealMax() {
        return this.idealMax < 0 ? 512 : this.idealMax;
    }

    public final void setIdealMax(int n) {
        this.idealMax = Math.max(-1, n);
    }

    public final int absMax() {
        return this.absMax < 0 ? 512 : this.absMax;
    }

    public final void setAbsMax(int n) {
        this.absMax = Math.max(-1, n);
    }

    public final int receiveMax() {
        return this.receiveMax < 0 ? 31 : this.receiveMax;
    }

    public final void setReceiveMax(int n) {
        this.receiveMax = Math.max(-1, n);
    }

    public final long receiveTimeout() {
        return this.receiveTimeout < 0L ? 30000L : this.receiveTimeout;
    }

    public final void setReceiveTimeout(long l) {
        this.receiveTimeout = Math.max((long)-1, l);
    }

    public final int ack() {
        return Math.max(-1, this.ack);
    }

    public final void setAck(int n) {
        this.ack = Math.max(-1, n);
    }

    public final byte[] ackMore() {
        return this.ackMore;
    }

    public final void setAckMore(byte[] byArray) {
        if (byArray == null) {
            this.ackMore = null;
        } else {
            this.ackMore = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.ackMore, 0, byArray.length);
        }
    }

    public final int errorCode() {
        return Math.max(-1, this.errorCode);
    }

    public final void setErrorCode(int n) {
        this.errorCode = Math.max(-1, n);
    }

    public void dump() {
        this.dump(new PrintWriter(System.out));
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("sessionId=" + this.sessionId + " msgType=" + this.msgType + " seqNum=" + this.seqNum);
        if (this.version > -1) {
            printWriter.println("  version         = " + this.version);
        }
        if (this.remoteId > -1) {
            printWriter.println("  remoteId        = " + this.remoteId);
        }
        if (this.digestAlgorithm != null) {
            printWriter.println("  digestAlgorithm = " + this.digestAlgorithm);
        }
        if (this.nonce != null) {
            printWriter.println("  nonce           = " + DaspMsg.toString(this.nonce));
        }
        if (this.username != null) {
            printWriter.println("  username        = " + this.username);
        }
        if (this.digest != null) {
            printWriter.println("  digest          = " + DaspMsg.toString(this.digest));
        }
        if (this.idealMax > -1) {
            printWriter.println("  idealMax        = " + this.idealMax);
        }
        if (this.absMax > -1) {
            printWriter.println("  absMax          = " + this.absMax);
        }
        if (this.ack > -1) {
            printWriter.println("  ack             = " + this.ack);
        }
        if (this.ackMore != null) {
            printWriter.println("  ackMore         = " + DaspMsg.toString(this.ackMore));
        }
        if (this.receiveMax > -1) {
            printWriter.println("  receiveMax      = " + this.receiveMax);
        }
        if (this.receiveTimeout > (long)-1) {
            printWriter.println("  receiveTimeout  = " + this.receiveTimeout);
        }
        if (this.errorCode > -1) {
            printWriter.println("  errorCode       = " + this.errorCode);
        }
        printWriter.flush();
    }

    static String toString(byte[] byArray) {
        return DaspMsg.toString(byArray, byArray.length);
    }

    static String toString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer("0x[");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(TextUtil.byteToHexString(byArray[n2] & 0xFF));
            ++n2;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.sessionId = -1;
        this.msgType = -1;
        this.seqNum = -1;
        this.version = -1;
        this.remoteId = -1;
        this.idealMax = -1;
        this.absMax = -1;
        this.ack = -1;
        this.receiveMax = -1;
        this.receiveTimeout = -1;
        this.errorCode = -1;
        this.payload = noBytes;
    }

    public DaspMsg() {
        this.this();
    }

    protected DaspMsg(byte[] byArray, int n) throws UnsupportedEncodingException {
        this.this();
        if (n > byArray.length) {
            throw new IllegalArgumentException("length parameter is larger than buf");
        }
        this.doDecode(byArray, n);
    }
}

