/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.io.IOException;
import sedona.Buf;
import sedona.Value;

public final class Short
extends Value {
    static final Short[] predefined = new Short[256];
    static final Short ZERO;
    static final Short MAX;
    public final int val;

    public static final Short make(int n) {
        if (n < 0 || n > Short.MAX.val) {
            throw new IllegalArgumentException("Valid Short range [0-" + Short.MAX.val + "]: val = " + n);
        }
        if (n < predefined.length) {
            return predefined[n];
        }
        return new Short(n);
    }

    public final int typeId() {
        return 3;
    }

    public final boolean equals(Object object) {
        if (object instanceof Short) {
            boolean bl = false;
            if (this.val == ((Short)object).val) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final int hashCode() {
        return this.val;
    }

    public final String encodeString() {
        return String.valueOf(this.val);
    }

    public final Value decodeString(String string) {
        return Short.make(Integer.decode(string));
    }

    public final void encodeBinary(Buf buf) {
        buf.u2(this.val);
    }

    public final Value decodeBinary(Buf buf) throws IOException {
        return Short.make(buf.u2());
    }

    private Short(int n) {
        this.val = n;
    }

    static {
        int n = 0;
        while (n < predefined.length) {
            Short.predefined[n] = new Short(n);
            ++n;
        }
        ZERO = predefined[0];
        MAX = new Short((char)-1);
    }
}

