/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.io.IOException;
import sedona.Buf;
import sedona.Env;
import sedona.Value;

public final class Float
extends Value {
    public static Float NULL = new Float(java.lang.Float.NaN);
    public static Float ZERO = new Float(0.0f);
    public final float val;

    public static final Float make(float f) {
        if (f == 0.0f) {
            return ZERO;
        }
        if (java.lang.Float.isNaN(f)) {
            return NULL;
        }
        return new Float(f);
    }

    public final boolean isNull() {
        return java.lang.Float.isNaN(this.val);
    }

    public final int typeId() {
        return 6;
    }

    public final int hashCode() {
        return java.lang.Float.floatToIntBits(this.val);
    }

    public final boolean equals(Object object) {
        if (object instanceof Float) {
            return Float.equals(this.val, ((Float)object).val);
        }
        return false;
    }

    public static final boolean equals(float f, float f2) {
        if (java.lang.Float.isNaN(f)) {
            return java.lang.Float.isNaN(f2);
        }
        boolean bl = false;
        if (f == f2) {
            bl = true;
        }
        return bl;
    }

    public final String encodeString() {
        if (this.isNull()) {
            return "null";
        }
        return Env.floatFormat(this.val);
    }

    public final Value decodeString(String string) {
        if (string.equals("null")) {
            return NULL;
        }
        if (string.equals("nullfloat")) {
            return NULL;
        }
        return Float.make(java.lang.Float.parseFloat(string));
    }

    public final void encodeBinary(Buf buf) {
        buf.f4(this.val);
    }

    public final Value decodeBinary(Buf buf) throws IOException {
        return Float.make(buf.f4());
    }

    private Float(float f) {
        this.val = f;
    }
}

