/*
 * Decompiled with CFR 0.152.
 */
package sedona.web;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import sedona.util.TextUtil;
import sedona.web.WebUtil;

public class WebMsg {
    private TreeMap headers = new TreeMap(TextUtil.caseInsensitiveComparator);

    public String[] list() {
        return this.headers.keySet().toArray(new String[this.headers.size()]);
    }

    public String get(String string) {
        return (String)this.headers.get(string);
    }

    public String get(String string, String string2) {
        String string3 = (String)this.headers.get(string);
        return string3 != null ? string3 : string2;
    }

    public WebMsg set(String string, String string2) {
        this.headers.put(string, string2);
        return this;
    }

    public void readHeadersText(InputStream inputStream) throws IOException {
        String string;
        this.headers.clear();
        while ((string = WebMsg.readLine(inputStream).trim()).length() != 0) {
            int n = string.indexOf(58);
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            this.set(string2, string3);
        }
    }

    public void writeHeadersText(OutputStream outputStream) throws IOException {
        for (Map.Entry entry : this.headers.entrySet()) {
            WebMsg.writeLine(outputStream, entry.getKey() + ": " + entry.getValue());
        }
        WebMsg.writeLine(outputStream, "");
    }

    public void readHeadersBinary(InputStream inputStream) throws IOException {
        this.headers.clear();
        int n = inputStream.read();
        while (n > 0) {
            this.set(WebUtil.decompressHeaderName(n), WebUtil.readHeader(n, inputStream));
            n = inputStream.read();
        }
    }

    public void writeHeadersBinary(OutputStream outputStream) throws IOException {
        for (Map.Entry entry : this.headers.entrySet()) {
            WebUtil.writeHeader(entry.getKey(), entry.getValue(), outputStream);
        }
        outputStream.write(0);
    }

    public static String readLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = inputStream.read()) < 0) {
                throw new EOFException();
            }
            if (n == 13 && n2 == 10) break;
            stringBuffer.append((char)n2);
            n = n2;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static void writeLine(OutputStream outputStream, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            outputStream.write(string.charAt(i));
        }
        outputStream.write(13);
        outputStream.write(10);
    }
}

