/*
 * Decompiled with CFR 0.152.
 */
package sedona.platform;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sedona.Env;
import sedona.Facets;
import sedona.platform.ParFile;
import sedona.platform.PlatformDbException;
import sedona.platform.PlatformManifest;
import sedona.util.FileUtil;
import sedona.util.TextUtil;
import sedona.util.sedonadev.Download;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XLocation;
import sedona.xml.XParser;
import sedona.xml.XWriter;

public final class PlatformDb {
    public static final File dbDir = new File(new File(Env.home, "platforms"), "db");
    private static final String manifestName = "platformManifest.xml";
    private static final String parDirName = ".par";

    private PlatformDb() {
        if (!dbDir.exists()) {
            dbDir.mkdirs();
        }
    }

    public static PlatformDb db() {
        return SingletonHolder.INSTANCE;
    }

    public void install(ParFile parFile) {
        PlatformManifest platformManifest = parFile.getPlatformManifest();
        try {
            PlatformManifest.validate(platformManifest);
            File file = this.initInstall(platformManifest);
            Enumeration<? extends ZipEntry> enumeration = parFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                FileUtil.pipe(parFile.getInputStream(zipEntry), byteArrayOutputStream);
                this.writeEntry(file, zipEntry, byteArrayOutputStream);
            }
        }
        catch (Exception exception) {
            throw new PlatformDbException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(ZipInputStream zipInputStream) {
        LinkedHashMap<ZipEntry, Closeable> linkedHashMap = new LinkedHashMap<ZipEntry, Closeable>();
        try {
            Closeable closeable;
            Object object;
            PlatformManifest platformManifest = null;
            ZipEntry zipEntry2 = null;
            try {
                while ((zipEntry2 = zipInputStream.getNextEntry()) != null) {
                    object = zipEntry2.getName();
                    if (((String)object).startsWith("/platformManifest.xml") || ((String)object).startsWith(manifestName)) {
                        platformManifest = PlatformManifest.decodeXml(XParser.make((String)object, zipInputStream).parse(false));
                        continue;
                    }
                    closeable = new ByteArrayOutputStream();
                    FileUtil.pipe(zipInputStream, (OutputStream)closeable);
                    linkedHashMap.put(zipEntry2, closeable);
                    zipInputStream.closeEntry();
                }
            }
            finally {
                zipInputStream.close();
            }
            PlatformManifest.validate(platformManifest);
            object = this.initInstall(platformManifest);
            closeable = new XWriter(new File((File)object, manifestName));
            platformManifest.encodeXml((XWriter)closeable);
            ((XWriter)closeable).close();
            for (ZipEntry zipEntry2 : linkedHashMap.keySet()) {
                this.writeEntry((File)object, zipEntry2, (ByteArrayOutputStream)linkedHashMap.get(zipEntry2));
            }
        }
        catch (PlatformDbException platformDbException) {
            throw platformDbException;
        }
        catch (Exception exception) {
            throw new PlatformDbException(exception);
        }
        finally {
            linkedHashMap = null;
        }
    }

    private File initInstall(PlatformManifest platformManifest) throws IOException {
        File file = this.toParLocation(platformManifest.id);
        FileUtil.delete(file, null);
        FileUtil.mkdir(file, null);
        return file;
    }

    private void writeEntry(File file, ZipEntry zipEntry, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        Object object;
        String string = zipEntry.getName();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.endsWith("/") || zipEntry.isDirectory()) {
            FileUtil.mkdir(new File(file, string), null);
            return;
        }
        int n = string.lastIndexOf(47);
        if (n > 0) {
            object = string.substring(0, n);
            FileUtil.mkdir(new File(file, (String)object), null);
        }
        object = new FileOutputStream(new File(file, string));
        byteArrayOutputStream.writeTo((OutputStream)object);
        ((FileOutputStream)object).close();
    }

    public void extract(String string, File file) {
        File file2 = this.toParLocation(string);
        if (!file2.exists()) {
            throw new PlatformDbException("'" + string + "' is not in the database");
        }
        try {
            FileUtil.copyDir(file2, file, null);
        }
        catch (Exception exception) {
            throw new PlatformDbException(exception);
        }
    }

    public String[] list() {
        ArrayList arrayList = new ArrayList();
        this.list(arrayList, dbDir, new ArrayList());
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private void list(ArrayList arrayList, File file, ArrayList arrayList2) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            String string = file2.getName();
            if (!file2.isDirectory()) continue;
            if (string.equals(parDirName)) {
                arrayList.add(TextUtil.join(arrayList2.toArray(), "-"));
                continue;
            }
            arrayList2.add(string);
            this.list(arrayList, file2, arrayList2);
            arrayList2.remove(arrayList2.size() - 1);
        }
    }

    public PlatformManifest load(String string) throws XException {
        PlatformMatch platformMatch = this.matchBest(string);
        if (platformMatch == null) {
            return null;
        }
        XElem xElem = this.parseManifest(platformMatch.manifest);
        if (!xElem.get("platformId").startsWith(platformMatch.matchId)) {
            throw new XException(string + " does not start with matched platform manifest id " + platformMatch.matchId, xElem);
        }
        return PlatformManifest.decodeXml(xElem);
    }

    public PlatformManifest loadExact(String string) throws XException {
        PlatformManifest platformManifest = this.load(string);
        return platformManifest != null && string.equals(platformManifest.id) ? platformManifest : null;
    }

    public DbVm getVm(PlatformManifest platformManifest) {
        return this.getVm(platformManifest.id);
    }

    public DbVm getVm(String string) {
        PlatformMatch platformMatch = this.matchBest(string);
        if (platformMatch == null) {
            return null;
        }
        File file = new File(platformMatch.manifest.getParentFile(), "svm");
        File[] fileArray = file.listFiles();
        return fileArray.length > 0 ? new DbVm(platformMatch.matchId, fileArray[0]) : null;
    }

    private File toParLocation(String string) {
        String[] stringArray = TextUtil.split(string, '-');
        File file = dbDir;
        for (int i = 0; i < stringArray.length; ++i) {
            file = new File(file, stringArray[i]);
        }
        return new File(file, parDirName);
    }

    private PlatformMatch matchBest(String string) {
        Object[] objectArray = TextUtil.split(string, '-');
        File file = null;
        String string2 = null;
        for (int i = objectArray.length; i > 0 && !(file = new File(this.toParLocation(string2 = TextUtil.join(objectArray, 0, i, "-")), manifestName)).exists(); --i) {
        }
        if (!string.equals(string2)) {
            try {
                this.install(Download.fetchPar(string));
                file = new File(this.toParLocation(string), manifestName);
                string2 = string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return file.exists() ? new PlatformMatch(file, string2) : null;
    }

    private XElem parseManifest(File file) {
        try {
            return XParser.make(file).parse();
        }
        catch (Exception exception) {
            throw new XException("Cannot parse XML file", new XLocation(file.toString()));
        }
    }

    public static void main(String[] stringArray) {
        Facets facets = PlatformDb.parseOpts(stringArray);
        try {
            if (facets.getb("list")) {
                PlatformDb.showList(facets);
            } else if (facets.getb("install")) {
                PlatformDb.db().install(new ParFile(facets.gets("par")));
            } else if (facets.getb("extract")) {
                PlatformDb.db().extract(facets.gets("id"), new File(facets.gets("out", facets.gets("id"))));
            } else {
                PlatformDb.err("No actions to take");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            PlatformDb.err(exception.getMessage());
        }
    }

    private static void showList(Facets facets) {
        String[] stringArray = PlatformDb.db().list();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
    }

    private static Facets parseOpts(String[] stringArray) {
        Facets facets = new Facets();
        if (stringArray.length == 0) {
            PlatformDb.err("No options");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-h") || string.equals("--help")) {
                PlatformDb.showHelp(0);
                continue;
            }
            if (string.equals("-l") || string.equals("--list")) {
                facets.setb("list", true);
                continue;
            }
            if (string.equals("-i")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].charAt(0) == '-') {
                    PlatformDb.err("Missing argument for -i option");
                }
                facets.setb("install", true);
                facets.sets("par", stringArray[++i]);
                continue;
            }
            if (string.equals("-x") || string.equals("--extract")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].charAt(0) == '-') {
                    PlatformDb.err("Missing argument for -x option");
                }
                facets.setb("extract", true);
                facets.sets("id", stringArray[++i]);
                continue;
            }
            if (string.equals("-o") || string.equals("--out")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].charAt(0) == '-') {
                    PlatformDb.err("Missing argument for -o option");
                }
                facets.sets("out", stringArray[++i]);
                continue;
            }
            PlatformDb.err("Unrecognized option '" + string + "'");
        }
        return facets;
    }

    private static void err(String string) {
        System.err.println("\nError: " + string);
        PlatformDb.showHelp(1);
    }

    private static void showHelp(int n) {
        System.out.println();
        System.out.println("usage:");
        System.out.println("  PlatformDb [OPTIONS]");
        System.out.println("options:");
        System.out.println("  -l, --list          List all platforms in the database");
        System.out.println("  -i platform.par     Install the given PAR file into the platform database");
        System.out.println("  -x, --extract <ID>  Extract all files for the platform with the given ID");
        System.out.println("                      to ./<ID>/. Use -o to change the output location.");
        System.out.println("  -o, --out LOC       Change the default output location to LOC");
        System.out.println("  -h, --help          Print this usage");
        System.out.println();
        System.exit(n);
    }

    private class PlatformMatch {
        public final File manifest;
        public final String matchId;

        public PlatformMatch(File file, String string) {
            this.manifest = file;
            this.matchId = string;
        }
    }

    public static final class DbVm {
        private final String platformId;
        private final File svm;

        DbVm(String string, File file) {
            this.platformId = string;
            this.svm = file;
        }

        public String id() {
            return this.platformId;
        }

        public String name() {
            return this.svm.getName();
        }

        public File copyTo(File file) throws IOException {
            File file2 = new File(file, this.name());
            FileUtil.copyFile(this.svm, file2);
            return file2;
        }
    }

    private static class SingletonHolder {
        private static final PlatformDb INSTANCE = new PlatformDb();

        private SingletonHolder() {
        }
    }
}

