/*
 * Decompiled with CFR 0.152.
 */
package sedona.offline;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import sedona.Buf;
import sedona.Schema;
import sedona.offline.OfflineComponent;
import sedona.offline.OfflineLink;
import sedona.util.FileUtil;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XParser;
import sedona.xml.XWriter;

public class OfflineApp
extends OfflineComponent {
    public final Schema schema;
    private OfflineComponent[] lookup;
    private ArrayList links;
    private int lastId;

    public OfflineApp(Schema schema) {
        super(schema.type("sys::App"));
        this.app = this;
        this.id = 0;
        this.name = "app";
        this.schema = schema;
        this.lookup = new OfflineComponent[256];
        this.lookup[0] = this;
        this.links = new ArrayList();
    }

    public OfflineComponent lookup(int n) {
        if (n < 0 || n >= this.lookup.length) {
            return null;
        }
        return this.lookup[n];
    }

    public OfflineComponent lookup(String string) {
        OfflineComponent offlineComponent = this;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ((offlineComponent = offlineComponent.child(string2)) != null) continue;
            return null;
        }
        return offlineComponent;
    }

    public int maxId() {
        for (int i = this.lookup.length - 1; i >= 0; --i) {
            if (this.lookup[i] == null) continue;
            return i;
        }
        return 0;
    }

    private int generateId() {
        for (int i = this.lastId; i < this.lookup.length; ++i) {
            if (this.lookup[i] != null) continue;
            this.lastId = i;
            return this.lastId;
        }
        this.lastId = this.lookup.length;
        return this.lastId;
    }

    public void assignIds() {
        this.assignIds(this);
    }

    private void assignIds(OfflineComponent offlineComponent) {
        if (offlineComponent.id < 0) {
            offlineComponent.id = this.generateId();
            this.addToLookupTable(offlineComponent);
        }
        OfflineComponent[] offlineComponentArray = offlineComponent.children();
        for (int i = 0; i < offlineComponentArray.length; ++i) {
            this.assignIds(offlineComponentArray[i]);
        }
    }

    private void addToLookupTable(OfflineComponent offlineComponent) {
        if (offlineComponent.id >= this.lookup.length) {
            OfflineComponent[] offlineComponentArray = new OfflineComponent[Math.max(this.lookup.length * 2, offlineComponent.id + 32)];
            System.arraycopy(this.lookup, 0, offlineComponentArray, 0, this.lookup.length);
            this.lookup = offlineComponentArray;
        }
        this.lookup[offlineComponent.id] = offlineComponent;
    }

    public boolean equivalent(OfflineApp offlineApp) {
        if (!super.equivalent(offlineApp)) {
            return false;
        }
        if (!this.schema.equivalent(offlineApp.schema)) {
            return false;
        }
        if (this.links.size() != offlineApp.links.size()) {
            return false;
        }
        for (int i = 0; i < this.links.size(); ++i) {
            OfflineLink offlineLink;
            OfflineLink offlineLink2 = (OfflineLink)this.links.get(i);
            if (offlineLink2.equivalent(offlineLink = (OfflineLink)offlineApp.links.get(i))) continue;
            return false;
        }
        return true;
    }

    public OfflineComponent add(OfflineComponent offlineComponent, OfflineComponent offlineComponent2) {
        if (this.lookup(offlineComponent2.id) != null) {
            throw new IllegalStateException("Duplicate id: " + offlineComponent2.id);
        }
        if (offlineComponent == null) {
            throw new IllegalStateException("Parent is null");
        }
        if (offlineComponent.app != this) {
            throw new IllegalStateException("Parent not mounted under app: " + offlineComponent);
        }
        if (offlineComponent2.parent != null) {
            throw new IllegalStateException("Kid already mounted: " + offlineComponent2);
        }
        if (offlineComponent.child(offlineComponent2.name) != null) {
            throw new IllegalStateException("Duplicate name: " + offlineComponent2.name);
        }
        if (offlineComponent.kids != null && offlineComponent.kids.size() >= 200) {
            throw new IllegalArgumentException("Too many children under component: " + offlineComponent);
        }
        if (offlineComponent2.type.isAbstract()) {
            throw new IllegalArgumentException("Cannot add component with abstract type to app: " + offlineComponent2);
        }
        if (!offlineComponent2.type.isPublic()) {
            throw new IllegalArgumentException("Cannot add component with non-public type to app: " + offlineComponent2);
        }
        if (offlineComponent2.id > 0) {
            this.addToLookupTable(offlineComponent2);
        }
        if (offlineComponent.kids == null) {
            offlineComponent.kids = new ArrayList();
            offlineComponent.kidsByName = new HashMap();
        }
        offlineComponent2.app = this;
        offlineComponent2.parent = offlineComponent;
        offlineComponent.kids.add(offlineComponent2);
        offlineComponent.kidsByName.put(offlineComponent2.name, offlineComponent2);
        return offlineComponent2;
    }

    public void remove(OfflineComponent offlineComponent) {
        if (offlineComponent == this) {
            throw new IllegalStateException("Can't delete app itself!");
        }
        if (offlineComponent.app != this || this.lookup(offlineComponent.id) != offlineComponent) {
            throw new IllegalStateException("Not in this app: " + offlineComponent);
        }
        OfflineComponent[] offlineComponentArray = offlineComponent.children();
        for (int i = 0; i < offlineComponentArray.length; ++i) {
            this.remove(offlineComponentArray[i]);
        }
        OfflineLink[] offlineLinkArray = this.getLinks();
        for (int i = 0; i < offlineLinkArray.length; ++i) {
            OfflineLink offlineLink = offlineLinkArray[i];
            if (offlineComponent.id != offlineLink.fromComp.id && offlineComponent.id != offlineLink.toComp.id) continue;
            this.removeLink(offlineLink);
        }
        this.lookup[offlineComponent.id] = null;
        OfflineComponent offlineComponent2 = offlineComponent.parent;
        offlineComponent.app = null;
        offlineComponent.parent = null;
        offlineComponent2.kids.remove(offlineComponent);
        offlineComponent2.kidsByName.remove(offlineComponent.name);
    }

    public void reorder(OfflineComponent offlineComponent, int[] nArray) {
        int[] nArray2 = (int[])nArray.clone();
        OfflineComponent[] offlineComponentArray = offlineComponent.children();
        if (offlineComponent == null) {
            throw new IllegalStateException("Parent is null");
        }
        if (offlineComponent.app != this || this.lookup(offlineComponent.id) != offlineComponent) {
            throw new IllegalStateException("Not in this app: " + offlineComponent);
        }
        if (offlineComponentArray.length != nArray2.length) {
            throw new IllegalArgumentException("childrenIds.length wrong");
        }
        ArrayList<OfflineComponent> arrayList = new ArrayList<OfflineComponent>(offlineComponentArray.length);
        for (int i = 0; i < nArray2.length; ++i) {
            OfflineComponent offlineComponent2 = null;
            for (int j = 0; j < offlineComponentArray.length; ++j) {
                if (offlineComponentArray[j].id != nArray2[i]) continue;
                offlineComponent2 = offlineComponentArray[j];
                break;
            }
            if (offlineComponent2 == null) {
                throw new IllegalArgumentException("childrenId not found: " + nArray2[i]);
            }
            arrayList.add(offlineComponent2);
        }
        offlineComponent.kids = arrayList;
    }

    public void addLink(OfflineLink offlineLink) {
        OfflineLink offlineLink2 = this.findLink(offlineLink);
        if (offlineLink2 == null) {
            this.links.add(offlineLink);
        }
    }

    public void removeLink(OfflineLink offlineLink) {
        this.links.remove(this.findLink(offlineLink));
    }

    public OfflineLink[] getLinks() {
        return this.links.toArray(new OfflineLink[this.links.size()]);
    }

    OfflineLink findLink(OfflineLink offlineLink) {
        for (int i = 0; i < this.links.size(); ++i) {
            OfflineLink offlineLink2 = (OfflineLink)this.links.get(i);
            if (!offlineLink.equivalent(offlineLink2)) continue;
            return offlineLink2;
        }
        return null;
    }

    public int ramSize() {
        int n = 0;
        for (int i = 0; i < this.lookup.length; ++i) {
            if (this.lookup[i] == null) continue;
            n += OfflineApp.align(this.lookup[i].type.manifest.sizeof);
        }
        return n += this.links.size() * 16;
    }

    static int align(int n) {
        int n2 = n % 4;
        if (n2 == 0) {
            return n;
        }
        return n + (4 - n2);
    }

    public int flashSize() {
        return this.encodeAppBinary().size;
    }

    public void encodeAppXml(File file) throws Exception {
        this.encodeAppXml(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeAppXml(File file, boolean bl) throws Exception {
        XWriter xWriter = new XWriter(file);
        try {
            this.encodeAppXml(xWriter, bl);
        }
        finally {
            xWriter.close();
        }
    }

    public void encodeAppXml(OutputStream outputStream) throws Exception {
        this.encodeAppXml(outputStream, false);
    }

    public void encodeAppXml(OutputStream outputStream, boolean bl) throws Exception {
        this.encodeAppXml(new XWriter(outputStream), bl);
    }

    public void encodeAppXml(XWriter xWriter) {
        this.encodeAppXml(xWriter, false);
    }

    public void encodeAppXml(XWriter xWriter, boolean bl) {
        xWriter.w("<?xml version='1.0'?>\n");
        xWriter.w("<sedonaApp>\n");
        this.schema.encodeXml(xWriter, bl);
        xWriter.w("<app>\n");
        this.encodeXmlProps(xWriter, 2, true);
        this.encodeXmlChildren(xWriter, 2, true);
        xWriter.w("</app>\n");
        xWriter.w("<links>\n");
        for (int i = 0; i < this.links.size(); ++i) {
            ((OfflineLink)this.links.get(i)).encodeXml(xWriter);
        }
        xWriter.w("</links>\n");
        xWriter.w("</sedonaApp>\n");
    }

    public void dump() {
        XWriter xWriter = new XWriter(System.out);
        this.encodeAppXml(xWriter, false);
        xWriter.flush();
    }

    public static OfflineApp decodeApp(File file) throws Exception {
        if (file.getName().endsWith(".sax")) {
            return OfflineApp.decodeAppXml(file);
        }
        return OfflineApp.decodeAppBinary(new FileInputStream(file));
    }

    public static OfflineApp decodeAppXml(File file) throws Exception {
        return OfflineApp.decodeAppXml(XParser.make(file).parse());
    }

    public static OfflineApp decodeAppXml(String string, InputStream inputStream) throws Exception {
        return OfflineApp.decodeAppXml(XParser.make(string, inputStream).parse());
    }

    public static OfflineApp decodeAppXml(XElem xElem) throws Exception {
        if (!xElem.name().equals("sedonaApp")) {
            throw new XException("Root element must be <sedonaApp>", xElem);
        }
        Schema schema = Schema.decodeXml(xElem.elem("schema", true));
        OfflineApp offlineApp = new OfflineApp(schema);
        XElem xElem2 = xElem.elem("app", true);
        offlineApp.decodeXmlProps(xElem2);
        offlineApp.decodeXmlChildren(xElem2);
        offlineApp.assignIds(offlineApp);
        XElem[] xElemArray = xElem.elem("links", true).elems("link");
        offlineApp.links = new ArrayList(Math.max(32, xElemArray.length));
        for (int i = 0; i < xElemArray.length; ++i) {
            offlineApp.links.add(OfflineLink.decodeXml(offlineApp, xElemArray[i]));
        }
        return offlineApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeAppBinary(File file) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.encodeAppBinary().writeTo(fileOutputStream);
        }
        finally {
            fileOutputStream.close();
        }
    }

    public Buf encodeAppBinary() {
        int n;
        Buf buf = new Buf(1024);
        buf.i4(1935765616);
        buf.i4(3);
        this.schema.encodeBinary(buf);
        buf.u2(this.maxId());
        for (n = 0; n < this.lookup.length; ++n) {
            if (this.lookup[n] == null) continue;
            this.lookup[n].encodeBinary(buf);
        }
        buf.u2(65535);
        for (n = 0; n < this.links.size(); ++n) {
            ((OfflineLink)this.links.get(n)).encodeBinary(buf);
        }
        buf.u2(65535);
        buf.u1(46);
        return buf;
    }

    public static OfflineApp decodeAppBinary(File file) throws Exception {
        return OfflineApp.decodeAppBinary(new FileInputStream(file));
    }

    public static OfflineApp decodeAppBinary(InputStream inputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.pipe(inputStream, byteArrayOutputStream);
        return OfflineApp.decodeAppBinary(new Buf(byteArrayOutputStream.toByteArray()));
    }

    public static OfflineApp decodeAppBinary(Buf buf) throws Exception {
        int n;
        int n2;
        int n3 = buf.i4();
        int n4 = buf.i4();
        if (n3 != 1935765616) {
            throw new IOException("Invalid magic 0x" + Integer.toHexString(n3));
        }
        if (n4 != 3) {
            throw new IOException("Invalid version 0x" + Integer.toHexString(n4));
        }
        Schema schema = Schema.decodeBinary(buf);
        int n5 = buf.u2();
        OfflineApp offlineApp = new OfflineApp(schema);
        HashMap<Integer, OfflineComponent.Decoded> hashMap = new HashMap<Integer, OfflineComponent.Decoded>();
        while ((n2 = buf.u2()) != 65535) {
            OfflineComponent.Decoded decoded = OfflineComponent.decodeBinary(offlineApp, buf, n2);
            hashMap.put(new Integer(decoded.comp.id), decoded);
            if (decoded.comp == offlineApp) continue;
            if (offlineApp.lookup(decoded.comp.id) != null) {
                throw new IOException("Duplicate id: " + decoded.comp.id);
            }
            offlineApp.addToLookupTable(decoded.comp);
        }
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            offlineApp.finishDecode(hashMap, (OfflineComponent.Decoded)iterator.next());
        }
        while ((n = buf.u2()) != 65535) {
            offlineApp.links.add(OfflineLink.decodeBinary(offlineApp, n, buf));
        }
        if (buf.u1() != 46) {
            throw new IOException("Invalid app end marker");
        }
        return offlineApp;
    }

    private void finishDecode(HashMap hashMap, OfflineComponent.Decoded decoded) throws IOException {
        block5: {
            OfflineComponent offlineComponent = decoded.comp;
            if (decoded.parentId != 65535) {
                offlineComponent.parent = this.lookup(decoded.parentId);
                if (offlineComponent.parent == null) {
                    throw new IOException("Missing parent " + decoded.parentId + " for " + offlineComponent);
                }
            }
            if (decoded.childrenId != 65535) {
                OfflineComponent.Decoded decoded2;
                offlineComponent.kids = new ArrayList();
                offlineComponent.kidsByName = new HashMap();
                OfflineComponent offlineComponent2 = this.lookup(decoded.childrenId);
                if (offlineComponent2 == null) {
                    throw new IOException("Missing child " + decoded.childrenId + " for " + offlineComponent);
                }
                do {
                    offlineComponent.kids.add(offlineComponent2);
                    offlineComponent.kidsByName.put(offlineComponent2.name, offlineComponent2);
                    decoded2 = (OfflineComponent.Decoded)hashMap.get(new Integer(offlineComponent2.id));
                    if (decoded2.nextSiblingId == 65535) break block5;
                } while ((offlineComponent2 = this.lookup(decoded2.nextSiblingId)) != null);
                throw new IOException("Missing nextSibling " + decoded.nextSiblingId + " for " + decoded2.comp);
            }
        }
    }
}

