/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import sedona.Buf;
import sedona.Facets;
import sedona.Str;
import sedona.Type;
import sedona.Value;
import sedona.manifest.SlotManifest;

public class Slot {
    public static final int ACTION = 1;
    public static final int CONFIG = 2;
    public static final int AS_STR = 4;
    public static final int OPERATOR = 8;
    public final Type parent;
    public final int id;
    public final SlotManifest manifest;
    public final String name;
    public final String qname;
    public final Facets facets;
    public final int flags;
    public final Type type;
    private final Value def;

    Slot(Type type, int n, SlotManifest slotManifest) throws Exception {
        Type type2 = type.schema.type(slotManifest.type);
        if (type2 == null) {
            throw new Exception("Unresolved type '" + slotManifest.type + "' for slot '" + slotManifest.qname + "'");
        }
        this.parent = type;
        this.id = n;
        this.manifest = slotManifest;
        this.name = slotManifest.name;
        this.qname = slotManifest.qname;
        this.facets = slotManifest.facets;
        this.flags = slotManifest.flags;
        this.def = slotManifest.def;
        this.type = type2;
    }

    public String toString() {
        return this.qname;
    }

    public Value def() {
        return this.def;
    }

    public void assertValue(Value value) {
        String string = this.checkValue(value);
        if (string == null) {
            return;
        }
        throw new IllegalArgumentException("Invalid value for slot '" + this.qname + "' (" + string + ")");
    }

    public String checkValue(Value value) {
        boolean bl;
        if (value == null) {
            if (this.type.id == 0) {
                return null;
            }
            return "wrongType";
        }
        boolean bl2 = bl = this.isAsStr() ? value instanceof Str : this.type.is(value);
        if (!bl) {
            return "wrongType";
        }
        switch (value.typeId()) {
            case 101: {
                Str str = (Str)value;
                int n = this.facets.geti("max", -1);
                if (n > 0 && str.val.length() >= n) {
                    return "strTooLong";
                }
                if (str.isAscii()) break;
                return "strNotAscii";
            }
            case 8: {
                Buf buf = (Buf)value;
                int n = this.facets.geti("max", -1);
                if (n <= 0 || buf.size <= n) break;
                return "bufTooLong";
            }
        }
        return null;
    }

    public boolean isProp() {
        return (this.flags & 1) == 0;
    }

    public boolean isAction() {
        return (this.flags & 1) != 0;
    }

    public boolean isConfig() {
        return this.isProp() && (this.flags & 2) != 0;
    }

    public boolean isRuntime() {
        return this.isProp() && (this.flags & 2) == 0;
    }

    public boolean isAsStr() {
        return (this.flags & 4) != 0;
    }

    public boolean isOperator() {
        return (this.flags & 8) != 0;
    }
}

