/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import sedona.Buf;
import sedona.Kit;
import sedona.KitPart;
import sedona.Type;
import sedona.manifest.KitManifest;
import sedona.manifest.ManifestDb;
import sedona.util.Log;
import sedona.util.TextUtil;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XWriter;

public class Schema {
    public static final Log log = new Log("schema");
    private static HashMap cache = new HashMap();
    public final String key;
    public final Kit[] kits;
    final HashMap kitsByName;

    public static Schema load(KitPart[] kitPartArray) throws Exception {
        Schema.sortKits(kitPartArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < kitPartArray.length; ++i) {
            stringBuffer.append(kitPartArray[i]).append(';');
        }
        String string = stringBuffer.substring(0, stringBuffer.length() - 1);
        Schema schema = (Schema)cache.get(string);
        if (schema != null) {
            return schema;
        }
        log.debug("Loading... [" + string + "]");
        schema = new Schema(string, new Kit[kitPartArray.length]);
        for (int i = 0; i < kitPartArray.length; ++i) {
            Kit kit;
            KitPart kitPart = kitPartArray[i];
            KitManifest kitManifest = ManifestDb.load(kitPart);
            if (kitManifest == null) {
                throw new MissingKitManifestException(kitPart);
            }
            if (schema.kitsByName.get(kitManifest.name) != null) {
                throw new Exception("Duplicate kit name: " + kitManifest.name);
            }
            schema.kits[i] = kit = new Kit(schema, i, kitManifest);
            schema.kitsByName.put(kit.name, kit);
        }
        schema.resolve();
        cache.put(string, schema);
        return schema;
    }

    private Schema(String string, Kit[] kitArray) {
        this.key = string;
        this.kits = kitArray;
        this.kitsByName = new HashMap(kitArray.length * 3);
    }

    public static void sortKits(Object[] objectArray) {
        try {
            final Field field = objectArray[0].getClass().getField("name");
            Arrays.sort(objectArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    try {
                        String string = (String)field.get(object);
                        String string2 = (String)field.get(object2);
                        if (string.equals("sys")) {
                            return -1;
                        }
                        if (string2.equals("sys")) {
                            return 1;
                        }
                        return string.compareTo(string2);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.toString());
                    }
                }
            });
            if (!field.get(objectArray[0]).equals("sys")) {
                throw new IllegalStateException("sys kit must be in every schema");
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public Kit kit(int n) {
        if (0 <= n & n < this.kits.length) {
            return this.kits[n];
        }
        return null;
    }

    public Kit kit(String string) {
        return (Kit)this.kitsByName.get(string);
    }

    public Type type(String string) {
        int n = string.indexOf(58);
        if (n < 0 || string.charAt(n + 1) != ':') {
            Type type = this.type("sys::" + string);
            if (type != null) {
                return type;
            }
            throw new IllegalStateException("Invalid type signature: " + string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 2);
        Kit kit = this.kit(string2);
        if (kit == null) {
            return null;
        }
        return kit.type(string3);
    }

    public Type[] allConcreteTypes(Type type) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (int i = 0; i < this.kits.length; ++i) {
            Type[] typeArray = this.kits[i].types;
            for (int j = 0; j < typeArray.length; ++j) {
                if (typeArray[j].isAbstract() || !typeArray[j].is(type)) continue;
                arrayList.add(typeArray[j]);
            }
        }
        Object[] objectArray = arrayList.toArray(new Type[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public boolean equivalent(Schema schema) {
        return this.key.equals(schema.key);
    }

    public String toString() {
        return this.key;
    }

    void resolve() throws Exception {
        int n;
        Kit kit;
        int n2;
        for (n2 = 0; n2 < this.kits.length; ++n2) {
            kit = this.kits[n2];
            for (n = 0; n < kit.types.length; ++n) {
                kit.types[n].resolveBase();
            }
        }
        for (n2 = 0; n2 < this.kits.length; ++n2) {
            kit = this.kits[n2];
            for (n = 0; n < kit.types.length; ++n) {
                kit.types[n].resolveSlots();
            }
        }
    }

    public void encodeXml(XWriter xWriter) {
        this.encodeXml(xWriter, false);
    }

    public void encodeXml(XWriter xWriter, boolean bl) {
        xWriter.write("<schema>\n");
        for (int i = 0; i < this.kits.length; ++i) {
            Kit kit = this.kits[i];
            xWriter.w("  <kit ").attr("name", kit.name).w(" ");
            if (bl) {
                xWriter.w("/>\n");
                continue;
            }
            xWriter.attr("checksum", TextUtil.intToHexString(kit.checksum)).w(" />\n");
        }
        xWriter.write("</schema>\n");
    }

    public static Schema decodeXml(XElem xElem) throws Exception {
        XElem[] xElemArray = xElem.elems("kit");
        KitPart[] kitPartArray = new KitPart[xElemArray.length];
        for (int i = 0; i < kitPartArray.length; ++i) {
            KitPart kitPart;
            String string = xElemArray[i].get("name");
            int n = (int)Long.parseLong(xElemArray[i].get("checksum", "0"), 16);
            if (n == 0) {
                kitPart = KitPart.forLocalKit(string);
                if (kitPart == null) {
                    throw new XException("Local kit '" + string + "' not found, must use explicit checksum", xElemArray[i]);
                }
            } else {
                kitPart = new KitPart(string, n);
            }
            kitPartArray[i] = kitPart;
        }
        return Schema.load(kitPartArray);
    }

    public void encodeBinary(Buf buf) {
        buf.u1(this.kits.length);
        for (int i = 0; i < this.kits.length; ++i) {
            Kit kit = this.kits[i];
            buf.str(kit.name);
            buf.i4(kit.checksum);
        }
    }

    public static Schema decodeBinary(Buf buf) throws Exception {
        KitPart[] kitPartArray = new KitPart[buf.u1()];
        for (int i = 0; i < kitPartArray.length; ++i) {
            kitPartArray[i] = new KitPart(buf.str(), buf.i4());
        }
        return Schema.load(kitPartArray);
    }

    public static class MissingKitManifestException
    extends Exception {
        public final KitPart part;

        public MissingKitManifestException(KitPart kitPart) {
            super("Missing kit manifest: " + kitPart);
            this.part = kitPart;
        }
    }
}

