/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import sedona.util.Version;

public class Env {
    public static File home;
    public static final String hostname;
    public static final String version;
    public static final String copyright = "Copyright (c) 2007-2009 Tridium, Inc.";
    static final Properties props;
    static Method ticksMethod;
    static boolean ticksMethodInNanos;

    public static String timestamp() {
        return new SimpleDateFormat("dd-MMM-yyyy HH:mm").format(new Date());
    }

    public static String floatFormat(float f) {
        return Float.toString(f);
    }

    public static String doubleFormat(double d) {
        return Double.toString(d);
    }

    public static void printVersion(String string) {
        System.out.println(string + " " + version);
        System.out.println(copyright);
        System.out.println("sedona.version = " + version);
        System.out.println("sedona.home    = " + home);
        System.out.println("java.home      = " + System.getProperty("java.home"));
        System.out.println("java.version   = " + System.getProperty("java.version"));
    }

    public static Properties getProperties() {
        return props;
    }

    public static String getProperty(String string) {
        return Env.getProperty(string, null);
    }

    public static String getProperty(String string, String string2) {
        return props.getProperty(string, string2);
    }

    public static boolean getProperty(String string, boolean bl) {
        String string2 = Env.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equals("true");
    }

    public static int getProperty(String string, int n) {
        String string2 = Env.getProperty(string, null);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public static long getProperty(String string, long l) {
        String string2 = Env.getProperty(string, null);
        if (string2 == null) {
            return l;
        }
        return Long.parseLong(string2);
    }

    public static long ticks() {
        try {
            if (ticksMethod != null) {
                long l = (Long)ticksMethod.invoke(null, null);
                if (ticksMethodInNanos) {
                    l /= 1000000L;
                }
                return l;
            }
            return System.currentTimeMillis();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public static boolean checkJavaVersion() {
        try {
            Version version;
            Version version2;
            String string = System.getProperty("java.version");
            int n = string.indexOf(95);
            if (n > 0) {
                string = string.substring(0, n);
            }
            if ((version2 = new Version(string)).compareTo(version = new Version("1.4")) >= 0) {
                return true;
            }
            System.out.println("Sedona requires Java " + version + " or greater");
            System.out.println("java.home    = " + System.getProperty("java.home"));
            System.out.println("java.version = " + version2);
            return false;
        }
        catch (Exception exception) {
            System.out.println("WARNING: Cannot check java version");
            System.out.println("  " + exception);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object;
        block19: {
            File file;
            Object object2;
            String string;
            props = new Properties();
            try {
                string = System.getProperty("sedona.home");
                if (string == null) {
                    object2 = System.getProperty("baja.home");
                    if (object2 != null) {
                        string = new File((String)object2).toString() + File.separator + "sedona";
                    } else {
                        throw new Exception("Must set system property 'sedona.home'");
                    }
                }
                file = new File(string).getCanonicalFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                file = new File(".");
            }
            home = file;
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                string = "Unknown";
            }
            hostname = string;
            try {
                ticksMethod = Class.forName("javax.baja.sys.Clock").getMethod("ticks", new Class[0]);
            }
            catch (Exception exception) {
                try {
                    ticksMethod = Class.forName("java.lang.System").getMethod("nanoTime", new Class[0]);
                    ticksMethodInNanos = true;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            object2 = new File(home, "lib" + File.separator + "sedona.properties");
            try {
                object = new BufferedInputStream(new FileInputStream((File)object2));
                try {
                    props.load((InputStream)object);
                    for (Object object3 : props.keySet()) {
                        String string2 = props.getProperty((String)object3);
                        props.put(object3, string2.trim());
                    }
                }
                finally {
                    ((InputStream)object).close();
                }
            }
            catch (Exception exception) {
                System.out.println("WARNING: Cannot load properties file: " + object2);
                if (exception instanceof FileNotFoundException) break block19;
                System.out.println("  " + exception);
            }
        }
        try {
            Object object3;
            Properties properties = new Properties();
            object3 = Env.class.getResourceAsStream("/version.txt");
            properties.load((InputStream)object3);
            ((InputStream)object3).close();
            object = properties.getProperty("version");
        }
        catch (Exception exception) {
            System.out.println("WARNING: Cannot load version.txt from jar");
            exception.printStackTrace();
            object = "Unknown";
        }
        version = object;
    }
}

