/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.io.IOException;
import sedona.Buf;
import sedona.Value;

public final class Byte
extends Value {
    static final Byte[] predefined = new Byte[256];
    static final Byte ZERO;
    static final Byte MAX;
    public final int val;

    public static Byte make(int n) {
        if (n < 0 || n > Byte.MAX.val) {
            throw new IllegalArgumentException("Valid Byte range [0-" + Byte.MAX.val + "]: val = " + n);
        }
        return predefined[n];
    }

    private Byte(int n) {
        this.val = n;
    }

    @Override
    public int typeId() {
        return 2;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Byte) {
            return this.val == ((Byte)object).val;
        }
        return false;
    }

    @Override
    public String encodeString() {
        return String.valueOf(this.val);
    }

    @Override
    public Value decodeString(String string) {
        return Byte.make(Integer.decode(string));
    }

    @Override
    public void encodeBinary(Buf buf) {
        buf.u1(this.val);
    }

    @Override
    public Value decodeBinary(Buf buf) throws IOException {
        return Byte.make(buf.u1());
    }

    static {
        for (int i = 0; i < predefined.length; ++i) {
            Byte.predefined[i] = new Byte(i);
        }
        ZERO = predefined[0];
        MAX = predefined[255];
    }
}

