/*
 * Decompiled with CFR 0.152.
 */
package sedona.util;

import java.io.PrintStream;
import sedona.util.Abstime;

public class Log {
    public final String name;
    public PrintStream out;
    public int severity = 2;
    public static final int ERROR = 4;
    public static final int WARN = 3;
    public static final int INFO = 2;
    public static final int DEBUG = 1;
    public static final int SILENT = 0;

    public Log(String string) {
        this(string, System.out);
    }

    public Log(String string, PrintStream printStream) {
        this.name = string;
        this.out = printStream;
    }

    public static String severityToString(int n) {
        switch (n) {
            case 4: {
                return "error";
            }
            case 3: {
                return "warn";
            }
            case 2: {
                return "info";
            }
            case 1: {
                return "debug";
            }
        }
        return "Unknown(" + n + ")";
    }

    public boolean isError() {
        return this.severity >= 4;
    }

    public boolean isWarn() {
        return this.severity >= 3;
    }

    public boolean isInfo() {
        return this.severity >= 2;
    }

    public boolean isDebug() {
        return this.severity >= 1;
    }

    public void error(String string) {
        this.log(4, string, null);
    }

    public void error(String string, Throwable throwable) {
        this.log(4, string, throwable);
    }

    public void warn(String string) {
        this.log(3, string, null);
    }

    public void warn(String string, Throwable throwable) {
        this.log(3, string, throwable);
    }

    public void info(String string) {
        this.log(2, string, null);
    }

    public void info(String string, Throwable throwable) {
        this.log(2, string, throwable);
    }

    public void debug(String string) {
        this.log(1, string, null);
    }

    public void debug(String string, Throwable throwable) {
        this.log(1, string, throwable);
    }

    public void log(int n, String string, Throwable throwable) {
        if (n < this.severity) {
            return;
        }
        this.out.println("[" + Abstime.now() + "] [" + Log.severityToString(n) + "] [" + this.name + "] " + string);
        if (throwable != null) {
            throwable.printStackTrace(this.out);
        }
    }
}

