/*
 * Decompiled with CFR 0.152.
 */
package sedona.sox;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import sedona.Buf;

public abstract class SoxFile {
    public static SoxFile make(File file) {
        return new LocalFile(file);
    }

    public static SoxFile make(Buf buf) {
        return new MemoryFile(buf);
    }

    public abstract int size();

    public abstract void open(String var1) throws IOException;

    public abstract void read(int var1, Buf var2, int var3) throws IOException;

    public abstract void write(int var1, Buf var2, int var3) throws IOException;

    public abstract void close();

    static class MemoryFile
    extends SoxFile {
        Buf b;

        public MemoryFile(Buf buf) {
            this.b = buf;
        }

        @Override
        public void close() {
        }

        @Override
        public int size() {
            return this.b.size;
        }

        @Override
        public void open(String string) throws IOException {
            if (string.indexOf(119) >= 0) {
                this.b.clear();
            }
            this.b.seek(0);
        }

        @Override
        public void read(int n, Buf buf, int n2) throws IOException {
            this.b.writeTo(buf.getOutputStream(), n, n2);
        }

        @Override
        public void write(int n, Buf buf, int n2) throws IOException {
            this.b.seek(n);
            this.b.readFrom(buf.getInputStream(), n2);
        }
    }

    static class LocalFile
    extends SoxFile {
        File file;
        RandomAccessFile fp;

        LocalFile(File file) {
            this.file = file;
        }

        @Override
        public int size() {
            return (int)this.file.length();
        }

        @Override
        public void open(String string) throws IOException {
            if (string.equals("w")) {
                string = "rw";
            }
            this.fp = new RandomAccessFile(this.file, string);
            if (string.indexOf(119) >= 0) {
                this.fp.setLength(0L);
            }
        }

        @Override
        public void read(int n, Buf buf, int n2) throws IOException {
            this.fp.seek(n);
            buf.readFrom(this.fp, n2);
        }

        @Override
        public void write(int n, Buf buf, int n2) throws IOException {
            this.fp.seek(n);
            buf.writeTo(this.fp, n2);
        }

        @Override
        public void close() {
            try {
                this.fp.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.fp = null;
        }
    }
}

