/*
 * Decompiled with CFR 0.152.
 */
package sedona.sox;

import java.io.File;
import java.net.InetAddress;
import sedona.dasp.DaspSocket;
import sedona.sox.SoxClient;
import sedona.sox.SoxFile;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 4) {
            Main.usage();
            return;
        }
        String string = stringArray[0];
        int n = 1876;
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3].toLowerCase();
        String[] stringArray2 = new String[stringArray.length - 4];
        System.arraycopy(stringArray, 4, stringArray2, 0, stringArray.length - 4);
        int n2 = string.indexOf(58);
        if (n2 > 0) {
            n = Integer.parseInt(string.substring(n2 + 1));
            string = string.substring(0, n2);
        }
        DaspSocket daspSocket = DaspSocket.open(-1, null, 14);
        SoxClient soxClient = new SoxClient(daspSocket, InetAddress.getByName(string), n, string2, string3);
        try {
            Main.println("Connecting...");
            soxClient.connect();
            Main.println("Connected.");
            Main.command(soxClient, string4, stringArray2);
        }
        catch (Exception exception) {
            Main.println("Connection failed: " + exception);
            exception.printStackTrace();
        }
        finally {
            try {
                soxClient.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void usage() {
        Main.println();
        Main.println("usage:");
        Main.println("  soxclient <host>[:<port>] <user> <pass> <command>");
        Main.println("commands:");
        Main.println("  version     Print installed kit versions");
        Main.println("  get <file>  Tranfer a file from the device");
        Main.println("  put <file>  Tranfer a file to the device");
        Main.println();
    }

    public static int command(SoxClient soxClient, String string, String[] stringArray) throws Exception {
        if (string.equals("version")) {
            return Main.version(soxClient, stringArray);
        }
        if (string.equals("get")) {
            return Main.get(soxClient, stringArray);
        }
        if (string.equals("put")) {
            return Main.put(soxClient, stringArray);
        }
        Main.println("Unknown command '" + string + "'");
        return 1;
    }

    public static int version(SoxClient soxClient, String[] stringArray) throws Exception {
        soxClient.readVersion().dump();
        return 0;
    }

    public static int get(SoxClient soxClient, String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            Main.usage();
            return 1;
        }
        Main.println("TODO GET " + stringArray[0]);
        return 0;
    }

    public static int put(SoxClient soxClient, String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            Main.usage();
            return 1;
        }
        File file = new File(stringArray[0]);
        if (!file.exists()) {
            Main.println("File does not exist: " + file);
            return 1;
        }
        Main.println("Put " + file + "...");
        soxClient.putFile(file.getName(), SoxFile.make(file), null, null);
        Main.println("Complete.");
        return 0;
    }

    public static void println() {
        System.out.println();
    }

    public static void println(String string) {
        System.out.println(string);
    }

    static class Progress
    implements SoxClient.TransferListener {
        Progress() {
        }

        @Override
        public void progress(int n, int n2) {
            double d = (double)n / (double)n2 * 100.0;
            System.out.println("  " + (int)d + "% [" + n + " of " + n2 + "]");
        }
    }
}

