/*
 * Decompiled with CFR 0.152.
 */
package sedona.manifest;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sedona.Depend;
import sedona.Env;
import sedona.KitPart;
import sedona.kit.KitDb;
import sedona.kit.KitFile;
import sedona.manifest.KitManifest;
import sedona.util.Log;
import sedona.util.sedonadev.Download;
import sedona.xml.XParser;
import sedona.xml.XWriter;

public class ManifestDb {
    public static final File dir = new File(Env.home, "manifests");
    public static final Log log = new Log("manifestdb");
    private static HashMap cache = new HashMap();

    public static KitManifest loadForLocalKit(String string) throws Exception {
        KitManifest kitManifest = (KitManifest)cache.get(ManifestDb.toLocalKey(string));
        if (kitManifest != null) {
            return kitManifest;
        }
        return ManifestDb.loadFromLocalKit(new Info(string, -1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KitManifest load(KitPart kitPart) throws Exception {
        HashMap hashMap = cache;
        synchronized (hashMap) {
            Info info = new Info(kitPart.name, kitPart.checksum);
            KitManifest kitManifest = (KitManifest)cache.get(info.key);
            if (kitManifest != null) {
                return kitManifest;
            }
            kitManifest = ManifestDb.loadFromDb(info);
            if (kitManifest != null) {
                return kitManifest;
            }
            kitManifest = ManifestDb.loadFromLocalKit(info);
            if (kitManifest != null) {
                return kitManifest;
            }
            kitManifest = Download.fetchManifest(kitPart);
            if (kitManifest != null) {
                ManifestDb.save(kitManifest);
                return kitManifest;
            }
            return null;
        }
    }

    private static KitManifest loadFromDb(Info info) throws Exception {
        if (!info.file.exists()) {
            return null;
        }
        log.debug("ManifestDb: Load [" + info.file + "]");
        KitManifest kitManifest = new KitManifest(info.name);
        kitManifest.decodeXml(XParser.make(info.file).parse());
        if (kitManifest.checksum != info.checksum) {
            throw new Exception("Mismatched checksum: " + info.file);
        }
        cache.put(info.key, kitManifest);
        return kitManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KitManifest loadFromLocalKit(Info info) throws Exception {
        KitFile kitFile;
        KitFile kitFile2 = kitFile = info.checksum == -1 ? KitDb.matchBest(info.name) : KitDb.matchBest(Depend.makeChecksum(info.name, info.checksum));
        if (kitFile == null) {
            return null;
        }
        ZipFile zipFile = new ZipFile(kitFile.file);
        KitManifest kitManifest = new KitManifest(info.name);
        try {
            ZipEntry zipEntry = zipFile.getEntry("manifest.xml");
            if (zipEntry == null) {
                throw new Exception("Missing 'manifest.xml' manifest in " + info.file);
            }
            kitManifest.decodeXml(XParser.make(kitFile.toString(), zipFile.getInputStream(zipEntry)).parse());
        }
        finally {
            zipFile.close();
        }
        if (info.checksum == -1) {
            info = new Info(info.name, kitManifest.checksum);
        }
        if (kitManifest.checksum != info.checksum) {
            log.debug("Local kit not match [" + kitFile + "]");
            return null;
        }
        log.debug("Local kit is match [" + kitFile + "]");
        cache.put(info.key, kitManifest);
        cache.put(ManifestDb.toLocalKey(info.name), kitManifest);
        if (!info.file.exists()) {
            ManifestDb.save(kitManifest);
        }
        return kitManifest;
    }

    public static String[] listInstalledKits() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = dir.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            arrayList.add(fileArray[i].getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static KitPart[] listInstalledParts(String string) {
        ArrayList<KitPart> arrayList = new ArrayList<KitPart>();
        File[] fileArray = new File(dir, string).listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            File file = fileArray[i];
            String string2 = file.getName();
            if (!string2.endsWith(".xml")) continue;
            try {
                arrayList.add(KitPart.parse(string2.substring(0, string2.length() - 4)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList.toArray(new KitPart[arrayList.size()]);
    }

    public static File toFile(KitPart kitPart) {
        return new File(dir, kitPart.name + File.separator + kitPart.toString() + ".xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(KitManifest kitManifest) {
        Info info = new Info(kitManifest);
        try {
            info.file.getParentFile().mkdirs();
            XWriter xWriter = new XWriter(info.file);
            log.debug("Save [" + info.file + "]");
            try {
                kitManifest.encodeXml(xWriter);
            }
            finally {
                xWriter.close();
            }
            return true;
        }
        catch (Exception exception) {
            log.error("ManifestDb: Cannot save manifest back to disk [" + info.file + "]", exception);
            return false;
        }
    }

    static String toLocalKey(String string) {
        return string + "-local";
    }

    static class Info
    extends KitPart {
        final File file;

        Info(String string, int n) {
            super(string, n);
            this.file = new File(dir, string + File.separator + this.key + ".xml");
        }

        Info(KitManifest kitManifest) {
            this(kitManifest.name, kitManifest.checksum);
        }
    }
}

