/*
 * Decompiled with CFR 0.152.
 */
package sedona.dasp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import sedona.dasp.DaspMessage;
import sedona.dasp.DaspSession;
import sedona.dasp.DaspSocket;

public abstract class DaspSocketInterface {
    Receiver receiver;
    HouseKeeping houseKeeping;
    DaspSocket daspSocket;
    DatagramPacket sendPacket = new DatagramPacket(new byte[1024], 1024);
    int numSent;
    int numReceived;
    int numRetries;

    public final DaspSocket daspSocket() {
        return this.daspSocket;
    }

    public abstract boolean routes(InetAddress var1, int var2);

    public abstract void send(DatagramPacket var1) throws IOException;

    protected abstract void receive(DatagramPacket var1) throws IOException;

    public abstract void close() throws IOException;

    void start(DaspSocket daspSocket) {
        this.daspSocket = daspSocket;
        this.receiver = new Receiver();
        this.receiver.start();
        this.houseKeeping = new HouseKeeping();
        this.houseKeeping.start();
    }

    void stop() {
        try {
            this.receiver.interrupt();
            this.receiver = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.houseKeeping.interrupt();
            this.houseKeeping = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int numSent() {
        return this.numSent;
    }

    public int numReceived() {
        return this.numReceived;
    }

    public int numRetries() {
        return this.numRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(DaspSession daspSession, DaspMessage daspMessage) {
        DatagramPacket datagramPacket = this.sendPacket;
        synchronized (datagramPacket) {
            try {
                this.sendPacket.setAddress(daspSession.host);
                this.sendPacket.setPort(daspSession.port);
                this.sendPacket.setLength(daspMessage.encode(this.sendPacket.getData()));
                this.send(this.sendPacket);
            }
            catch (IOException iOException) {
                System.out.println("ERROR: DaspSocket error on send - " + iOException.getMessage());
                daspSession.shutdown(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
    }

    class HouseKeeping
    extends Thread {
        HouseKeeping() {
            super("DaspSocket.HouseKeeping");
        }

        @Override
        public void run() {
            while (DaspSocketInterface.this.daspSocket.isAlive) {
                try {
                    long l = System.currentTimeMillis();
                    DaspSession[] daspSessionArray = DaspSocketInterface.this.daspSocket.sessions();
                    for (int i = 0; i < daspSessionArray.length; ++i) {
                        try {
                            DaspSession daspSession = daspSessionArray[i];
                            if (daspSession.iface != DaspSocketInterface.this) continue;
                            daspSessionArray[i].houseKeeping();
                            continue;
                        }
                        catch (Throwable throwable) {
                            if (!DaspSocketInterface.this.daspSocket.isAlive) continue;
                            throwable.printStackTrace();
                        }
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = 100L - (l2 - l);
                    if (l3 <= 5L) continue;
                    Thread.sleep(l3);
                }
                catch (Throwable throwable) {
                    if (!DaspSocketInterface.this.daspSocket.isAlive) continue;
                    throwable.printStackTrace();
                }
            }
        }
    }

    class Receiver
    extends Thread {
        Receiver() {
            super("DaspSocketInterface.Receiver");
        }

        @Override
        public void run() {
            byte[] byArray = new byte[1024];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            while (DaspSocketInterface.this.daspSocket.isAlive) {
                try {
                    datagramPacket.setLength(byArray.length);
                    DaspSocketInterface.this.receive(datagramPacket);
                    DaspSocketInterface.this.daspSocket.dispatch(DaspSocketInterface.this, datagramPacket);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (Throwable throwable) {
                    if (!DaspSocketInterface.this.daspSocket.isAlive) continue;
                    throwable.printStackTrace();
                }
            }
        }
    }
}

