/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.io.IOException;
import sedona.Buf;
import sedona.Value;

public final class Bool
extends Value {
    public static final Bool TRUE = new Bool(true);
    public static final Bool FALSE = new Bool(false);
    public static final Bool NULL = new Bool(true);
    public final boolean val;

    public static Bool make(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    private Bool(boolean bl) {
        this.val = bl;
    }

    @Override
    public boolean isNull() {
        return this == NULL;
    }

    @Override
    public int typeId() {
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public String encodeString() {
        if (this.isNull()) {
            return "null";
        }
        return this.val ? "true" : "false";
    }

    @Override
    public Value decodeString(String string) {
        if (string.equals("true")) {
            return TRUE;
        }
        if (string.equals("false")) {
            return FALSE;
        }
        if (string.equals("null")) {
            return NULL;
        }
        if (string.equals("nullbool")) {
            return NULL;
        }
        throw new IllegalArgumentException("Invalid Bool syntax: " + string);
    }

    @Override
    public void encodeBinary(Buf buf) {
        if (this.isNull()) {
            buf.u1(2);
        } else {
            buf.u1(this.val ? 1 : 0);
        }
    }

    @Override
    public Value decodeBinary(Buf buf) throws IOException {
        int n = buf.u1();
        if (n == 2) {
            return NULL;
        }
        if (n == 0) {
            return FALSE;
        }
        return TRUE;
    }
}

