<?php 

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');
include_once "base_controller.php";

class SystemConfig extends BaseController {
  protected function signinRequired() {
    return true;
  }

  protected function featureId() {
    return basename(__DIR__);
  }
}

$controller = new SystemConfig();
$controller->run();

?>

<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8" />
    <title><?php $controller->echoPageTitle("Change System Password") ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="<?php A('../../css/bootstrap.min.css') ?>" media="screen" />
    <style type="text/css" media="screen">
      [v-cloak] {
        display: none;
      }
      #change_passwd_panel {
        margin-top: 20px;
      }
    </style>

    <?php $controller->faviconHTMLInfo() ?>
  </head>
  <body>
    <div class="container" id="system_config_content">
      <div class="row" style="margin-top:40px">
        <h1 style="font-family:arial, helvetica, sans-serif; font-size:300%; text-align:center; width:100%;">
          <a id="home_nav_btn" href="<?php echo $controller->utilityUrl() ?>" style="text-decoration:none">
            <?php echo $controller->utilityLabel() ?>: Change OS Account(sdcard) Password
          </a>
        </h1>
      </div> 

      <div id="change_passwd_panel" class="row" v-cloak>
        <div class="alert" :class="[this.success ? 'alert-success' : 'alert-error', {hide: this.msg.length == 0}]"><h4>{{ this.msg }}</h4></div>
        <form class="form-horizontal" autocomplete="nope" v-on:submit.prevent="onSubmit" >
          <div class="control-group" :class="{error: this.error_old != null}">
            <label class="control-label" for="inputOldPass">Old Password:</label>
            <div class="controls">
              <input type="password" id="inputOldPass" v-model.trim="old_passwd" password minlength=6 maxlength=32 @input="validateOldPasswd">
              <span class='help-inline' :class="{hide: this.error_old == null}">{{ this.error_old }}</span>
            </div>
          </div>
          <div class="control-group" :class="{error: this.error_new != null}">
            <label class="control-label" for="inputNewPass">New Password:</label>
            <div class="controls">
              <input type="password" id="inputNewPass" v-model.trim="new_passwd" password minlength=12 maxlength=32 @input="validateNewPasswd(true)">

              <span class='help-inline' :class='{hide: this.error_new == null}'>{{ this.error_new }}</span>
            </div>
          </div>
          <div class="control-group" :class="{error: this.error_new2 != null}">
            <label class="control-label" for="inputNewPass2">Confirm Password:</label>
            <div class="controls">
              <input type="password" id="inputNewPass2" v-model.trim="new_passwd2" password minlength=12 maxlength=32 @input="validateNewPasswd(false)">
              <span class='help-inline' :class='{hide: this.error_new2 == null}'>{{ this.error_new2 }}</span>
            </div>
          </div>

          <div class="control-group">
            <div class="controls">
              <input class="btn btn-primary" type="submit" value="Change">
            </div>
          </div>
          
        </form>
      </div>
    </div>

    <script type="text/javascript" src="<?php A('../../js/jquery-1.10.0.min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/spin.min.js') ?>"></script>

<?php
  if (isset($_GET["dev"])) {
?>
    <script type="text/javascript" src="<?php A('../../js/vue.js') ?>"></script>
<?php
  } else {
?>
    <script type="text/javascript" src="<?php A('../../js/vue.min.js') ?>"></script>
<?php
  }
?>

    <script language="javascript" type="text/javascript">
      "use strict";
      var app = new Vue({
        el: '#change_passwd_panel',
        data: {
          old_passwd: "",
          new_passwd: "",
          new_passwd2: "",

          error_old: null,
          error_new: null,
          error_new2: null,
          
          msg: "",
          success: true
        },
        methods: {
          validateOldPasswd: function() {
            if (this.old_passwd.length == 0)
              this.error_old = "password can not be empty"
            else if (this.old_passwd.length < 6)
              this.error_old = "password is too short"
            else if (this.old_passwd.length > 32)
              this.error_old = "password is too long"
            else 
              this.error_old = null
          },
          validateNewPasswd: function(password1) {
            if (password1) 
              this.error_new = this.validateInput(this.new_passwd) 
            else
              this.error_new2 = this.validateInput(this.new_passwd2)
          },
          validateInputs: function() {
            this.validateOldPasswd()
            this.validateNewPasswd(true)
            this.validateNewPasswd(false)

            if (this.error_new == null && this.error_new2 == null) {
              if (this.new_passwd != this.new_passwd2) {
                this.error_new = "new passwords must be the same"
                this.error_new2 = "new passwords must be the same"
              }
            }
          },
          validateInput: function(val) {
            if (val.length == 0)
              return "password can not be empty"

            if (!/^[!-~]{12,32}$/.test(val))
              return "password's length must between 12-32 characters"

            // must include lowercase character
            if (!/[a-z]/.test(val))
              return "password must include lowercase characters"
            
            // must include uppercase character
            if (!/[A-Z]/.test(val))
              return "password must include uppercase characters"
            
            // must include number
            if (!/[0-9]/.test(val))
              return "password must include number characters"

            // must include punctuation 
            if (!/[!-/:-@^-`{-~]/.test(val))
              return "password must include punctuation characters"

            return null
          },
          isAllInputsOk: function() {
            return this.error_old == null && this.error_new == null && this.error_new2 == null
          },
          onSubmit: function(event) {
            this.validateInputs()
            if (!this.isAllInputsOk()) {
              console.debug("invalid inputs")
              return false
            } 

            var self = this
            $.ajax({
              url: '../../app/os_account_management.php',
              type: 'POST',
              dataType: 'json',
              data: {
                action: 'changePasswd',
                account: {
                  old_password: self.old_passwd,
                  new_password: self.new_passwd
                }
              },
              beforeSend: function() {
                if (self.spinner == null)
                  self.spinner = new Spinner()
                self.spinner.spin(self.$el)
              },
              success: function(data) {
                if (data.error) {
                  self.success = false
                  self.msg = data.error.text
                } else {
                  self.success = true
                  self.msg = "Password is changed successfully."
                }
              },
              complete: function() {
                self.spinner.stop()
              }
            })
          },
        }
      });

      window.in_iframe = window !== window.parent;
      if (window.in_iframe) {
        let elem = document.getElementById("home_nav_btn");
        if(elem) elem.setAttribute("href", "#");
      }
    </script>

  </body>
</html>
