<?php 
//vim: ts=2 sw=2

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');
include_once "service_utils.php";
include_once "base_controller.php";

class ServiceControlController extends BaseController {

  function __construct() {
    $this->utils = new ServiceUtils();
  }

  protected function signinRequired() {
    return true;
  }

  protected function featureId() {
    return basename(__DIR__);
  }

  protected function doAjaxGet() {
    $response = array('services' => $this->utils->collectServicesStatus());
    $this->renderAjaxSuccess2($response);
  }

  protected function doAjaxPost() {
    $response = array();

    if (!isset($_POST['name']) || !isset($_POST['action'])) {
      $this->renderAjaxError($response, "missing parameter");
      return;
    }

    $name = $_POST['name'];
    $action = $_POST['action'];

    $error = $this->utils->doAction($name, $action);
    if (is_null($error))
      $this->renderAjaxSuccess(array('resultCode' => 0));
    else
      $this->renderAjaxError($response, $error);
  }

}

$controller = new ServiceControlController();
$controller->run();

?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8" />
    <title><?php $controller->echoPageTitle("Service Control") ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="<?php A('../../css/bootstrap.min.css') ?>" media="screen" />
    <?php $controller->faviconHTMLInfo() ?>
  </head>
  <body>
    <div class="container" id="service_control_content">
      <div class="navbar">
        <div class="navbar-inner">
          <a id="home_nav_btn" class="brand" href="<?php echo $controller->utilityUrl() ?>"><?php echo $controller->utilityLabel() ?></a>
          <!-- <ul class="nav"> -->
          <!--   <li class="divider&#45;vertical"></li> -->
          <!--   <li v&#45;for="sec in sections" :class="{active:isSectionActive(sec)}"><a href="#" @click="active_sec_id=sec.sec_id">{{ sec.name }}</a></li> -->
          <!-- </ul> -->
        </div>
      </div>

      <div class="row">
        <div><h2 style="text-align:center">Service Control Panel</h2></div>
        <service-control></service-control>
      </div>
    </div>

    <!-- component templates -->
    <script type="text/x-template" id="service-control-template">
      <div class="span12">
        <table class="table table-striped table-hover">
          <thead>
            <tr>
              <th>Name</th>
              <th>Status</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            <tr v-for="service in service_list" :class="{warning:!service.enabled}">
              <td>{{ service.label }}</td>
              <td><span class="label" :class="[service.enabled ? 'label-success' : 'label-warning',]">{{ service.enabled ? "Enabled" : "Disabled" }}</span></td>
              <td>
                <button class="btn" :class="{'btn-danger':service.enabled, 'disabled':!isServiceControllable(service)}" :disabled="!isServiceControllable(service)" @click="service.enabled ? disableService(service.name) : enableService(service.name)"> 
                  {{ service.enabled ? "Disable" : "Enable" }}
                </button>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </script>

    <script type="text/javascript" src="<?php A('../../js/jquery-1.10.0.min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/bootstrap.min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/underscore-min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/spin.min.js') ?>"></script>

<?php
  if (isset($_GET["dev"])) {
?>
    <script type="text/javascript" src="<?php A('../../js/vue.js') ?>"></script>
<?php
  } else {
?>
    <script type="text/javascript" src="<?php A('../../js/vue.min.js') ?>"></script>
<?php
  }
?>
    <script type="text/javascript" src="<?php A('../../js/plugin-utils.js') ?>"></script>
    <script type="text/javascript" src="<?php A('js/service_control.js') ?>"></script>

    <script language="javascript" type="text/javascript">
      "use strict";
      window.in_iframe = window !== window.parent;
      if (window.in_iframe) {
        let elem = document.getElementById("home_nav_btn");
        if(elem) elem.setAttribute("href", "#");
      }
    </script>
  </body>
</html>
