<?php 

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');
include_once "base_controller.php";
include_once "service_utils.php";
include_once "utils.php";

include_once "./funcs.php";

class OpenVPNCloudController extends BaseController {
  protected function signinRequired() {
    return true;
  }

  protected function adminRequired() {
    return true;
  }

  protected function featureId() {
    return basename(__DIR__);
  }

  public function doAjaxGet() {
    $response = array();
    if (!isset($_GET['action']))
      $this->renderAjaxError($response, "'action' parameter is missing");
    
    $action = $_GET['action'];
    if ($action == 'fetchResult')
      $this->fetchTestResult();
    else if ($action == "fetchConnStatus")
      $this->fetchConnStatus();
    else
      $this->renderAjaxError($response, "'action' parameter is invalid");
  }
  public function doAjaxPost() {
    $response = array();
    if (!isset($_POST['action']))
      $this->renderAjaxError($response, "'action' parameter is missing");

    $action = $_POST['action'];
    if ($action == 'saveConfig')
      $this->saveConfig();
    else if ($action == 'testConn')
      $this->testConnection();
    else
      $this->renderAjaxError($response, "'action' parameter is invalid");
  }

  protected function saveConfig() {
    $response = array();

    if (!isset($_FILES['ovpnFile'])) {
      $this->renderAjaxError($response, L(".ovpn file is missing"));
    }
    $file = $_FILES['ovpnFile'];
    $tempPath = $file['tmp_name'];
    $fileSize = filesize($tempPath);
    if ($fileSize == 0) {
      $this->renderAjaxError($response, L(".ovpn file's content is invalid"));
    }

    $dstPath = "/etc/openvpn/cloud.ovpn";
    $dstDisabledPath = "/etc/openvpn/cloud.ovpn.disabled";
    $disabled = !file_exists($dstPath) && file_exists($dstDisabledPath);
    if ($disabled)
      $dstPath = $dstDisabledPath;
    if (!move_uploaded_file($tempPath, $dstPath)) {
      $this->renderAjaxError($response, "failed to save .ovpn file");
    }

    if (empty(glob("/etc/init.d/S??openvpn_client"))) {
      $response['msg'] = L("Config saved successfully and but will ONLY take effect when OpenVPN Cloud client is enabled");
    } else {
      `/etc/init.d/S??openvpn_client restart`;
    }
    $response['info'] = openVPNCloudProfileInfo($dstPath);
    $this->renderAjaxSuccess2($response);
  }

  protected function testConnection() {
    $response = array();
    $utils = new ServiceUtils();
    $name = "openvpn_client";
    if (!$utils->isServiceEnabled($name))
      $utils->doAction($name, "enable");

    `nohup /etc/init.d/S??openvpn_client conn-test cloud >/dev/null 2>&1 &`;
    $this->renderAjaxSuccess2($response);
  }

  protected function fetchTestResult() {
    if (isset($_GET['disableService'])) {
      $utils = new ServiceUtils();
      $name = "openvpn_client";
      $utils->doAction($name, "disable");
    }

    $response = array();
    $file_path = "/var/log/openvpn-cloud-conntest.log";
    if (!file_exists($file_path))
      $this->renderAjaxError($response, L("can not find connection test result"));

    $content = file_get_contents($file_path);
    $response['logs'] = explode("\n", $content);
    $this->renderAjaxSuccess2($response);
  }

  protected function fetchConnStatus() {
    $response = array();
    $utils = new ServiceUtils();

    $response["vpn_enabled"] = $utils->isServiceEnabled("openvpn_client");
    if (!$response["vpn_enabled"])
      $this->renderAjaxSuccess2($response);

    $output = null;
    $result = null;
    $cmd = 'ping -c 2 $(ip route | awk \'/tun0/{print $3; exit}\')';
    exec($cmd, $output, $result);
    if ($result == 0)
      $response["status"] = "CONNECTED";
    else
      $response["status"] = "NOT_CONNECTED";
    $this->renderAjaxSuccess2($response);
  }

  protected function configVPN($ip, $netmaskNum) {
    //NOTE: another IP address required when the current device IP is not able
    //to access internet, it lives in a controller sub-network, isolated from
    //internet for security reason. So connect to OpenVPN Cloud, an extra IP
    //address will be required. 
    //
    //For now, we ignore this case and consuming device's current IP is able to
    //connect to internet. If in future we allow user to add an extra IP
    //address, the Network Manager probably the right place to set it up
    $response = array();
    $script_path = "/etc/openvpn/cloud_ip_config.sh";
    file_put_contents($script_path, <<<EOS
#! /bin/sh 
if [ $1 = "init" ] ; then 
  nmcli con mod wired-eth0 +ipv4.addresses $ip/$netmaskNum
else 
  nmcli con mod wired-eth0 -ipv4.addresses $ip/$netmaskNum
fi 
EOS);

    $this->renderAjaxSuccess2($response);
  }
}

$controller = new OpenVPNCloudController();
$controller->run();

?>
