<?php

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');

function openVPNCloudProfileInfo($profilePath) {
  $info = array();

  $ovpnCloudProfilePath = is_null($profilePath) ? "/etc/openvpn/cloud.ovpn" : $profilePath;
  if (!file_exists($ovpnCloudProfilePath))
    return $info;

  $output = `head -n 10 $ovpnCloudProfilePath | awk '/# OVPN/{print $2}'`;
  if (is_null($output))
    return $info;

  $lines = explode("\n", $output);
  foreach($lines as $line) {
    $parts = explode("=", $line);
    if (count($parts) != 2)
      continue;
    if ($parts[0] == "OVPN_FRIENDLY_PROFILE_NAME") 
      $info["profileName"] = $parts[1];
  } 
  return $info;
}

?>
