client
dev tun
proto <?php echo isset($args['proto']) ? $args['proto'] : 'udp'; ?> 

remote <?php echo isset($args['remote']) ? $args['remote'] : '192.168.1.128  1194'; ?> 

resolv-retry infinite
nobind

persist-key
persist-tun

# from OpenVPN 2.4, 'ns-cert-type' is deprecated, use 'remote-cert-tls' instead
;ns-cert-type server
remote-cert-tls server

key-direction 1

cipher AES-128-CBC
auth SHA256

comp-lzo
verb 3

<?php 

if (file_exists("/etc/openvpn/pki/ca.crt")) {
  echo "<ca>\n";
  echo file_get_contents("/etc/openvpn/pki/ca.crt");
  echo "</ca>\n";
}

?>

<?php 

if (isset($args['cn'])) {
  $certFile = "/etc/openvpn/pki/issued/" . $args['cn'] . ".crt";
  if (file_exists($certFile)) {
    echo "<cert>\n";
    $content = file_get_contents($certFile);
    $lines = explode(PHP_EOL, $content);
    $outputEnabled = false;
    foreach($lines as $line) {
      if (strpos($line, '-----BEGIN CERTIFICATE-----') === 0)
        $outputEnabled = true;

      if ($outputEnabled)
        echo $line . "\n";

      if (strpos($line, '-----END CERTIFICATE-----') === 0)
        $outputEnabled = false;
    }
    echo "</cert>\n";
  }

  echo "\n";

  $keyFile = "/etc/openvpn/pki/private/" . $args['cn'] . ".key";
  if (file_exists($keyFile)) {
    echo "<key>\n";
    echo file_get_contents($keyFile);
    echo "</key>\n";
  }
}

?>

<?php 
if (file_exists("/etc/openvpn/ta.key")) {
  echo "<tls-auth>\n";
  echo file_get_contents("/etc/openvpn/ta.key");
  echo "</tls-auth>\n";
}
?>
