<?php

class LogoUtility {

  public function backup($pluginsBackupDir) {
    if (!file_exists($pluginsBackupDir))
      return false;
    
    $pluginDir = __DIR__;
    $pluginDirName = basename($pluginDir);
    $pluginBackupDir = build_file_path($pluginsBackupDir, $pluginDirName);
    if (!file_exists($pluginBackupDir))
      mkdir($pluginBackupDir, 0777, TRUE);

    $logoBaseName = isOEM() ? "login-logo-slc" : "login-logo";

    $files = array();
    $files[] = build_file_path(imgPath(), $logoBaseName . ".png");
    foreach($files as $file) {
      if (!file_exists($file))
        continue;
      
      $dstPath = build_file_path($pluginBackupDir, basename($file));
      if (!recurseCopy($file, $dstPath)) {
        error_log("failed to backup " . $file . " to " . $dstPath);
        return false;
      }
    }
    return true;
  }

  public function restore() {
    $logoBaseName = isOEM() ? "login-logo-slc" : "login-logo";
    $logoFile = build_file_path(__DIR__, $logoBaseName . ".png");
    if (!file_exists($logoFile))
      return false;

    $dstPath = build_file_path(imgPath(), $logoBaseName . ".png");
    if (!recurseCopy($logoFile, $dstPath)) {
      error_log("failed to restore " . $logoFile . " to " . $dstPath);
      return false;
    }

    if (file_exists($logoFile))
      unlink($logoFile);

    return true;
  }
}

return new LogoUtility();

?>
