<?php 

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');
include_once "base_controller.php";

class LogoConfig extends BaseController {
  protected function signinRequired() {
    return true;
  }

  protected function featureId() {
    return basename(__DIR__);
  }

  protected function doAjaxPost() { 
    $response = array();
    $imgPath = imgPath();
    $logoBaseName = isOEM() ? "login-logo-slc" : "login-logo";
    $origLogo = build_file_path($imgPath, $logoBaseName . ".png.orig");
    if (!file_exists($origLogo))
      $this->renderAjaxError($response, "can not find original logo image");

    $logoPath = build_file_path($imgPath, $logoBaseName . ".png");
    rename($origLogo, $logoPath);
    $this->renderAjaxSuccess($response);
  }
}

$controller = new LogoConfig();
$controller->run();

?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8" />
    <title><?php $controller->echoPageTitle("Change Logo Image") ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="<?php A('../../css/bootstrap.min.css') ?>" media="screen" />
    <link rel="stylesheet" href="<?php A('../../css/dropzone.css') ?>" media="screen" />
    <link rel="stylesheet" href="<?php A('css/logo_config.css') ?>" media="screen" />
    <?php $controller->faviconHTMLInfo() ?>
  </head>
  <body>
    <div class="container" id="logo_config_content">
      <div class="row" style="margin-top:40px">
        <h1 style="font-family:arial, helvetica, sans-serif; font-size:300%; text-align:center; width:100%;">
          <a id="home_nav_btn" href="<?php echo $controller->utilityUrl() ?>" style="text-decoration:none">
            <?php echo $controller->utilityLabel() ?>: Change Logo Image
          </a>
        </h1>
      </div> 
      <div class="row" style="margin-top: 30px">
        <form action="file_upload.php" class="dropzone" id="logo_img_dropzone"></form>
      </div>
      <div class="row" style="margin-bottom: 15px">
        <a id="restore_btn" href="" class="btn btn-warning pull-right">Restore Original Logo</a>
      </div>
      <div class="row alert">
        <!-- <button type="button" class="close" data-dismiss="alert">&times;</button> -->
        <strong>NOTE:</strong> You need to signout to view the effect. <a href="../../app/signout.php">signout</a> now. If it still shows the old logo, then you need to do a <a href="https://en.wikipedia.org/wiki/Wikipedia:Bypass_your_cache" target="_blank">force reload</a> to update browser's cache. 
      </div>
    </div>

    <script type="text/javascript" src="<?php A('../../js/jquery-1.10.0.min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/spin.min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/dropzone.min.js') ?>"></script>

    <script language="javascript" type="text/javascript">
      "use strict";
      Dropzone.autoDiscover = false;
      let lastFile = null;
      $(function() {
        var logoDropzone = new Dropzone("#logo_img_dropzone", {
          url: 'file_upload.php',
          paramName: "file",
          maxFilesize: 2, //MB  
          clickable: true,
          acceptedFiles: "image/*", 
          dictDefaultMessage: "Drop logo image file here",
        });

        logoDropzone.on("success", function(file, respText) {
          let resp = JSON.parse(respText);
          if (resp.redirect != null)
            window.location.href = resp.redirect;
        }).on("uploadprogress", function(file, progress) {
          if (progress < 100)
            return;

          if (lastFile)
            this.removeFile(lastFile);
          lastFile = file;
        });

        var spinner = new Spinner();
        $("#restore_btn").on("click", function(e) {
          $.ajax({
            url: "logo_config.php",
            method: "POST",
            dataType: "json",
            beforeSend: function(xhr) {
              spinner.spin(document.body);
              $("#restore_btn").addClass("disabled");
            },
            success: function(data, status, xhr) { 
              if (data.redirect != null)
                window.location.href = data.redirect;
              else
                if (data.error != null)
                  alert("Failed to restore logo: " + data.error.text);
            },
            complete: function() {
              spinner.stop();
              $("#restore_btn").removeClass("disabled");
            }
          });

          e.preventDefault();
        });
      });

      window.in_iframe = window !== window.parent;
      if (window.in_iframe) {
        let elem = document.getElementById("home_nav_btn");
        if(elem) elem.setAttribute("href", "#");
      }
    </script>

  </body>
</html>
