"use strict";
$(function() {

  let progressUIMixin = { //{{{1
    data: function() {
      return {spinner: null};
    },
    methods: {
      getSpinner: function() {
        if (!this.spinner)
          this.spinner = new Spinner();
        return this.spinner;
      },
    },
  }; //}}}1

  let newTrafficCaptureComp = { //{{{1
    mixins: [progressUIMixin],
    template: '#new_traffic_capture_template',
    data: function() {
      return {
        interface: "eth0",
        filter: "",
        timeLength: 3600,
        count: 4,

        filterError: false,
        timeLengthError: false,
        countError: false,
      };
    },
    methods: {
      validateInput: function() {
        this.filterError = this.filter.length == 0 || this.filter.length > 256;
        this.timeLengthError = this.timeLength <= 0 || this.timeLength > 1296000;
        this.countError = this.count == 0 || this.count > 256;

        return !this.filterError && !this.timeLengthError && !this.countError;
      },

      save: function() {
        if (!this.validateInput())
          return;

        let self = this;
        $.ajax({
          url: "diagnose_utility.php",
          type: "POST",
          dataType: "json",
          data: {
            action: "startCapture",
            interface: this.interface,
            filter: this.filter,
            timeLength: this.timeLength,
            count: this.count,
          },
          beforeSend: function() {
            self.getSpinner().spin(self.$el);
          },
          success: function(resp) {
            if (resp.redirect) {
              window.location.href = resp.redirect;
              return;
            }
            if (resp.error) 
              msgbus.$emit("alert", "Error", resp.error, 'error');
            else
              msgbus.$emit("alert", "Done", "Network Traffice Capture is started.", 'success');
          },
          error: function(data, status) {
            console.warn("get error to start capture:" + status);
            console.warn(data);
          },
          complete: function() {
            self.getSpinner().stop();
          }
        });
      },
    },
  }; //}}}1

  let trafficCaptureListComp = { //{{{1
    mixins: [progressUIMixin],
    template: '#traffic_capture_list_template',
    data: function() {
      window.captureFiles.sort( (first, second) => {
        return first.mtime > second.mtime  ? -1 : 1;
      });
      return {
        captureFiles: window.captureFiles.map( file => {
          file['selected'] = false
          return file
        }),
      };
    },
    methods: {
      formatDate: function(ts) {
        let d = new Date(ts*1000);
        return d.toLocaleDateString() + " " + d.toLocaleTimeString();
      },
      toggleSelectAll: function() {
        let allSelected = this.captureFiles.every( file => file.selected == true )
        this.captureFiles.forEach( file => file.selected = !allSelected )
      },
      selectInverse: function() {
        this.captureFiles.forEach( file => file.selected = !file.selected )
      },
      reload: function() {
        let self = this;
        $.ajax({
          url: "diagnose_utility.php",
          type: "GET",
          dataType: "json",
          data: { action: "listCaptures" },
          beforeSend: function() {
            self.getSpinner().spin(self.$el);
          },
          success: function(resp) {
            if (resp.redirect) {
              window.location.href = resp.redirect;
              return;
            }
            if (resp.error) 
              msgbus.$emit("alert", "Error", resp.error, 'error');
            else  {
              let captures = (resp.captures ?? []).map( file => { file.selected = false; return file } )
              captures.sort( (first, second) => first.mtime > second.mtime  ? -1 : 1 );
              self.captureFiles.splice(0, self.captureFiles.length, ...captures);
            }
          },
          error: function(data, status) {
            console.warn("get error to reload capture files:" + status);
            console.warn(data);
          },
          complete: function() {
            self.getSpinner().stop();
          }
        });
      },
      deleteSelected: function() {
        let selected = this.captureFiles.filter( file => file.selected )
        if (selected.length == 0)
          return;

        let self = this;
        $.ajax({
          url: "diagnose_utility.php",
          type: "POST",
          dataType: "json",
          data: {
            action: "deleteCaptures",
            captureFiles: selected.map( file => file.name )
          },
          beforeSend: function() {
            self.getSpinner().spin(self.$el);
          },
          success: function(resp) {
            if (resp.redirect) {
              window.location.href = resp.redirect;
              return;
            }
            if (resp.error) 
              msgbus.$emit("alert", "Error", resp.error, 'error');
            else {
              if (!resp.deletedCaptures) 
                return;

              resp.deletedCaptures.forEach( name => {
                let index = self.captureFiles.findIndex( file => file.name == name )
                if ( index != -1 ) self.captureFiles.splice(index, 1)
              });
            }
          },
          error: function(data, status) {
            console.warn("get error to delete capture file:" + status);
            console.warn(data);
          },
          complete: function() {
            self.getSpinner().stop();
          }
        });

      },
    },
  }; //}}}1

  let trafficCaptureComp = { //{{{1
    mixins: [progressUIMixin],
    template: '#traffic_capture_template',
    data: function() {
      return {}
    },
    methods: {
    },
    components: {
      'new-traffic-capture': newTrafficCaptureComp,
      'traffic-capture-list': trafficCaptureListComp,
    },
  }; //}}}1

  //create&init root object
  var app = new Vue({ //{{{1
    el: '#diagnose_utility_content',
    data: function() {
      let sections = [
        {sec_id: 'traffic-capture', name: 'Traffic Capture'},
      ];

      return {
        sections: sections,
        active_sec_id: _.first(sections).sec_id,
      }
    },
    methods: {
      isSectionActive: function(sec) { return sec.sec_id == this.active_sec_id; }
    },
    components: {
      'traffic-capture': trafficCaptureComp,
      'alert': alertComp,
    }
  }); //}}}1

});

// vim: foldmethod=marker
