<?php

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');
include_once "service_utils.php";
include_once "base_controller.php";

class DateTimeConfig extends BaseController {
  protected function signinRequired() {
    return true;
  }

  protected function featureId() {
    return basename(__DIR__);
  }

  protected function doAjaxGet() {
    $response = array();
    $action = "getTimeServer";
    if (isset($_GET['action']))
      $action = $_GET['action'];

    $platform = platformName(); 
    if ($platform == "FW")
      $this->doAjaxGetForFW2($action);
    else if ($platform == "FS")
      $this->doAjaxGetForFS($action);
    else
      $this->renderAjaxError($response, "invalid action: " . $action);
  }

  protected function doAjaxGetForFS($action) {
    $response = array();
    if (!$this->isNTPServiceEnabled())
      $this->renderAjaxError($response, "Please enable NTP service first");

    if ($action == "getTimeServer") {
      $data = array();

      $utils = new ServiceUtils();
      $serviceName = $utils->ntpServiceName();
      $cmd = "cat /etc/${serviceName}.conf | awk '/^\s*server|pool\s+/{print $2}'";
      $output = shell_exec($cmd);
      $servers = implode(",", array_filter(explode("\n", $output)));
      $data['timeServer'] = $servers;
      $response['config'] = $data;
      $this->renderAjaxSuccess2($response);
    } else {
      $this->renderAjaxError($response, "invalid action: " . $action);
    }
  }

  protected function doAjaxGetForFW($action) {
    $response = array();
    if ($action == "getTimeServer") {
      $data = array();
      $config = getPlatformConfig();
      if (isset($config['NtpHostname']))
        $data['timeServer'] = $config['NtpHostname'];
      if (isset($config['NtpUpdateFreq']))
        $data['updateInterval'] = $config['NtpUpdateFreq'];
      if (isset($config['NtpEnable']))
        $data['enableTimeSync'] = $config['NtpEnable'];
      $response['config'] = $data;
    } else if ($action == "getState") {
      $content = file_get_contents("/tmp/fwntp.state");
      if ($content) {
        $response['state'] = $content;
        $this->renderAjaxSuccess2($response);
      } else {
        $this->renderAjaxError($response, "Waiting for state ...");
      }
    } else {
      $this->renderAjaxError($response, "invalid action: " . $action);
    }
    $this->renderAjaxSuccess2($response);
  }

  // with this function, FW will use the same UI as FS
  protected function doAjaxGetForFW2($action) {
    $response = array();
    if (!$this->isNTPServiceEnabled())
      $this->renderAjaxError($response, "Please enable NTP service first");

    if ($action == "getTimeServer") {
      $data = array();

      $cmd = <<<EOC
        cat /etc/config/system | awk 'BEGIN{scope=0} /^config timeserver/,/^\s*$/ {
          if (/### FI NTP SERVER START ###$/) scope = 1; 
          if (/### FI NTP SERVER END ###$/) scope=0; 
          if (scope == 0 && /list server/) print $3 
        }'
EOC;

      $output = shell_exec($cmd);
      $servers = array_filter(explode("\n", $output));
      for($i=0; $i<count($servers); $i++) {
        $servers[$i] = trim($servers[$i], " \t\n\r\0\x0B'\"");
      }
      $servers = implode(",", $servers);
      $data['timeServer'] = $servers;
      $response['config'] = $data;
      $this->renderAjaxSuccess2($response);
    } else {
      $this->renderAjaxError($response, "invalid action: " . $action);
    }
  }

  protected function doAjaxPost() {
    $response = array();
    $action = "updateTimeServer";
    if (isset($_POST['action']))
      $action = $_POST['action']; 

    if ($action == "updateTimeServer") {
      $timeServer = $_POST['timeServer'];
      $platform = platformName();
      if ($platform == "FW") {
        // $updateInterval = $_POST['updateInterval'];
        // $enableTimeSync = $_POST['enableTimeSync'];
        if (!$this->updateTimeServerConfigFW2($timeServer))
          $this->renderAjaxError($response, "failed to save time server config");
      } else if ($platform == "FS") {
        if (!$this->updateTimeServerConfigFS($timeServer))
          $this->renderAjaxError($response, "failed to save time server config");
      } else {
        $this->renderAjaxError($response, "platform $platform is not supported");
      }
    } else if ($action == "syncDateTime") {
      $output = array();
      $return_var = null;
      exec("killall -s SIGUSR1 fwntp", $output, $return_var); 

      if ($return_var != 0) {
        error_log("failed to sync datetime");
        $this->renderAjaxError($response, "failed to sync datetime");
      }
    } else {
      $this->renderAjaxError($response, "invalid action: " . $action);
    }

    $this->renderAjaxSuccess2($response);
  }

  protected function updateTimeServerConfigFW($timeServer, $updateInterval, $enableTimeSync) {
    $config = getPlatformConfig();
    if (empty($config))
      return false;

    //assign timeserver configs
    if (is_null($timeServer))
      $timeServer = "time.windows.com";
    if (is_null($updateInterval))
      $updateInterval = 1;
    if (is_null($enableTimeSync))
      $enableTimeSync = 1;

    $config['NtpHostname'] = $timeServer;
    $config['NtpUpdateFreq'] = $updateInterval;
    $config['NtpEnable'] = $enableTimeSync;

    //write $config back to easyio.config file
    savePlatformConfig($config);

    //mostly for FW platform, after config change, call writeConfig to make
    //the change survive during firmware flashing
    if (file_exists("/mnt/sedona/writeConfig")) {
      $output = array();
      $return_var = 0;
      exec('/mnt/sedona/writeConfig', $output, $return_var);
      if ($return_var != 0)
        error_log("failed to run writeConfig: " . implode($output, "\n"));
    }

    return true;
  }
  protected function updateTimeServerConfigFW2($timeServer) {
    if (!$this->isNTPServiceEnabled())
      return false;

    $server = escapeshellarg($timeServer);

    $config = getPlatformConfig();
    if (!empty($config)) {
      $config['NtpHostname'] = $timeServer;
      savePlatformConfig($config);
    }

    $cmd = null;
    if (file_exists("/etc/init.d/ntpd")) {
      $cmd = <<<EOC
      sed -i -e "/^config timeserver/,/^\s*$/ {/### FI NTP SERVER START ###$/,/### FI NTP SERVER END ###$/!s/list server\s*'\([^']*\)'$/list server $server/}" /etc/config/system && /etc/init.d/ntpd restart
EOC;
    } else if (file_exists("/etc/init.d/chronyd")) {
      $cmd = <<<EOC
      sed -i -e "/^config timeserver/,/^\s*$/ {/### FI NTP SERVER START ###$/,/### FI NTP SERVER END ###$/!s/list server\s*'\([^']*\)'$/list server $server/}" /etc/config/system && sed -i -e "/^config pool/,/^\s*$/{/### FI NTP SERVER START ###$/,/### FI NTP SERVER END ###$/!s/option hostname '\([^']*\)'/option hostname $server/}" /etc/config/chrony && /etc/init.d/chronyd restart
EOC;
    } else {
      error_log("failed to build time server update command");
      return false;
    }

    $result = execShellCmd($cmd);

    //mostly for FW platform, after config change, call writeConfig to make
    //the change survive during firmware flashing
    if (file_exists("/mnt/sedona/writeConfig")) {
      $output = array();
      $return_var = 0;
      exec('/mnt/sedona/writeConfig', $output, $return_var);
      if ($return_var != 0)
        error_log("failed to run writeConfig: " . implode($output, "\n"));
    }
    return $result;
  }

  protected function updateTimeServerConfigFS($timeServer) {
    if (!$this->isNTPServiceEnabled())
      return false;

    $server = escapeshellarg($timeServer);

    $utils = new ServiceUtils();
    $serviceName = $utils->ntpServiceName();
    $confPath = "/etc/${serviceName}.conf"; 

    #GOTCHA: here have to use "'pool." because $server value has been escaped above
    $serverType = startsWith($server, "'pool.") ? 'pool' : 'server';
    // add new timeserver, and keep the possible FI time server
    $cmd = "sed -i.bak -e '1 i{$serverType} $server iburst' -e '/^### FI NTP SERVER START ###/,/^### FI NTP SERVER END ###/!s/^\(\s*server\|pool\s*\)/#\\1/}' $confPath && /etc/init.d/S??{$serviceName} restart";
    return execShellCmd($cmd);
  }

  protected function isNTPServiceEnabled() {
    $utils = new ServiceUtils();
    return $utils->isServiceEnabled($utils->ntpServiceName());
  }
}

$controller = new DateTimeConfig();
$controller->run();

?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8" />
    <title><?php $controller->echoPageTitle("Change DateTime") ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="<?php A('../../css/bootstrap.min.css') ?>" media="screen" />
    <link rel="stylesheet" href="<?php A('../../css/flatpickr.min.css') ?>" media="screen" />
    <link rel="stylesheet" href="<?php A('css/datetime_config.css') ?>" media="screen" />
    <?php $controller->faviconHTMLInfo() ?>
  </head>
  <body>
    <div class="container" id="datetime_config_content" v-cloak>
      <div class="navbar">
        <div class="navbar-inner">
          <a id="home_nav_btn" class="brand" href="<?php echo $controller->utilityUrl() ?>"><?php echo $controller->utilityLabel() ?></a>
          <ul class="nav">
            <li class="divider-vertical"></li>
            <li v-for="sec in sections" :class="{active:isSectionActive(sec)}"><a :href="'#' + sec.sec_id" @click="active_sec_id=sec.sec_id">{{ sec.name }}</a></li>
          </ul>
        </div>
      </div>

      <div class="tab-content">
        <div v-for="sec in sections" class="tab-pane" :class="{active:isSectionActive(sec)}">
          <keep-alive>
            <component :is="sec.sec_id"></component> 
          </keep-alive>
        </div>
      </div>
      
    </div>

    <script type="text/x-template" id="datetime-panel-template">
      <div class="row" id="datetime_form">
        <form class="form-horizontal">
          <div class="alert" v-show="error !== null" v-cloak>
            <button type="button" class="close" @click.prevent="error = null">&times;</button>
            <strong>Error:</strong> {{ error }}
          </div>
          <div class="control-group">
            <label class="control-label" for="inputDateTime">DateTime:</label>
            <div class="controls input-prepend input-append flatpickr" style="display:block">
              <span class='add-on' @click="fp && fp.toggle()"><i class='icon-calendar'></i></span>
              <input type="text" id="inputDateTime" style="width:140px;" placeholder="Select DateTime..." readonly>
              <span class='add-on'>{{tzAbbr}}</span>
            </div>
          </div>
          <div class="control-group">
            <label class="control-label" for="inputTimeZone">TimeZone:</label>
            <div class="controls" v-cloak>
              <select id="inputTimeZone" v-model="curTZ">
                <option v-for="tz in tz_list" :value="tz">
                  {{tz}}
                </option>
              </select>
            </div>
          </div>
          <div class="control-group">
            <label class="control-label" for="inputUTCOffset">UTC Offset:</label>
            <div class="controls">
              <input type="text" id="inputUTCOffset" disabled :value="utcOffsetStr">
            </div>
          </div>

          <!--
          <div class="control-group">
            <label class="control-label">UTC Offset Mode:</label>
            <div class="controls">
              <label class="radio inline">
              <input type="radio" name="UTCOffsetMode" v-model="utcOffsetMode" value="OS"> OS
              </label>
              <label class="radio inline">
              <input type="radio" name="UTCOffsetMode" v-model="utcOffsetMode" value="Configuration"> Configuration
              </label>
            </div>
          </div>
          -->

          <div class="control-group">
            <div class="controls pull-right">
              <button class="btn" @click.prevent="saveConfig">Save</button>
            </div>
          </div>
        </form>
      </div>
    </script>

    <script type="text/x-template" id="ntp-panel-template">
      <div class="row">
        <form class="form-horizontal">
          <div class="alert" v-show="error !== null" v-cloak>
            <button type="button" class="close" @click.prevent="error = null">&times;</button>
            <strong>Error:</strong> {{ error }}
          </div>
          <div class="alert" :class="[syncSuccess ? 'alert-success' : 'alert-error']" v-show="syncState !== null" v-cloak>
            <button type="button" class="close" @click.prevent="syncState = null">&times;</button>
            <strong>Sync Result:</strong> {{ syncState }}
          </div>
          <div class="control-group" v-if="iot_platform == 'FW' && fwSpecificUI">
            <div class="controls">
              <label class="checkbox">
                <input type="checkbox" v-model="enableTimeSync" true-value="1" false-value="0">Enable Network Time Sync
              </label>
            </div>
          </div>
          <div class="control-group" :class="{error: timeServerError}">
            <label class="control-label" for="inputTimeServer">Time Server:</label>
            <div class="controls">
              <input type="text" id="inputTimeServer" v-model.trim="timeServer">
              <span class="help-inline" v-show="timeServerError">Invalid Time Server Host</span>
            </div>
          </div>
          <div class="control-group" :class="{error: updateIntervalError}" v-if="iot_platform == 'FW' && fwSpecificUI">
            <label class="control-label" for="inputUpdateInterval">Update Interval:</label>
            <div class="controls">
              <div class="input-append">
                <input type="number" id="inputUpdateInterval" min="1" v-model.number="updateInterval">
                <span class="add-on">Hour</span>
              </div>
              <span class="help-inline" v-show="updateIntervalError">Update Interval must be a positive number</span>
            </div>
          </div>

          <div class="control-group">
            <div class="controls pull-right">
              <button class="btn btn-info" v-if="iot_platform == 'FW' && fwSpecificUI" :class="{disabled: enableTimeSync!='1'}" @click.prevent="syncDateTime">Sync</button>
              <button class="btn" @click.prevent="saveConfig">Save</button>
            </div>
          </div>
        </form>
      </div>
    </script>

    <script language="javascript" type="text/javascript">
      "use strict";
      window.iot_platform = '<?php echo platformName() ?>';

      window.in_iframe = window !== window.parent;
      if (window.in_iframe) {
        let elem = document.getElementById("home_nav_btn");
        if(elem) elem.setAttribute("href", "#");
      }
    </script>

    <script type="text/javascript" src="<?php A('../../js/spin.min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/jquery-1.10.0.min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/underscore-min.js') ?>"></script>

<?php
  if (isset($_GET["dev"])) {
?>
    <script type="text/javascript" src="<?php A('../../js/vue.js') ?>"></script>
<?php
  } else {
?>
    <script type="text/javascript" src="<?php A('../../js/vue.min.js') ?>"></script>
<?php
  }
?>

    <script type="text/javascript" src="<?php A('../../js/flatpickr.min.js') ?>"></script>

    <script type="text/javascript" src="<?php A('../../js/moment.min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/moment-timezone-2015-2025.min.js') ?>"></script>

    <script type="text/javascript" src="<?php A('js/datetime_config.js') ?>"></script>
  </body>
</html>
