<?php 
// vim: ts=2 sw=2

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');

include_once "base_controller.php";

class MQTTServiceBase extends BaseController {
  protected function signinRequired() {
    return true;
  }

  protected function featureId() {
    return basename(__DIR__);
  }

  public function isMQTTServiceEnabled() {
    $init_script_pattern = '';

    $pname = platformName();
    if ($pname == 'FS' || $pname == 'FI')
      $init_script_pattern = "/etc/init.d/S??mqtt-service";
    else if ($pname == 'FW')
      $init_script_pattern = "/etc/rc.d/S??mqtt-service";

    return !empty(glob($init_script_pattern));
  }

  protected function restartService($configFilePath) {
    execCmd('ln -sf '.$configFilePath.' /etc/mqtt-service.json');
    
    if (!$this->isMQTTServiceEnabled())
      return "MQTT service is disabled, please enable it first";

    $pfName = platformName();
    if ($pfName == "FS" || $pfName == "FI") {
      // if monit service exists, then use it; otherwise use init script
      `[ -e /usr/bin/monit ] && /usr/bin/monit restart mqtt-service || /etc/init.d/S91mqtt-service restart`;
    } else if ($pfName == "FW") {
      `[ -e /usr/bin/monit ] && /usr/bin/monit restart mqtt-service || /etc/init.d/mqtt-service restart`;
    } else {
      return "current platform is not supported";
    }
  }

  protected function notifyEvent($event) {
    if (!$this->isMQTTServiceEnabled())
      return "MQTT service is disabled, please enable it first";

    $pfName = platformName();
    if ($pfName == "FS" || $pfName == "FI") {
      $cmd = "/etc/init.d/S91mqtt-service ".$event;
    } else if ($pfName == "FW") {
      $cmd = "/etc/init.d/mqtt-service ".$event;
    }

    shell_exec($cmd);
  }

  public function notifyLoginSucceed() {
    $this->notifyEvent('auth_login');
  }

  public function notifyLoginFail() {
    $this->notifyEvent('auth_fail');
  }

  public function notifyShutdown() {
    $this->notifyEvent('force-quit');
  }
};
