"use strict";
// vim: ts=2 sw=2 foldmethod=marker
$(function () {
  //create&init root object
  window.app = new Vue({
    // {{{1
    el: '#log_viewer',
    data: {
      spinner: null,
      logLevels: {
        fatal: 6,
        error: 5,
        warn: 4,
        info: 3,
        debug: 2,
        trace: 1,
      },
      activeLogLevel: 3,
      rawLogs: [],
      reversed: true,
      filterStr: '',
    },
    mounted: function () {
      let helps = [
        '<div>Filter Expression Examples:</div>',
        "<div><strong>publish</strong>: only show logs with word 'publish'</div>",
        "<div><strong>publish google</strong>: show logs with both 'publish' and 'google'</div>",
        "<div><strong>publish -google</strong>: show logs with 'publish' but no 'google'</div>",
        "<div><strong>Publish</strong>: only show logs with word 'Publish'(case sensitive)</div>",
      ];
      $('#filter_help').popover({
        placement: 'bottom',
        html: true,
        content: helps.join(''),
      });
      this.refreshLog();
    },
    computed: {
      logs: function () {
        let lines = this.rawLogs;
        if (this.reversed) lines = lines.slice(0).reverse();
        let filters = this.filterStr.split(/\s+/);
        if (filters.length == 0) return lines;

        let self = this;
        return _.filter(lines, function (log) {
          return _.every(filters, function (f) {
            return self.isFilterMatched(f, log);
          });
        });
      },
      reversedLogLevels: function () {
        return _.object(_.values(this.logLevels), _.keys(this.logLevels));
      },
    },
    methods: {
      getSpinner: function () {
        if (!this.spinner) this.spinner = new Spinner();
        return this.spinner;
      },

      refreshLog: function () {
        var self = this;
        $.ajax({
          url: 'log_viewer.php?action=load_log',
          method: 'GET',
          dataType: 'json',
          beforeSend: function () {
            self.rawLogs.splice(0, self.rawLogs.length);
            self.getSpinner().spin(self.$el);
          },
          success: function (resp) {
            if (resp.redirect) redirect(resp.redirect);

            let false_line_sep =
              /\s*\n\s*(?!\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2} (TRACE|DEBUG|INFO|WARN|ERROR|FATAL))/gm;

            if (resp.log)
              self.rawLogs = resp.log
                .replaceAll(false_line_sep, '')
                .split('\n');
          },
          error: function (data, status) {
            console.warn('failed to load log: ' + data);
          },
          complete: function () {
            self.getSpinner().stop();
          },
        });
      },
      isLogLineVisible: function (log) {
        if (log.length <= 20) return false;

        var level = log.substring(20).split(' ')[0];
        if (!level) return false;

        level = level.toLowerCase();
        if (!(level in this.logLevels)) return false;

        var value = this.logLevels[level];
        return value >= this.activeLogLevel;
      },
      logLineStyle: function (log) {
        var cls = { 'log-line': true };
        if (log.length <= 20) return cls;

        var level = log.substring(20).split(' ')[0];
        if (level) cls['log-line-' + level.toLowerCase()] = true;
        return cls;
      },
      isFilterMatched: function (f, log) {
        let caseSensitive = /[A-Z]/.test(f);

        if (f.startsWith('-')) {
          if (f.length == 1) return true;
          if (caseSensitive) return !log.includes(f.substring(1));
          else return !log.toLowerCase().includes(f.substring(1).toLowerCase());
        } else {
          if (caseSensitive) return log.includes(f);
          else return log.toLowerCase().includes(f.toLowerCase());
        }
      },
    },
  }); //}}}1
});
